/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.cloud.synchroniser;

import com.thinkbuzan.chaos.networkservice.exception.CloudException;
import com.thinkbuzan.chaos.utilities.edtutilities.EDTUtilities;
import com.thinkbuzan.gaia.cloud.osgi.ServiceManager;
import com.thinkbuzan.gaia.ui.previewimages.MapThumbnailCache;
import com.thinkbuzan.gaia.ui.previewimages.ThumbnailFactory;
import com.thinkbuzan.pascal.cloud.connector.IFileConnector;
import com.thinkbuzan.pascal.cloud.listener.SynchronisationListener;
import com.thinkbuzan.pascal.cloud.model.CloudFile;
import com.thinkbuzan.pascal.cloud.model.MindMapSyncInfo;
import com.thinkbuzan.pascal.cloud.synchroniser.IFileManager;
import com.thinkbuzan.pascal.cloud.synchroniser.LocalFileManagerImpl;
import com.thinkbuzan.pascal.cloud.synchroniser.MapHandler;
import com.thinkbuzan.pascal.cloud.synchroniser.Synchroniser;
import com.thinkbuzan.pascal.services.cloud.ICloudData;
import com.thinkbuzan.pascal.services.cloud.ILocalData;
import com.thinkbuzan.pascal.services.cloud.ISynchronisationInfo;
import com.thinkbuzan.pascal.services.cloud.MapState;
import com.thinkbuzan.pascal.services.cloud.SyncState;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSynchroniser
implements Synchroniser {
    private final transient IFileConnector a;
    private final transient List<SynchronisationListener> b;
    private MapHandler c;
    private final transient IFileManager d;
    private static final String[] z;

    public AbstractSynchroniser(IFileConnector iFileConnector, IFileManager iFileManager) {
        this.a = iFileConnector;
        this.d = iFileManager;
        this.b = new ArrayList<SynchronisationListener>();
    }

    private void a(ICloudData iCloudData) {
        MindMapSyncInfo mindMapSyncInfo = new MindMapSyncInfo(iCloudData, SyncState.REMOTE_ONLY);
        this.d().addToMaps(mindMapSyncInfo);
    }

    protected final void a() throws CloudException {
        boolean bl = LocalFileManagerImpl.d;
        for (ISynchronisationInfo iSynchronisationInfo : this.getSafeSyncStates()) {
            if (iSynchronisationInfo.getState() == SyncState.SYNCHRONIZED_FAILED) {
                this.synchroniseMapData(iSynchronisationInfo.getMapId());
            }
            if (!bl) continue;
        }
    }

    private void a(ILocalData iLocalData, ICloudData iCloudData) {
        SyncState syncState;
        block3: {
            block2: {
                if (iLocalData.getState() != MapState.IGNORE) break block2;
                syncState = SyncState.IGNORE;
                if (!LocalFileManagerImpl.d) break block3;
            }
            syncState = this.c(iLocalData, iCloudData);
        }
        MindMapSyncInfo mindMapSyncInfo = new MindMapSyncInfo(iCloudData, iLocalData, syncState);
        this.d().addToMaps(mindMapSyncInfo);
        this.b(iLocalData, iCloudData);
    }

    private void b(ILocalData iLocalData, ICloudData iCloudData) {
        String string = iCloudData.getPrivilege();
        if (!iLocalData.getPrivileges().equals(string)) {
            iLocalData.setPrivileges(string);
            this.d.getRevisionManager().saveRevision(iLocalData);
        }
    }

    @Override
    public final void forceRemoteSynchronise(String string) throws CloudException {
        ISynchronisationInfo iSynchronisationInfo = this.d().getMap(string);
        iSynchronisationInfo.setState(SyncState.REMOTE_NEWER);
        this.synchroniseMap(iSynchronisationInfo);
        this.synchroniseMapData();
    }

    private SyncState c(ILocalData iLocalData, ICloudData iCloudData) {
        long l = iLocalData.getRevisionNum();
        long l2 = iLocalData.getLastSyncRevision();
        Long l3 = iCloudData.getRevision();
        if (l == l2 && l == l3) {
            return SyncState.SYNCHRONIZED;
        }
        if (l == l2 && l3 > l2) {
            return SyncState.REMOTE_NEWER;
        }
        if (l > l2 && (l2 == l3 || l3 == 1L)) {
            return SyncState.LOCAL_NEWER;
        }
        if (l != l2 && l3 != l2) {
            return SyncState.CONFLICT;
        }
        return SyncState.SYNCHRONIZED_FAILED;
    }

    public void synchroniseMap(ISynchronisationInfo iSynchronisationInfo) throws CloudException {
        boolean bl;
        boolean bl2 = LocalFileManagerImpl.d;
        if (iSynchronisationInfo != null && (bl = iSynchronisationInfo.isEnabledForSync())) {
            SyncState syncState = iSynchronisationInfo.getState();
            try {
                switch (syncState) {
                    case SYNCHRONIZED_FAILED: {
                        if (!bl2) break;
                    }
                    case SYNCHRONIZED: {
                        this.a(iSynchronisationInfo, SyncState.SYNCHRONIZED);
                        if (!bl2) break;
                    }
                    case SYNCHRONISING: {
                        if (!bl2) break;
                    }
                    case IGNORE: {
                        if (!bl2) break;
                    }
                    case CONFLICT: {
                        if (!bl2) break;
                    }
                    case LOCAL_NEWER: {
                        this.synchronizeLocalNewer(iSynchronisationInfo);
                        if (!bl2) break;
                    }
                    case REMOTE_NEWER: {
                        this.synchronizeRemoteNewer(iSynchronisationInfo);
                        if (!bl2) break;
                    }
                    case REMOTE_ONLY: {
                        this.c(iSynchronisationInfo);
                        if (!bl2) break;
                    }
                    case DELETED_ON_SERVER: {
                        this.b(iSynchronisationInfo);
                        if (!bl2) break;
                    }
                    default: {
                        throw new IllegalArgumentException(iSynchronisationInfo.getMapName() + " " + iSynchronisationInfo.getState());
                    }
                }
            }
            catch (CloudException cloudException) {
                this.a(iSynchronisationInfo, SyncState.SYNCHRONIZED_FAILED);
                throw cloudException;
            }
            finally {
                this.a(iSynchronisationInfo);
            }
        }
    }

    protected final void a(ISynchronisationInfo iSynchronisationInfo) {
        boolean bl = LocalFileManagerImpl.d;
        for (SynchronisationListener synchronisationListener : this.b) {
            synchronisationListener.synchroniseMapComplete(iSynchronisationInfo);
            if (!bl) continue;
        }
    }

    protected final boolean b() throws CloudException {
        if (ServiceManager.getSubscriptionSupport().isFreedomEnabled()) {
            return true;
        }
        return ServiceManager.getTimeManager().canSynchronise();
    }

    protected final void c() {
        boolean bl = LocalFileManagerImpl.d;
        for (SynchronisationListener synchronisationListener : this.b) {
            synchronisationListener.synchroniseMapsComplete();
            if (!bl) continue;
        }
    }

    protected final void a(int n) {
        boolean bl = LocalFileManagerImpl.d;
        for (SynchronisationListener synchronisationListener : this.b) {
            synchronisationListener.synchroniseMapsStart(n);
            if (!bl) continue;
        }
    }

    @Override
    public final void addSynchronisationListener(SynchronisationListener synchronisationListener) {
        this.b.add(synchronisationListener);
    }

    protected final void b(ISynchronisationInfo iSynchronisationInfo) throws CloudException {
        String string = iSynchronisationInfo.getMapId();
        this.d.deleteFile(iSynchronisationInfo.getServer());
        ILocalData iLocalData = iSynchronisationInfo.getLocal();
        if (iSynchronisationInfo.getLocal() != null) {
            MapThumbnailCache mapThumbnailCache = (MapThumbnailCache)ThumbnailFactory.getThumbnailCache((ThumbnailFactory.Cache)ThumbnailFactory.Cache.MAP);
            mapThumbnailCache.deleteThumbnail(iLocalData);
        }
        this.d.getRevisionManager().deleteRevisionById(string);
        this.c.removeFromMaps(string);
    }

    private void c(ISynchronisationInfo iSynchronisationInfo) throws CloudException {
        block5: {
            CloudFile cloudFile;
            ICloudData iCloudData;
            block4: {
                iCloudData = iSynchronisationInfo.getServer();
                cloudFile = this.d.getFile(iCloudData);
                this.a(iSynchronisationInfo, SyncState.SYNCHRONISING);
                String string = cloudFile.getAbsolutePath();
                long l = this.getFileControl().get(iCloudData, string);
                if (l != -1L) break block4;
                this.a(iSynchronisationInfo, SyncState.SYNCHRONIZED_FAILED);
                if (!LocalFileManagerImpl.d) break block5;
            }
            try {
                ILocalData iLocalData = this.getFileManager().getRevisionManager().createNewRevision(cloudFile, iCloudData);
                iSynchronisationInfo.setLocal(iLocalData);
                this.getFileManager().getRevisionManager().saveRevision(iLocalData);
                this.a(iSynchronisationInfo, SyncState.SYNCHRONIZED);
            }
            catch (IOException iOException) {
                this.a(iSynchronisationInfo, SyncState.SYNCHRONIZED_FAILED);
            }
        }
    }

    public final void synchronizeRemoteNewer(ISynchronisationInfo iSynchronisationInfo) throws CloudException {
        block4: {
            long l;
            CloudFile cloudFile;
            ILocalData iLocalData;
            ICloudData iCloudData;
            block3: {
                iCloudData = iSynchronisationInfo.getServer();
                iLocalData = iSynchronisationInfo.getLocal();
                cloudFile = this.d.getFile(iCloudData);
                this.a(iSynchronisationInfo, SyncState.SYNCHRONISING);
                l = this.getFileControl().get(iCloudData, cloudFile.getAbsolutePath());
                if (l != -1L) break block3;
                this.a(iSynchronisationInfo, SyncState.SYNCHRONIZED_FAILED);
                if (!LocalFileManagerImpl.d) break block4;
            }
            iLocalData.setFolderId(iCloudData.getFolderId());
            iLocalData.setRevisionNum(l);
            iLocalData.setLastSyncRevision((long)iCloudData.getRevision().intValue());
            iLocalData.setFileName(iCloudData.getMapId() + z[0]);
            try {
                iLocalData.setHash(cloudFile.getHashValue());
            }
            catch (IOException iOException) {
                throw new CloudException((Exception)iOException);
            }
            iLocalData.setMapName(iCloudData.getName());
            this.getFileManager().getRevisionManager().saveRevision(iLocalData);
            this.a(iSynchronisationInfo, SyncState.SYNCHRONIZED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void synchronizeLocalNewer(ISynchronisationInfo iSynchronisationInfo) throws CloudException {
        block12: {
            File file = this.getFileManager().getFile(iSynchronisationInfo);
            File file2 = null;
            try {
                file2 = File.createTempFile(z[1], z[2]);
                FileUtils.copyFile((File)file, (File)file2);
                this.a(iSynchronisationInfo, SyncState.SYNCHRONISING);
                AbstractSynchroniser abstractSynchroniser = this;
                synchronized (abstractSynchroniser) {
                    block13: {
                        boolean bl = this.a(iSynchronisationInfo, file);
                        if (!bl) break block13;
                        this.a(iSynchronisationInfo, SyncState.SYNCHRONIZED);
                        if (!LocalFileManagerImpl.d) break block12;
                    }
                    this.a(iSynchronisationInfo, SyncState.SYNCHRONIZED_FAILED);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (file2 != null && file2.exists()) {
                    FileUtils.deleteQuietly((File)file2);
                }
            }
        }
    }

    private boolean a(ISynchronisationInfo iSynchronisationInfo, File file) throws CloudException, IOException {
        boolean bl = false;
        ICloudData iCloudData = this.getFileControl().upload(iSynchronisationInfo, file);
        if (iCloudData != null) {
            CloudFile cloudFile = this.d.getFile(iCloudData);
            ILocalData iLocalData = this.d.getRevisionManager().createNewRevision(cloudFile, iCloudData);
            this.d.getRevisionManager().saveRevision(iLocalData);
            MindMapSyncInfo mindMapSyncInfo = new MindMapSyncInfo(iCloudData, iLocalData, SyncState.SYNCHRONIZED);
            this.c.addToMaps(mindMapSyncInfo);
            bl = true;
        }
        return bl;
    }

    protected final void d(ISynchronisationInfo iSynchronisationInfo) {
        boolean bl = LocalFileManagerImpl.d;
        for (SynchronisationListener synchronisationListener : this.b) {
            block4: {
                block3: {
                    if (iSynchronisationInfo != null) break block3;
                    synchronisationListener.notifyDataSynchronised();
                    if (!bl) break block4;
                }
                synchronisationListener.notifyDataSynchronised(iSynchronisationInfo);
            }
            if (!bl) continue;
        }
    }

    protected final void a(final ISynchronisationInfo iSynchronisationInfo, final SyncState syncState) {
        EDTUtilities.runOnEDT((Runnable)new Runnable(){

            public void run() {
                if (iSynchronisationInfo != null) {
                    iSynchronisationInfo.setState(syncState);
                    this.a(iSynchronisationInfo);
                }
            }

            private void a(ISynchronisationInfo iSynchronisationInfo2) {
                boolean bl = LocalFileManagerImpl.d;
                for (SynchronisationListener synchronisationListener : AbstractSynchroniser.this.b) {
                    synchronisationListener.mapStateUpdated(iSynchronisationInfo2);
                    if (!bl) continue;
                }
            }
        });
    }

    protected final void b(ICloudData iCloudData) throws IOException {
        block4: {
            ILocalData iLocalData;
            block2: {
                boolean bl;
                block3: {
                    bl = LocalFileManagerImpl.d;
                    String string = iCloudData.getMapId();
                    iLocalData = this.getFileManager().getRevisionManager().getRevision(string);
                    CloudFile cloudFile = this.d.getFile(iCloudData);
                    if (iLocalData != null) break block2;
                    if (!cloudFile.exists()) break block3;
                    ILocalData iLocalData2 = this.getFileManager().getRevisionManager().createNewRevision(cloudFile, iCloudData);
                    this.getFileManager().getRevisionManager().saveRevision(iLocalData2);
                    this.a(iLocalData2, iCloudData);
                    if (!bl) break block4;
                }
                this.a(iCloudData);
                if (!bl) break block4;
            }
            this.a(iLocalData, iCloudData);
        }
    }

    public final IFileManager getFileManager() {
        return this.d;
    }

    public final List<ISynchronisationInfo> getSafeSyncStates() {
        return this.d().getSafeSyncStates();
    }

    public final IFileConnector getFileControl() {
        return this.a;
    }

    @Override
    public abstract void synchroniseMaps() throws CloudException;

    public final void handleMapsDeletedOnServer(List<ICloudData> list) {
        boolean bl = LocalFileManagerImpl.d;
        ArrayList<ISynchronisationInfo> arrayList = new ArrayList<ISynchronisationInfo>();
        CopyOnWriteArrayList<ISynchronisationInfo> copyOnWriteArrayList = new CopyOnWriteArrayList<ISynchronisationInfo>(this.getSafeSyncStates());
        for (ISynchronisationInfo iSynchronisationInfo : copyOnWriteArrayList) {
            for (ICloudData iCloudData : list) {
                if (iCloudData.getMapId().equals(iSynchronisationInfo.getMapId())) {
                    arrayList.add(iSynchronisationInfo);
                    if (!bl) break;
                }
                if (!bl) continue;
            }
            if (!bl) continue;
        }
        copyOnWriteArrayList.removeAll(arrayList);
        for (ISynchronisationInfo iSynchronisationInfo : copyOnWriteArrayList) {
            iSynchronisationInfo.setState(SyncState.DELETED_ON_SERVER);
            this.a(iSynchronisationInfo, SyncState.DELETED_ON_SERVER);
            if (!bl) continue;
        }
    }

    protected final void a(MapHandler mapHandler) {
        this.c = mapHandler;
    }

    protected final MapHandler d() {
        return this.c;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block32: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block31: {
                char[] cArray3;
                Object var0;
                block30: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block29: {
                        char[] cArray5;
                        block28: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block27: {
                                stringArray = new String[3];
                                var0 = null;
                                char[] cArray7 = "%N\u0010R".toCharArray();
                                n3 = 0;
                                int n8 = cArray7.length;
                                cArray6 = cArray7;
                                n7 = n8;
                                if (n8 <= 1) break block27;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block28;
                            }
                            do {
                                char[] cArray8 = cArray6;
                                char[] cArray9 = cArray6;
                                int n9 = n3;
                                while (true) {
                                    int n10;
                                    char c = cArray8[n9];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n10 = 11;
                                            break;
                                        }
                                        case 1: {
                                            n10 = 39;
                                            break;
                                        }
                                        case 2: {
                                            n10 = 125;
                                            break;
                                        }
                                        case 3: {
                                            n10 = 42;
                                            break;
                                        }
                                        default: {
                                            n10 = 89;
                                        }
                                    }
                                    cArray8[n9] = (char)(c ^ n10);
                                    ++n3;
                                    cArray6 = cArray9;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray9 = cArray6;
                                    n6 = n7;
                                    n9 = n7;
                                    cArray8 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        stringArray[0] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray10 = "mN\u0011O*rI\u001e".toCharArray();
                        n3 = 0;
                        int n11 = cArray10.length;
                        cArray4 = cArray10;
                        n5 = n11;
                        if (n11 <= 1) break block29;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block30;
                    }
                    do {
                        char[] cArray11 = cArray4;
                        char[] cArray12 = cArray4;
                        int n12 = n3;
                        while (true) {
                            int n13;
                            char c = cArray11[n12];
                            switch (n3 % 5) {
                                case 0: {
                                    n13 = 11;
                                    break;
                                }
                                case 1: {
                                    n13 = 39;
                                    break;
                                }
                                case 2: {
                                    n13 = 125;
                                    break;
                                }
                                case 3: {
                                    n13 = 42;
                                    break;
                                }
                                default: {
                                    n13 = 89;
                                }
                            }
                            cArray11[n12] = (char)(c ^ n13);
                            ++n3;
                            cArray4 = cArray12;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray12 = cArray4;
                            n4 = n5;
                            n12 = n5;
                            cArray11 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[1] = new String(cArray3).intern();
                var0 = null;
                char[] cArray13 = "oF\t".toCharArray();
                n3 = 0;
                int n14 = cArray13.length;
                cArray2 = cArray13;
                n2 = n14;
                if (n14 <= 1) break block31;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block32;
            }
            do {
                char[] cArray14 = cArray2;
                char[] cArray15 = cArray2;
                int n15 = n3;
                while (true) {
                    int n16;
                    char c = cArray14[n15];
                    switch (n3 % 5) {
                        case 0: {
                            n16 = 11;
                            break;
                        }
                        case 1: {
                            n16 = 39;
                            break;
                        }
                        case 2: {
                            n16 = 125;
                            break;
                        }
                        case 3: {
                            n16 = 42;
                            break;
                        }
                        default: {
                            n16 = 89;
                        }
                    }
                    cArray14[n15] = (char)(c ^ n16);
                    ++n3;
                    cArray2 = cArray15;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray15 = cArray2;
                    n = n2;
                    n15 = n2;
                    cArray14 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[2] = new String(cArray).intern();
        z = stringArray;
    }
}

