/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.cloud.synchroniser;

import com.thinkbuzan.chaos.networkservice.exception.CloudException;
import com.thinkbuzan.gaia.cloud.osgi.ServiceManager;
import com.thinkbuzan.gaia.onlineaccountaccessclient.OnlineAccountAccessClient;
import com.thinkbuzan.gaia.onlineaccountaccessclient.OnlineListener;
import com.thinkbuzan.pascal.cloud.model.CloudFile;
import com.thinkbuzan.pascal.cloud.model.LocalData;
import com.thinkbuzan.pascal.cloud.synchroniser.IFileSystem;
import com.thinkbuzan.pascal.cloud.synchroniser.LocalDataManager;
import com.thinkbuzan.pascal.cloud.synchroniser.LocalFileManagerImpl;
import com.thinkbuzan.pascal.cloud.synchroniser.RevisionManager;
import com.thinkbuzan.pascal.cloud.synchroniser.RevisionOnlineListener;
import com.thinkbuzan.pascal.services.cloud.ICloudData;
import com.thinkbuzan.pascal.services.cloud.ILocalData;
import com.thinkbuzan.pascal.services.cloud.MapState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionManagerImpl
implements RevisionManager {
    private final transient LocalDataManager a;
    private transient List<ILocalData> b;
    private final transient OnlineAccountAccessClient c;
    private final transient IFileSystem d;
    private static final String[] z;

    public RevisionManagerImpl(LocalDataManager localDataManager, OnlineAccountAccessClient onlineAccountAccessClient, IFileSystem iFileSystem) {
        this.d = iFileSystem;
        this.a = localDataManager;
        this.c = onlineAccountAccessClient;
        this.initialiseLocalRevisions();
        this.c.addOnlineListener((OnlineListener)new RevisionOnlineListener(this));
    }

    @Override
    public final void initialiseLocalRevisions() {
        String string = this.c.getUsername();
        if (string != null) {
            this.b = this.a(string);
        }
    }

    private List<ILocalData> a(String string) {
        return this.a.getMindMapRevisions(string);
    }

    public final void addRevision(ILocalData iLocalData) {
        this.b.add(iLocalData);
        this.a(this.b);
    }

    @Override
    public final void deleteRevisionById(String string) {
        boolean bl = LocalFileManagerImpl.d;
        ArrayList<ILocalData> arrayList = new ArrayList<ILocalData>();
        CopyOnWriteArrayList<ILocalData> copyOnWriteArrayList = new CopyOnWriteArrayList<ILocalData>(this.b);
        for (ILocalData iLocalData : copyOnWriteArrayList) {
            if (iLocalData.getMindMapId().equals(string)) {
                arrayList.add(iLocalData);
            }
            if (!bl) continue;
        }
        if (!arrayList.isEmpty()) {
            for (ILocalData iLocalData : arrayList) {
                this.b.remove(iLocalData);
                if (!bl) continue;
            }
            this.a(this.b);
        }
    }

    @Override
    public final List<ILocalData> getAllLocalRevisions() {
        return this.b;
    }

    @Override
    public final void saveRevision(ILocalData iLocalData) {
        String string = iLocalData.getMindMapId();
        this.deleteRevisionById(string);
        this.addRevision(iLocalData);
    }

    private void a(List<ILocalData> list) {
        String string = this.c.getUsername();
        this.a.saveMindMapRevisions(string, list);
    }

    @Override
    public final void tidyLocalFiles() throws CloudException {
        boolean bl = LocalFileManagerImpl.d;
        ArrayList<ILocalData> arrayList = new ArrayList<ILocalData>();
        this.initialiseLocalRevisions();
        CopyOnWriteArrayList<ILocalData> copyOnWriteArrayList = new CopyOnWriteArrayList<ILocalData>(this.b);
        for (ILocalData iLocalData : copyOnWriteArrayList) {
            block4: {
                block3: {
                    CloudFile cloudFile = this.a(iLocalData);
                    if (!cloudFile.exists()) break block3;
                    if (!cloudFile.isFile()) break block4;
                    this.a(iLocalData, cloudFile);
                    if (!bl) break block4;
                }
                arrayList.add(iLocalData);
            }
            if (!bl) continue;
        }
        this.b.removeAll(arrayList);
        this.a(this.b);
    }

    private CloudFile a(ILocalData iLocalData) {
        return new CloudFile(this.d.getBaseFile(), iLocalData.getFileName());
    }

    private void a(ILocalData iLocalData, CloudFile cloudFile) throws CloudException {
        try {
            String string = cloudFile.getHashValue();
            if (!string.equals(iLocalData.getHash())) {
                iLocalData.setHash(string);
                iLocalData.incrementRevisionNum();
            }
        }
        catch (IOException iOException) {
            throw new CloudException((Exception)iOException);
        }
    }

    @Override
    public final ILocalData createNewRevision(CloudFile cloudFile, ICloudData iCloudData) throws IOException {
        boolean bl = LocalFileManagerImpl.d;
        RevisionManagerImpl.a(cloudFile, iCloudData);
        LocalData localData = new LocalData();
        localData.setRevisionNum(iCloudData.getRevision().intValue());
        localData.setLastSyncRevision(iCloudData.getRevision().intValue());
        localData.setMindMapId(iCloudData.getMapId());
        localData.setFolderId(iCloudData.getFolderId());
        localData.setMapName(iCloudData.getName());
        localData.setFileSize(iCloudData.getFileSize());
        localData.setPrivileges(iCloudData.getPrivilege());
        localData.setHash(cloudFile.getHashValue());
        String string = iCloudData.getMapId() + z[0];
        localData.setFileName(string);
        localData.setState(MapState.CONTROL);
        if (bl) {
            int n = ServiceManager.t;
            ServiceManager.t = ++n;
        }
        return localData;
    }

    private static void a(Object ... objectArray) throws IOException {
        boolean bl = LocalFileManagerImpl.d;
        for (Object object : objectArray) {
            if (object == null) {
                throw new IOException(z[2]);
            }
            if (!(object instanceof String) || !"".equals(object)) continue;
            throw new IOException(z[1]);
        }
    }

    @Override
    public final ILocalData getRevision(String string) {
        boolean bl = LocalFileManagerImpl.d;
        CopyOnWriteArrayList<ILocalData> copyOnWriteArrayList = new CopyOnWriteArrayList<ILocalData>(this.b);
        for (ILocalData iLocalData : copyOnWriteArrayList) {
            String string2 = iLocalData.getMindMapId();
            if (string.equals(string2)) {
                return iLocalData;
            }
            if (!bl) continue;
        }
        return null;
    }

    @Override
    public final void clearLocalRevisions() {
        if (this.b != null) {
            this.b.clear();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block32: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block31: {
                char[] cArray3;
                Object var0;
                block30: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block29: {
                        char[] cArray5;
                        block28: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block27: {
                                stringArray = new String[3];
                                var0 = null;
                                char[] cArray7 = "/\r3M".toCharArray();
                                n3 = 0;
                                int n8 = cArray7.length;
                                cArray6 = cArray7;
                                n7 = n8;
                                if (n8 <= 1) break block27;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block28;
                            }
                            do {
                                char[] cArray8 = cArray6;
                                char[] cArray9 = cArray6;
                                int n9 = n3;
                                while (true) {
                                    int n10;
                                    char c = cArray8[n9];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n10 = 1;
                                            break;
                                        }
                                        case 1: {
                                            n10 = 100;
                                            break;
                                        }
                                        case 2: {
                                            n10 = 94;
                                            break;
                                        }
                                        case 3: {
                                            n10 = 53;
                                            break;
                                        }
                                        default: {
                                            n10 = 41;
                                        }
                                    }
                                    cArray8[n9] = (char)(c ^ n10);
                                    ++n3;
                                    cArray6 = cArray9;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray9 = cArray6;
                                    n6 = n7;
                                    n9 = n7;
                                    cArray8 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        stringArray[0] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray10 = "R\u0010,\\GfD)TZ!\u00013E]xD=GL`\u00107[N!\u00010A[xD7[On".toCharArray();
                        n3 = 0;
                        int n11 = cArray10.length;
                        cArray4 = cArray10;
                        n5 = n11;
                        if (n11 <= 1) break block29;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block30;
                    }
                    do {
                        char[] cArray11 = cArray4;
                        char[] cArray12 = cArray4;
                        int n12 = n3;
                        while (true) {
                            int n13;
                            char c = cArray11[n12];
                            switch (n3 % 5) {
                                case 0: {
                                    n13 = 1;
                                    break;
                                }
                                case 1: {
                                    n13 = 100;
                                    break;
                                }
                                case 2: {
                                    n13 = 94;
                                    break;
                                }
                                case 3: {
                                    n13 = 53;
                                    break;
                                }
                                default: {
                                    n13 = 41;
                                }
                            }
                            cArray11[n12] = (char)(c ^ n13);
                            ++n3;
                            cArray4 = cArray12;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray12 = cArray4;
                            n4 = n5;
                            n12 = n5;
                            cArray11 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[1] = new String(cArray3).intern();
                var0 = null;
                char[] cArray13 = "Q\u0005,TDd\u0010;G\tv\u0005-\u0015Gt\b2\u0015Js\u0001?A@o\u0003~PGu\u0016'\u0015@o\u00021".toCharArray();
                n3 = 0;
                int n14 = cArray13.length;
                cArray2 = cArray13;
                n2 = n14;
                if (n14 <= 1) break block31;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block32;
            }
            do {
                char[] cArray14 = cArray2;
                char[] cArray15 = cArray2;
                int n15 = n3;
                while (true) {
                    int n16;
                    char c = cArray14[n15];
                    switch (n3 % 5) {
                        case 0: {
                            n16 = 1;
                            break;
                        }
                        case 1: {
                            n16 = 100;
                            break;
                        }
                        case 2: {
                            n16 = 94;
                            break;
                        }
                        case 3: {
                            n16 = 53;
                            break;
                        }
                        default: {
                            n16 = 41;
                        }
                    }
                    cArray14[n15] = (char)(c ^ n16);
                    ++n3;
                    cArray2 = cArray15;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray15 = cArray2;
                    n = n2;
                    n15 = n2;
                    cArray14 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[2] = new String(cArray).intern();
        z = stringArray;
    }
}

