/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.utilities.awtutilities;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectiveAWTUtilities {
    private static final String TRANSLUCENCY_CLASS_NAME = "com.sun.awt.AWTUtilities$Translucency";
    private static final String AWT_UTILITIES_CLASS_NAME = "com.sun.awt.AWTUtilities";
    private static final transient Logger LOGGER = Logger.getLogger(ReflectiveAWTUtilities.class);

    private ReflectiveAWTUtilities() {
    }

    public static boolean isTranslucencySupported(Translucency paramTranslucency) {
        return ReflectiveAWTUtilities.invoke("isTranslucencySupported", new Class[]{Translucency.class}, new Object[]{paramTranslucency}, false);
    }

    public static void setWindowOpacity(Window paramWindow, float paramFloat) {
        ReflectiveAWTUtilities.invoke("setWindowOpacity", new Class[]{Window.class, Float.TYPE}, new Object[]{paramWindow, Float.valueOf(paramFloat)}, null);
    }

    public static float getWindowOpacity(Window paramWindow) {
        return ReflectiveAWTUtilities.invoke("getWindowOpacity", new Class[]{Window.class}, new Object[]{paramWindow}, Float.valueOf(1.0f)).floatValue();
    }

    public static Shape getWindowShape(Window paramWindow) {
        return ReflectiveAWTUtilities.invoke("getWindowShape", new Class[]{Window.class}, new Object[]{paramWindow}, null);
    }

    public static void setWindowShape(Window paramWindow, Shape paramShape) {
        ReflectiveAWTUtilities.invoke("setWindowShape", new Class[]{Window.class, Shape.class}, new Object[]{paramWindow, paramShape}, null);
    }

    public static void setWindowOpaque(Window paramWindow, boolean paramBoolean) {
        ReflectiveAWTUtilities.invoke("setWindowOpaque", new Class[]{Window.class, Boolean.TYPE}, new Object[]{paramWindow, paramBoolean}, null);
    }

    public static boolean isWindowOpaque(Window paramWindow) {
        return ReflectiveAWTUtilities.invoke("isWindowOpaque", new Class[]{Window.class}, new Object[]{paramWindow}, true);
    }

    public static boolean isTranslucencyCapable(GraphicsConfiguration paramGraphicsConfiguration) {
        return ReflectiveAWTUtilities.invoke("isTranslucencyCapable", new Class[]{GraphicsConfiguration.class}, new Object[]{paramGraphicsConfiguration}, false);
    }

    public static void setComponentMixingCutoutShape(Component paramComponent, Shape paramShape) {
        ReflectiveAWTUtilities.invoke("setComponentMixingCutoutShape", new Class[]{Component.class, Shape.class}, new Object[]{paramComponent, paramShape}, null);
    }

    private static <T> T invoke(String methodName, Class<?>[] parameterTypes, Object[] parameters, T defaultValue) {
        try {
            Class<?> awtUtilitiesClass = Class.forName(AWT_UTILITIES_CLASS_NAME);
            Method method = awtUtilitiesClass.getMethod(methodName, ReflectiveAWTUtilities.translateParameterTypes(parameterTypes));
            return (T)method.invoke(null, ReflectiveAWTUtilities.translateParameters(parameters));
        }
        catch (Exception exception) {
            String message = "Caught exception when trying to invoke a com.sun.awt.AWTUtilities method (methodName=%s, parameterTypes=%s, parameters=%s, defaultValue=%s)";
            message = String.format(message, methodName, parameterTypes, parameters, defaultValue);
            LOGGER.warn((Object)message, (Throwable)exception);
            return defaultValue;
        }
    }

    private static Class<?>[] translateParameterTypes(Class<?> ... typeParameters) throws ClassNotFoundException {
        for (int i = 0; i < typeParameters.length; ++i) {
            if (typeParameters[i] != Translucency.class) continue;
            typeParameters[i] = Class.forName(TRANSLUCENCY_CLASS_NAME);
        }
        return typeParameters;
    }

    private static Object[] translateParameters(Object ... parameters) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        for (int i = 0; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof Translucency)) continue;
            Class<?> translucencyClass = Class.forName(TRANSLUCENCY_CLASS_NAME);
            String fieldName = ((Translucency)((Object)parameters[i])).name();
            Field field = translucencyClass.getField(fieldName);
            parameters[i] = field.get(null);
        }
        return parameters;
    }

    public static GraphicsConfiguration getTranslucencyCapableGraphicsConfiguration() {
        GraphicsDevice[] devices;
        GraphicsConfiguration capableConfiguration = null;
        for (GraphicsDevice device : devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration[] configurations;
            for (GraphicsConfiguration configuration : configurations = device.getConfigurations()) {
                boolean capable = ReflectiveAWTUtilities.isTranslucencyCapable(configuration);
                if (!capable) continue;
                capableConfiguration = configuration;
                break;
            }
            if (capableConfiguration != null) break;
        }
        return capableConfiguration;
    }

    public static boolean isAvailable() {
        String osName = System.getProperty("os.name");
        if (osName != null && osName.indexOf("Windows XP") != -1) {
            return false;
        }
        try {
            return Class.forName(AWT_UTILITIES_CLASS_NAME) != null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"[INFORMATION] ReflectiveAWTUTilities is not available");
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Translucency {
        PERPIXEL_TRANSPARENT,
        TRANSLUCENT,
        PERPIXEL_TRANSLUCENT;

    }
}

