/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.utilities.edtutilities;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class EDTUtilities {
    private static final transient Logger LOGGER = Logger.getLogger(EDTUtilities.class);

    private EDTUtilities() {
    }

    public static final void runOnEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static final void runOnEDTBlock(Runnable runnable) {
        FutureTask<Object> task = new FutureTask<Object>(runnable, null);
        EDTUtilities.runOnEDT(task);
        while (!task.isDone()) {
            try {
                try {
                    task.get(60L, TimeUnit.SECONDS);
                }
                catch (TimeoutException exception) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn((Object)"Caught TimeoutException when using EDTUtilities.runOnEDTBlock(Runnable)", (Throwable)exception);
                    }
                    task.get();
                }
            }
            catch (InterruptedException exception) {
                if (!LOGGER.isErrorEnabled()) continue;
                LOGGER.error((Object)"Caught InterruptedException", (Throwable)exception);
            }
            catch (ExecutionException exception) {
                if (!LOGGER.isErrorEnabled()) continue;
                LOGGER.error((Object)"Caught ExecutionException", (Throwable)exception);
            }
        }
    }
}

