/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.utilities.io;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DiskResourceManager {
    private static Logger LOGGER = Logger.getLogger(DiskResourceManager.class);

    public static boolean isUnpackRequired(ClassLoader resourceLoader, String fileSystemBaseFolder, String qualifiedResourcePath) {
        File contentsOnDisk = new File(fileSystemBaseFolder + File.separatorChar + qualifiedResourcePath);
        URL contentsInJAR = resourceLoader.getResource(qualifiedResourcePath);
        if (contentsInJAR == null) {
            throw new IllegalArgumentException("The resource " + qualifiedResourcePath + " could not be read using the supplied classloader [" + resourceLoader + "]");
        }
        return DiskResourceManager.isContentsOnDiskOutOfDate(contentsOnDisk, contentsInJAR);
    }

    public static boolean isUnpackRequired(URL resourceURL, String fileSystemBaseFolder, String qualifiedResourcePath) {
        File contentsOnDisk = new File(fileSystemBaseFolder + File.separatorChar + qualifiedResourcePath);
        URL contentsInJAR = resourceURL;
        if (contentsInJAR == null) {
            throw new IllegalArgumentException("The resource " + qualifiedResourcePath + " could not be read using the supplied URL [" + resourceURL + "]");
        }
        return DiskResourceManager.isContentsOnDiskOutOfDate(contentsOnDisk, contentsInJAR);
    }

    private static boolean isContentsOnDiskOutOfDate(File contentsOnDisk, URL contentsInJAR) {
        boolean outOfDate = true;
        if (contentsOnDisk.exists()) {
            URLConnection conn = null;
            try {
                conn = contentsInJAR.openConnection();
                if (contentsOnDisk.lastModified() >= conn.getLastModified()) {
                    outOfDate = false;
                }
            }
            catch (IOException ex) {
                LOGGER.log((Priority)Level.WARN, (Object)("Cant access contents in jar. URL:" + contentsInJAR.getPath()), (Throwable)ex);
            }
        }
        return outOfDate;
    }
}

