/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.utilities.io;

import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class RelativeFileUtilities {
    private static final transient Logger LOGGER = Logger.getLogger(RelativeFileUtilities.class);

    public static File convertToRelative(File absoluteFile, File baseDirectory) {
        if (absoluteFile == null) {
            throw new IllegalArgumentException("absoluteFile must not be null");
        }
        if (baseDirectory == null) {
            throw new IllegalArgumentException("baseDirectory must not be null");
        }
        RelativeFileUtilities.logRelativeInputFiles(absoluteFile, baseDirectory);
        absoluteFile = RelativeFileUtilities.getCanonicalFile(absoluteFile);
        baseDirectory = RelativeFileUtilities.getCanonicalFile(baseDirectory);
        int numberOfDoubleDotFolders = 0;
        File commonDirectory = baseDirectory;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("convertToRelative(absoluteFile=\"%s\", baseDirectory=\"%s\")", absoluteFile, baseDirectory));
        }
        if (absoluteFile.getAbsolutePath().equals(baseDirectory.getAbsolutePath())) {
            return new File(".");
        }
        while (commonDirectory != null && !absoluteFile.getAbsolutePath().startsWith(commonDirectory.getAbsolutePath())) {
            commonDirectory = commonDirectory.getParentFile();
            ++numberOfDoubleDotFolders;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("commonDirectory = \"%s\"", commonDirectory));
            LOGGER.debug((Object)String.format("numberOfDoubleDotFolders = %s", numberOfDoubleDotFolders));
        }
        if (commonDirectory != null) {
            StringBuffer prefix = new StringBuffer();
            for (int i = 0; i < numberOfDoubleDotFolders; ++i) {
                prefix.append("..").append(File.separator);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("prefix = \"%s\"", prefix));
            }
            String toStrip = commonDirectory.getAbsolutePath();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("toStrip = \"%s\"", toStrip));
            }
            String regex = Pattern.quote(toStrip);
            String absolutePathStripped = absoluteFile.getAbsolutePath().replaceFirst(regex, "");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("absolutePathStripped = \"%s\"", absolutePathStripped));
            }
            if (absolutePathStripped.startsWith(File.separator)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)String.format("Because absolutePathStripped starts with \"%s\", stripping it.", File.separator));
                }
                absolutePathStripped = absolutePathStripped.replaceFirst(Pattern.quote(File.separator), "");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("absolutePathStripped = \"%s\"", absolutePathStripped));
            }
            String relativePath = prefix + absolutePathStripped;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("relativePath = \"%s\"", relativePath));
            }
            return new File(relativePath);
        }
        return absoluteFile;
    }

    private static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException exception) {
            if (LOGGER.isErrorEnabled()) {
                String message = "Caught IOException when calling file.getCanonicalFile() (file=%s)";
                LOGGER.error((Object)String.format("Caught IOException when calling file.getCanonicalFile() (file=%s)", file), (Throwable)exception);
            }
            return file;
        }
    }

    private static void logRelativeInputFiles(File absoluteFile, File baseDirectory) {
        if (LOGGER.isWarnEnabled()) {
            if (!absoluteFile.isAbsolute()) {
                LOGGER.warn((Object)"Did not expect absoluteFile.isAbsolute() to be false");
            }
            if (!baseDirectory.isAbsolute()) {
                LOGGER.warn((Object)"Did not expect baseDirectory.isAbsolute() to be false");
            }
        }
    }
}

