/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.utilities.string;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class StringUtilities {
    private static final transient Set<Character.UnicodeBlock> JAPANESE_UNICODE_BLOCKS;

    private StringUtilities() {
    }

    public static boolean containsJapanese(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string must not be null");
        }
        for (char character : string.toCharArray()) {
            if (!JAPANESE_UNICODE_BLOCKS.contains(Character.UnicodeBlock.of(character))) continue;
            return true;
        }
        return false;
    }

    static {
        HashSet<Character.UnicodeBlock> japaneseUnicodeBlocks = new HashSet<Character.UnicodeBlock>();
        japaneseUnicodeBlocks.add(Character.UnicodeBlock.HIRAGANA);
        japaneseUnicodeBlocks.add(Character.UnicodeBlock.KATAKANA);
        japaneseUnicodeBlocks.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS);
        JAPANESE_UNICODE_BLOCKS = Collections.unmodifiableSet(japaneseUnicodeBlocks);
    }
}

