/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;

public class BasicStyledLabelUI
extends BasicLabelUI
implements SwingConstants {
    public static Comparator<StyleRange> _comparator;
    protected static BasicStyledLabelUI styledLabelUI;
    private List<StyledText> _styledTexts;

    public static ComponentUI createUI(JComponent jComponent) {
        return styledLabelUI;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if ("styleRange".equals(propertyChangeEvent.getPropertyName())) {
            this._styledTexts = null;
            if (propertyChangeEvent.getSource() instanceof StyledLabel) {
                ((StyledLabel)propertyChangeEvent.getSource()).revalidate();
                ((StyledLabel)propertyChangeEvent.getSource()).repaint();
            }
        } else if ("ignoreColorSettings".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() instanceof StyledLabel) {
            ((StyledLabel)propertyChangeEvent.getSource()).repaint();
        }
    }

    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        View view;
        View view2 = view = jLabel != null ? (View)jLabel.getClientProperty("html") : null;
        if (view != null) {
            super.paintEnabledText(jLabel, graphics, string, n, n2);
        } else {
            this.paintStyledText((StyledLabel)jLabel, graphics, n, n2);
        }
    }

    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        View view;
        View view2 = view = jLabel != null ? (View)jLabel.getClientProperty("html") : null;
        if (view != null) {
            super.paintDisabledText(jLabel, graphics, string, n, n2);
        } else {
            this.paintStyledText((StyledLabel)jLabel, graphics, n, n2);
        }
    }

    protected void buildStyledText(StyledLabel styledLabel) {
        if (this._styledTexts == null) {
            this._styledTexts = new ArrayList<StyledText>();
        } else {
            this._styledTexts.clear();
        }
        StyleRange[] styleRangeArray = styledLabel.getStyleRanges();
        if (_comparator == null) {
            _comparator = new Comparator<StyleRange>(){

                @Override
                public int compare(StyleRange styleRange, StyleRange styleRange2) {
                    if (styleRange.getStart() < styleRange2.getStart()) {
                        return -1;
                    }
                    if (styleRange.getStart() > styleRange2.getStart()) {
                        return 1;
                    }
                    return 0;
                }
            };
        }
        Arrays.sort(styleRangeArray, _comparator);
        String string = styledLabel.getText();
        if (string != null && string.length() > 0) {
            int n = 0;
            for (StyleRange styleRange : styleRangeArray) {
                if (styleRange.getStart() > n) {
                    this._styledTexts.add(new StyledText(string.substring(n, styleRange.getStart())));
                    n = styleRange.getStart();
                }
                if (styleRange.getStart() == n) {
                    if (styleRange.getLength() == -1) {
                        this._styledTexts.add(new StyledText(string.substring(n), styleRange));
                        n = string.length();
                        continue;
                    }
                    this._styledTexts.add(new StyledText(string.substring(n, Math.min(n + styleRange.getLength(), string.length())), styleRange));
                    n += styleRange.getLength();
                    continue;
                }
                if (styleRange.getStart() >= n) continue;
            }
            if (n < string.length()) {
                this._styledTexts.add(new StyledText(string.substring(n, string.length())));
            }
        }
    }

    protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        Dimension dimension = this.getPreferredSize((StyledLabel)jLabel);
        rectangle3.width = dimension.width;
        rectangle3.height = dimension.height;
        return BasicStyledLabelUI.layoutCompoundLabel(jLabel, fontMetrics, string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, jLabel.getIconTextGap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension getPreferredSize(StyledLabel styledLabel) {
        this.buildStyledText(styledLabel);
        int n = 0;
        Font font = this.getFont(styledLabel);
        FontMetrics fontMetrics = styledLabel.getFontMetrics(font);
        int n2 = 0;
        int n3 = font.getSize();
        List<StyledText> list = this._styledTexts;
        synchronized (list) {
            StyledText[] styledTextArray = this._styledTexts.toArray(new StyledText[this._styledTexts.size()]);
            for (int i = styledTextArray.length - 1; i >= 0; --i) {
                StyledText styledText = styledTextArray[i];
                StyleRange styleRange = styledText.styleRange;
                float f = styleRange != null && (styleRange.isSuperscript() || styleRange.isSubscript()) ? (float)Math.round((float)n3 / styleRange.getFontShrinkRatio()) : (float)n3;
                font = this.getFont(styledLabel);
                if (styleRange != null && (styleRange.getFontStyle() != -1 && font.getStyle() != styleRange.getFontStyle() || (float)font.getSize() != f)) {
                    font = font.deriveFont(styleRange.getFontStyle() == -1 ? font.getStyle() : styleRange.getFontStyle(), f);
                    FontMetrics fontMetrics2 = styledLabel.getFontMetrics(font);
                    n += fontMetrics2.stringWidth(styledText.text);
                } else {
                    n += fontMetrics.stringWidth(styledText.text);
                }
                if (styleRange == null) continue;
                if (styleRange.isUnderlined() && n2 < 2) {
                    n2 = 2;
                }
                if (styleRange.isDotted() && n2 < 3) {
                    n2 = 3;
                }
                if (!styleRange.isWaved() || n2 >= 4) continue;
                n2 = 4;
            }
        }
        int n4 = fontMetrics.getHeight();
        return new Dimension(n, n4 + n2);
    }

    protected Font getFont(StyledLabel styledLabel) {
        Font font = styledLabel.getFont();
        if (font == null) {
            font = UIDefaultsLookup.getFont("Label.font");
        }
        return font;
    }

    protected void paintStyledText(StyledLabel styledLabel, Graphics graphics, int n, int n2) {
        int n3 = n < styledLabel.getInsets().left ? styledLabel.getInsets().left : n;
        int n4 = styledLabel.getDisplayedMnemonicIndex();
        if (UIManager.getLookAndFeel() instanceof WindowsLookAndFeel && WindowsLookAndFeel.isMnemonicHidden()) {
            n4 = -1;
        }
        this.buildStyledText(styledLabel);
        Color color = graphics.getColor();
        int n5 = 0;
        boolean bl = false;
        int n6 = 0;
        Font font = this.getFont(styledLabel);
        FontMetrics fontMetrics = styledLabel.getFontMetrics(font);
        int n7 = font.getSize();
        for (StyledText styledText : this._styledTexts) {
            Color color2;
            FontMetrics fontMetrics2;
            StyleRange styleRange = styledText.styleRange;
            if (styledText.text.length() > n4 - n5) {
                bl = true;
                n6 = n4 - n5;
            }
            n5 += styledText.text.length();
            int n8 = n2;
            float f = styleRange != null && (styleRange.isSuperscript() || styleRange.isSubscript()) ? (float)Math.round((float)n7 / styleRange.getFontShrinkRatio()) : (float)n7;
            font = this.getFont(styledLabel);
            if (styleRange != null && (styleRange.getFontStyle() != -1 && font.getStyle() != styleRange.getFontStyle() || (float)font.getSize() != f)) {
                font = font.deriveFont(styleRange.getFontStyle() == -1 ? font.getStyle() : styleRange.getFontStyle(), f);
                fontMetrics2 = styledLabel.getFontMetrics(font);
            } else {
                fontMetrics2 = fontMetrics;
            }
            graphics.setFont(font);
            String string = styledText.text;
            int n9 = fontMetrics2.stringWidth(string);
            boolean bl2 = false;
            int n10 = styledLabel.getWidth() - n3;
            if (n10 < n9) {
                string = SwingUtilities.layoutCompoundLabel(styledLabel, fontMetrics2, string, null, styledLabel.getVerticalAlignment(), styledLabel.getHorizontalAlignment(), styledLabel.getVerticalTextPosition(), styledLabel.getHorizontalTextPosition(), new Rectangle(n3, n8, n10, styledLabel.getHeight()), new Rectangle(), new Rectangle(), 0);
                n9 = fontMetrics2.stringWidth(string);
                bl2 = true;
            }
            if (styleRange != null && styleRange.isSuperscript()) {
                n8 -= fontMetrics.getHeight() - fontMetrics2.getHeight();
            }
            if (styleRange != null && styleRange.getBackgroundColor() != null) {
                graphics.setColor(styleRange.getBackgroundColor());
                graphics.fillRect(n3, n8 - fontMetrics2.getHeight(), n9, fontMetrics2.getHeight() + 4);
            }
            Color color3 = color2 = styleRange != null && !styledLabel.isIgnoreColorSettings() && styleRange.getFontColor() != null ? styleRange.getFontColor() : styledLabel.getForeground();
            if (!styledLabel.isEnabled()) {
                color2 = UIDefaultsLookup.getColor("Label.disabledForeground");
            }
            graphics.setColor(color2);
            if (bl) {
                JideSwingUtilities.drawStringUnderlineCharAt(styledLabel, graphics, string, n6, n3, n8);
            } else {
                JideSwingUtilities.drawString(styledLabel, graphics, string, n3, n8);
            }
            if (styleRange != null) {
                int n11;
                int n12;
                Stroke stroke = ((Graphics2D)graphics).getStroke();
                if (styleRange.getLineStroke() != null) {
                    ((Graphics2D)graphics).setStroke(styleRange.getLineStroke());
                }
                if (!styledLabel.isIgnoreColorSettings() && styleRange.getLineColor() != null) {
                    graphics.setColor(styleRange.getLineColor());
                }
                if (styleRange.isStrikethrough()) {
                    n12 = n8 + (fontMetrics2.getDescent() - fontMetrics2.getAscent()) / 2;
                    graphics.drawLine(n3, n12, n3 + n9 - 1, n12);
                }
                if (styleRange.isDoublestrikethrough()) {
                    n12 = n8 + (fontMetrics2.getDescent() - fontMetrics2.getAscent()) / 2;
                    graphics.drawLine(n3, n12 - 1, n3 + n9 - 1, n12 - 1);
                    graphics.drawLine(n3, n12 + 1, n3 + n9 - 1, n12 + 1);
                }
                if (styleRange.isUnderlined()) {
                    n12 = n8 + 1;
                    graphics.drawLine(n3, n12, n3 + n9 - 1, n12);
                }
                if (styleRange.isDotted()) {
                    n12 = n8 + 1;
                    for (n11 = n3; n11 < n3 + n9; n11 += 4) {
                        graphics.drawRect(n11, n12, 1, 1);
                    }
                }
                if (styleRange.isWaved()) {
                    n12 = n8 + 1;
                    for (n11 = n3; n11 < n3 + n9; n11 += 4) {
                        if (n11 + 2 <= n3 + n9 - 1) {
                            graphics.drawLine(n11, n12 + 2, n11 + 2, n12);
                        }
                        if (n11 + 4 > n3 + n9 - 1) continue;
                        graphics.drawLine(n11 + 3, n12 + 1, n11 + 4, n12 + 2);
                    }
                }
                if (styleRange.getLineStroke() != null) {
                    ((Graphics2D)graphics).setStroke(stroke);
                }
            }
            if (bl2) break;
            n3 += n9;
        }
        graphics.setColor(color);
    }

    public static String layoutCompoundLabel(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        boolean bl = true;
        int n6 = n2;
        int n7 = n4;
        if (jComponent != null && !jComponent.getComponentOrientation().isLeftToRight()) {
            bl = false;
        }
        switch (n2) {
            case 10: {
                n6 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n6 = bl ? 4 : 2;
            }
        }
        switch (n4) {
            case 10: {
                n7 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n7 = bl ? 4 : 2;
            }
        }
        return BasicStyledLabelUI.layoutCompoundLabelImpl(jComponent, fontMetrics, string, icon, n, n6, n3, n7, rectangle, rectangle2, rectangle3, n5);
    }

    public static String layoutCompoundLabel(FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        return BasicStyledLabelUI.layoutCompoundLabelImpl(null, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
    }

    private static String layoutCompoundLabelImpl(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        int n6;
        int n7;
        if (icon != null) {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        } else {
            rectangle2.height = 0;
            rectangle2.width = 0;
        }
        boolean bl = string == null || string.equals("");
        int n8 = 0;
        if (bl) {
            rectangle3.height = 0;
            rectangle3.width = 0;
            string = "";
            n7 = 0;
        } else {
            View view;
            n7 = icon == null ? 0 : n5;
            n6 = n4 == 0 ? rectangle.width : rectangle.width - (rectangle2.width + n7);
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                rectangle3.width = Math.min(n6, (int)view.getPreferredSpan(0));
                rectangle3.height = (int)view.getPreferredSpan(1);
            }
        }
        rectangle3.y = n3 == 1 ? (n4 != 0 ? 0 : -(rectangle3.height + n7)) : (n3 == 0 ? rectangle2.height / 2 - rectangle3.height / 2 : (n4 != 0 ? rectangle2.height - rectangle3.height : rectangle2.height + n7));
        rectangle3.x = n4 == 2 ? -(rectangle3.width + n7) : (n4 == 0 ? rectangle2.width / 2 - rectangle3.width / 2 : rectangle2.width + n7);
        n6 = Math.min(rectangle2.x, rectangle3.x);
        int n9 = Math.max(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width) - n6;
        int n10 = Math.min(rectangle2.y, rectangle3.y);
        int n11 = Math.max(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height) - n10;
        int n12 = n == 1 ? rectangle.y - n10 : (n == 0 ? rectangle.y + rectangle.height / 2 - (n10 + n11 / 2) : rectangle.y + rectangle.height - (n10 + n11));
        int n13 = n2 == 2 ? rectangle.x - n6 : (n2 == 4 ? rectangle.x + rectangle.width - (n6 + n9) : rectangle.x + rectangle.width / 2 - (n6 + n9 / 2));
        rectangle3.x += n13;
        rectangle3.y += n12;
        rectangle2.x += n13;
        rectangle2.y += n12;
        if (n8 < 0) {
            rectangle3.x -= n8;
        }
        return string;
    }

    static {
        styledLabelUI = new BasicStyledLabelUI();
    }

    class StyledText {
        StyleRange styleRange;
        String text;

        public StyledText(String string) {
            this.text = string;
        }

        public StyledText(String string, StyleRange styleRange) {
            this.text = string;
            this.styleRange = styleRange;
        }
    }
}

