/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Contour;
import com.jidesoft.swing.HeavyweightWrapper;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.swing.JideSplitPaneLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Arrays;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class JideSplitPane
extends JPanel
implements ContainerListener,
ComponentListener,
Accessible {
    protected static final String NON_CONTINUOUS_DIVIDER = "nonContinuousDivider";
    public static final int VERTICAL_SPLIT = 0;
    public static final int HORIZONTAL_SPLIT = 1;
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String DIVIDER_SIZE_PROPERTY = "dividerSize";
    public static final String PROPERTY_DIVIDER_LOCATION = "dividerLocation";
    public static final String CONTINUOUS_LAYOUT_PROPERTY = "continuousLayout";
    public static final String GRIPPER_PROPERTY = "gripper";
    public static final String PROPORTIONAL_LAYOUT_PROPERTY = "proportionalLayout";
    public static final String PROPORTIONS_PROPERTY = "proportions";
    public static final String PROPERTY_HEAVYWEIGHT_COMPONENT_ENABLED = "heavyweightComponentEnabled";
    private int _orientation;
    private int _dividerSize = UIDefaultsLookup.getInt("JideSplitPane.dividerSize");
    private HeavyweightWrapper _nonContinuousLayoutDividerWrapper;
    private boolean _continuousLayout = false;
    private Container _layeredPane;
    private boolean _showGripper = false;
    private boolean _proportionalLayout = false;
    private double[] _proportions;
    private boolean _initiallyEven = true;
    private boolean _heavyweightComponentEnabled = false;
    public WindowAdapter _windowDeactivatedListener;
    private int _dividerStepSize = 0;
    public static final String ONE_TOUCH_EXPANDABLE_PROPERTY = "oneTouchExpandable";
    private boolean _oneTouchExpandable = false;
    private int oneTouchExpandableDividerSize = 8;
    private ImageIcon _leftOneTouchButtonImageIcon = null;
    private ImageIcon _rightOneTouchButtonImageIcon = null;

    public JideSplitPane() {
        this(1);
    }

    public JideSplitPane(int n) {
        this._orientation = n;
        if (this._orientation != 1 && this._orientation != 0) {
            throw new IllegalArgumentException("cannot create JideSplitPane, orientation must be one of JideSplitPane.HORIZONTAL_SPLIT or JideSplitPane.VERTICAL_SPLIT");
        }
        JideSplitPaneLayout jideSplitPaneLayout = this._orientation == 1 ? new JideSplitPaneLayout(this, 0) : new JideSplitPaneLayout(this, 1);
        super.setLayout(jideSplitPaneLayout);
        this.setOpaque(false);
        this.installListeners();
    }

    public int getDividerStepSize() {
        return this._dividerStepSize;
    }

    public void setDividerStepSize(int n) {
        if (n < 0) {
            return;
        }
        this._dividerStepSize = n;
    }

    public void updateUI() {
        if (UIDefaultsLookup.get("JideSplitPane.dividerSize") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        super.updateUI();
    }

    private void installListeners() {
        this.addContainerListener(this);
    }

    public void setDividerSize(int n) {
        int n2 = this._dividerSize;
        if (n2 != n) {
            this._dividerSize = n;
            this.firePropertyChange(DIVIDER_SIZE_PROPERTY, n2, n);
            this.invalidate();
        }
    }

    public int getDividerSize() {
        return this._dividerSize;
    }

    public Component insertPane(Component component, int n) {
        return this.insertPane(component, null, n);
    }

    public Component insertPane(Component component, Object object, int n) {
        if (n <= 0) {
            this.addImpl(component, object, 0);
        } else if (n >= this.getPaneCount()) {
            this.addImpl(component, object, -1);
        } else {
            this.addImpl(component, object, (n << 1) - 1);
        }
        return component;
    }

    public Component addPane(Component component) {
        if (component == null) {
            return null;
        }
        return super.add(component);
    }

    public void removePane(Component component) {
        this.removePane(this.indexOfPane(component));
    }

    public void setPaneAt(Component component, int n) {
        this.setPaneAt(component, null, n);
    }

    public void setPaneAt(Component component, Object object, int n) {
        double[] dArray = this._proportions;
        this._proportions = null;
        this.removePane(n);
        this.insertPane(component, object, n);
        this._proportions = dArray;
    }

    public void removePane(int n) {
        if (n == 0) {
            super.remove(0);
        } else {
            super.remove(n << 1);
        }
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("JideSplitPane: orientation must be one of JideSplitPane.VERTICAL_SPLIT or JideSplitPane.HORIZONTAL_SPLIT");
        }
        if (this._orientation == n) {
            return;
        }
        int n2 = this._orientation;
        this._orientation = n;
        JideSplitPaneLayout jideSplitPaneLayout = this._orientation == 1 ? new JideSplitPaneLayout(this, 0) : new JideSplitPaneLayout(this, 1);
        super.setLayout(jideSplitPaneLayout);
        this.doLayout();
        this.firePropertyChange(ORIENTATION_PROPERTY, n2, n);
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void resetToPreferredSizes() {
        this.doLayout();
    }

    public void setProportionalLayout(boolean bl) {
        if (bl == this._proportionalLayout) {
            return;
        }
        this._proportionalLayout = bl;
        this.revalidate();
        this.firePropertyChange(PROPORTIONAL_LAYOUT_PROPERTY, !bl, bl);
        if (!bl) {
            this.setProportions(null);
        }
    }

    public boolean isProportionalLayout() {
        return this._proportionalLayout;
    }

    void internalSetProportions(double[] dArray) {
        this._proportions = dArray;
    }

    public void setProportions(double[] dArray) {
        int n;
        if (!this._proportionalLayout && dArray != null) {
            throw new IllegalStateException("Can't set proportions on a non-proportional split pane");
        }
        if (Arrays.equals(dArray, this._proportions)) {
            return;
        }
        if (dArray != null && dArray.length != this.getPaneCount() - 1) {
            throw new IllegalArgumentException("Must provide one fewer proportions than there are panes: got " + dArray.length + ", expected " + (this.getPaneCount() - 1));
        }
        if (dArray != null) {
            double d = 0.0;
            for (n = 0; n < dArray.length; ++n) {
                if (dArray[n] < 0.0) {
                    dArray[n] = 0.0;
                }
                if (dArray[n] > 1.0) {
                    dArray[n] = 1.0;
                }
                d += dArray[n];
            }
            if (d > 1.0) {
                throw new IllegalArgumentException("Sum of proportions must be no more than 1, got " + d);
            }
        }
        double[] dArray2 = this._proportions;
        this._proportions = dArray == null ? null : (double[])dArray.clone();
        LayoutManager layoutManager = this.getLayout();
        n = 0;
        if (layoutManager instanceof JideBoxLayout) {
            n = ((JideBoxLayout)layoutManager).isResetWhenInvalidate() ? 1 : 0;
            ((JideBoxLayout)layoutManager).setResetWhenInvalidate(true);
        }
        this.revalidate();
        if (n != 0) {
            ((JideBoxLayout)layoutManager).setResetWhenInvalidate(n != 0);
        }
        this.firePropertyChange(PROPORTIONS_PROPERTY, dArray2, dArray);
    }

    public double[] getProportions() {
        double[] dArray = this._proportions;
        if (dArray != null) {
            dArray = (double[])dArray.clone();
        }
        return dArray;
    }

    public void setInitiallyEven(boolean bl) {
        this._initiallyEven = bl;
    }

    public boolean isInitiallyEven() {
        return this._initiallyEven;
    }

    public boolean isValidateRoot() {
        return true;
    }

    protected void startDragging(JideSplitPaneDivider jideSplitPaneDivider) {
        if (!this.isContinuousLayout()) {
            Container container = this.getTopLevelAncestor();
            if (this._windowDeactivatedListener == null) {
                this._windowDeactivatedListener = new WindowAdapter(){

                    public void windowDeactivated(WindowEvent windowEvent) {
                        JideSplitPane.this.stopDragging();
                        if (windowEvent.getWindow() != null) {
                            windowEvent.getWindow().removeWindowListener(JideSplitPane.this._windowDeactivatedListener);
                        }
                    }
                };
            }
            if (container instanceof Window) {
                ((Window)container).addWindowListener(this._windowDeactivatedListener);
            }
            if (container instanceof RootPaneContainer) {
                Serializable serializable;
                this._layeredPane = ((RootPaneContainer)((Object)container)).getLayeredPane();
                if (this._nonContinuousLayoutDividerWrapper == null) {
                    serializable = new JideSplitPaneContour();
                    this._nonContinuousLayoutDividerWrapper = new JideSplitPaneHeavyweightWrapper((Component)serializable);
                    this._nonContinuousLayoutDividerWrapper.setHeavyweight(this.isHeavyweightComponentEnabled());
                }
                this._nonContinuousLayoutDividerWrapper.delegateSetCursor(this._orientation == 1 ? JideSplitPaneDivider.HORIZONTAL_CURSOR : JideSplitPaneDivider.VERTICAL_CURSOR);
                this._nonContinuousLayoutDividerWrapper.delegateSetVisible(false);
                this._nonContinuousLayoutDividerWrapper.delegateAdd(this._layeredPane, JLayeredPane.DRAG_LAYER);
                serializable = this.getVisibleRect();
                Rectangle rectangle = SwingUtilities.convertRectangle(this, (Rectangle)serializable, this._layeredPane);
                int n = Math.min(4, this.getDividerSize());
                if (this.getOrientation() == 1) {
                    this._nonContinuousLayoutDividerWrapper.delegateSetBounds(rectangle.x, rectangle.y, n, rectangle.height);
                } else {
                    this._nonContinuousLayoutDividerWrapper.delegateSetBounds(rectangle.x, rectangle.y, rectangle.width, n);
                }
            }
        }
    }

    private void stopDragging() {
        if (!this.isContinuousLayout() && this._layeredPane != null && this._nonContinuousLayoutDividerWrapper != null) {
            Component[] componentArray;
            this._nonContinuousLayoutDividerWrapper.delegateSetVisible(false);
            this._nonContinuousLayoutDividerWrapper.delegateRemove(this._layeredPane);
            this._nonContinuousLayoutDividerWrapper.delegateSetNull();
            this._nonContinuousLayoutDividerWrapper = null;
            for (Component component : componentArray = this._layeredPane.getComponents()) {
                if (!(component instanceof JideSplitPaneContour) && !(component instanceof JideSplitPaneHeavyweightWrapper)) continue;
                this._layeredPane.remove(component);
            }
        }
    }

    protected void dragDividerTo(JideSplitPaneDivider jideSplitPaneDivider, int n) {
        if (this._layeredPane == null || this.isContinuousLayout()) {
            this.setDividerLocation(jideSplitPaneDivider, n);
        } else if (this._nonContinuousLayoutDividerWrapper != null) {
            Point point = this.getOrientation() == 1 ? SwingUtilities.convertPoint(this, n, 0, this._layeredPane) : SwingUtilities.convertPoint(this, 0, n, this._layeredPane);
            int n2 = Math.min(4, this.getDividerSize());
            if (this.getOrientation() == 1) {
                point.x += this.getDividerSize() - n2 >> 1;
            } else {
                point.y += this.getDividerSize() - n2 >> 1;
            }
            this._nonContinuousLayoutDividerWrapper.delegateSetLocation(point);
            this._nonContinuousLayoutDividerWrapper.delegateSetVisible(true);
        }
    }

    protected void finishDraggingTo(JideSplitPaneDivider jideSplitPaneDivider, int n) {
        if (this.isContinuousLayout() || this._nonContinuousLayoutDividerWrapper != null) {
            this.stopDragging();
            this.setDividerLocation(jideSplitPaneDivider, n);
        }
    }

    public int indexOfDivider(JideSplitPaneDivider jideSplitPaneDivider) {
        int n = this.indexOf(jideSplitPaneDivider);
        if (n == -1) {
            return n;
        }
        if (n % 2 == 0) {
            System.err.println("Warning: divider's index is even. (index = " + n + ")");
        }
        return (n - 1) / 2;
    }

    public int indexOfPane(Component component) {
        int n = this.indexOf(component);
        if (n == -1) {
            return -1;
        }
        if (n % 2 != 0) {
            System.err.println("Warning: pane's index is odd. (index = " + n + ")");
        }
        return n >> 1;
    }

    public int indexOf(Component component) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!this.getComponent(i).equals(component)) continue;
            return i;
        }
        return -1;
    }

    public JideSplitPaneDivider getDividerAt(int n) {
        if (n < 0 || n * 2 + 1 >= this.getComponentCount()) {
            return null;
        }
        return (JideSplitPaneDivider)this.getComponent(n * 2 + 1);
    }

    public Component getPaneAt(int n) {
        if (n < 0 || n << 1 >= this.getComponentCount()) {
            return null;
        }
        return this.getComponent(n << 1);
    }

    public int getPaneCount() {
        return this.getComponentCount() + 1 >> 1;
    }

    public void setDividerLocation(JideSplitPaneDivider jideSplitPaneDivider, int n) {
        this.setDividerLocation(this.indexOfDivider(jideSplitPaneDivider), n);
    }

    public void setDividerLocation(int n, int n2) {
        ((JideSplitPaneLayout)this.getLayout()).setDividerLocation(n, n2, true);
    }

    public int getDividerLocation(int n) {
        return ((JideSplitPaneLayout)this.getLayout()).getDividerLocation(n);
    }

    public void componentAdded(ContainerEvent containerEvent) {
        containerEvent.getChild().addComponentListener(this);
        if (!(containerEvent.getChild() instanceof JideSplitPaneDivider)) {
            this.addExtraDividers();
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        containerEvent.getChild().removeComponentListener(this);
        if (!(containerEvent.getChild() instanceof JideSplitPaneDivider)) {
            this.removeExtraDividers();
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() instanceof JideSplitPaneDivider) {
            return;
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() instanceof JideSplitPaneDivider) {
            return;
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    protected boolean removeExtraDividers() {
        int n = 0;
        if (this.getComponentCount() == 0) {
            if (this._proportions != null) {
                this.setProportions(null);
            }
            return false;
        }
        boolean bl = false;
        if (this.getComponent(0) instanceof JideSplitPaneDivider) {
            this.remove(0);
            this.removeProportion(0);
            bl = true;
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (component instanceof JideSplitPaneDivider) {
                if (++n != 2) continue;
                this.remove(component);
                if (this._proportions != null && this.getPaneCount() == this._proportions.length) {
                    this.removeProportion(i / 2);
                }
                bl = true;
                --n;
                --i;
                continue;
            }
            n = 0;
        }
        if (n == 1) {
            this.remove(this.getComponentCount() - 1);
            this.removeProportion((this.getComponentCount() + 1) / 2);
            bl = true;
        }
        return bl;
    }

    protected void removeProportion(int n) {
        int n2;
        double d;
        double[] dArray = this._proportions;
        if (dArray == null) {
            return;
        }
        if (dArray.length <= 1) {
            this.setProportions(null);
            return;
        }
        double[] dArray2 = new double[dArray.length - 1];
        if (n < dArray.length) {
            d = dArray[n];
        } else {
            d = 1.0;
            double[] dArray3 = dArray;
            int n3 = dArray3.length;
            for (n2 = 0; n2 < n3; ++n2) {
                double d2 = dArray3[n2];
                d -= d2;
            }
        }
        double d3 = 1.0 - d;
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            int n4 = n2 < n ? n2 : n2 + 1;
            dArray2[n2] = dArray[n4] / d3;
        }
        this.setProportions(dArray2);
    }

    protected void addExtraDividers() {
        int n = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof JideSplitPaneDivider)) {
                if (++n != 2) continue;
                this.add(this.createSplitPaneDivider(), "fix", i);
                if (this._proportions != null && this.getPaneCount() == this._proportions.length + 2) {
                    this.addProportion((i + 1) / 2);
                }
                n = 0;
                continue;
            }
            n = 0;
        }
    }

    protected void addProportion(int n) {
        double[] dArray = this._proportions;
        if (dArray == null) {
            return;
        }
        double[] dArray2 = new double[dArray.length + 1];
        double d = 1.0 / (double)(dArray2.length + 1);
        double d2 = 1.0 - d;
        for (int i = 0; i < dArray2.length; ++i) {
            if (i == n) {
                dArray2[i] = d;
                continue;
            }
            int n2 = i < n ? i : i - 1;
            dArray2[i] = n2 < dArray.length ? dArray[n2] * d2 : d;
        }
        this.setProportions(dArray2);
    }

    protected void setDividersVisible() {
        if (this.getComponentCount() == 1) {
            this.setVisible(this.getComponent(0).isVisible());
        } else if (this.getComponentCount() > 1) {
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof JideSplitPaneDivider)) {
                    if (!component.isVisible() || bl) continue;
                    bl = true;
                    continue;
                }
                boolean bl3 = this.getComponent(i - 1).isVisible();
                boolean bl4 = this.getComponent(i + 1).isVisible();
                if (bl3 && bl4) {
                    component.setVisible(true);
                    continue;
                }
                if (!bl3 && !bl4) {
                    component.setVisible(false);
                    continue;
                }
                if (bl3 && !bl4) {
                    component.setVisible(false);
                    bl2 = true;
                    continue;
                }
                if (bl2) {
                    component.setVisible(true);
                    bl2 = false;
                    continue;
                }
                component.setVisible(false);
            }
            this.setVisible(bl);
        }
    }

    protected JideSplitPaneDivider createSplitPaneDivider() {
        return new JideSplitPaneDivider(this);
    }

    protected int getPreviousDividerLocation(JideSplitPaneDivider jideSplitPaneDivider, boolean bl, boolean bl2) {
        int n = this.indexOfDivider(jideSplitPaneDivider);
        int n2 = -1;
        if (bl2) {
            if ((n + 1) * 2 + 1 <= this.getComponentCount()) {
                int n3 = n + 1;
                while (n3 * 2 + 1 < this.getComponentCount()) {
                    if (bl || this.getDividerAt(n3).isVisible()) {
                        n2 = this._orientation == 1 ? this.getDividerAt((int)n3).getBounds().x : this.getDividerAt((int)n3).getBounds().y;
                        break;
                    }
                    ++n3;
                }
            }
        } else if (n > 0) {
            for (int i = n - 1; i >= 0; --i) {
                if (!bl && !this.getDividerAt(i).isVisible()) continue;
                n2 = this._orientation == 1 ? this.getDividerAt((int)i).getBounds().x : this.getDividerAt((int)i).getBounds().y;
                break;
            }
        }
        if (n2 != -1) {
            return n2 + this.getDividerSize();
        }
        return 0;
    }

    public int getNextDividerLocation(JideSplitPaneDivider jideSplitPaneDivider, boolean bl, boolean bl2) {
        int n = this.indexOfDivider(jideSplitPaneDivider);
        int n2 = -1;
        if (!bl2) {
            if ((n + 1) * 2 + 1 <= this.getComponentCount()) {
                int n3 = n + 1;
                while (n3 * 2 + 1 < this.getComponentCount()) {
                    if (bl || this.getDividerAt(n3).isVisible()) {
                        n2 = this._orientation == 1 ? this.getDividerAt((int)n3).getBounds().x : this.getDividerAt((int)n3).getBounds().y;
                        break;
                    }
                    ++n3;
                }
            }
        } else if (n > 0) {
            for (int i = n - 1; i >= 0; --i) {
                if (!bl && !this.getDividerAt(i).isVisible()) continue;
                n2 = this._orientation == 1 ? this.getDividerAt((int)i).getBounds().x : this.getDividerAt((int)i).getBounds().y;
                break;
            }
        }
        if (n2 != -1) {
            return n2 - this.getDividerSize();
        }
        return this.getOrientation() == 1 ? this.getWidth() - this.getDividerSize() : this.getHeight() - this.getDividerSize();
    }

    public boolean isShowGripper() {
        return this._showGripper;
    }

    public void setShowGripper(boolean bl) {
        boolean bl2 = this._showGripper;
        if (bl2 != bl) {
            this._showGripper = bl;
            this.firePropertyChange(GRIPPER_PROPERTY, bl2, this._showGripper);
        }
    }

    public void doLayout() {
        if (this.removeExtraDividers()) {
            ((JideSplitPaneLayout)this.getLayout()).invalidateLayout(this);
        }
        super.doLayout();
    }

    public boolean isContinuousLayout() {
        return this._continuousLayout;
    }

    public void setContinuousLayout(boolean bl) {
        boolean bl2 = this._continuousLayout;
        this._continuousLayout = bl;
        this.firePropertyChange(CONTINUOUS_LAYOUT_PROPERTY, bl2, bl);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJideSplitPane();
        }
        return this.accessibleContext;
    }

    public boolean isHeavyweightComponentEnabled() {
        return this._heavyweightComponentEnabled;
    }

    public void setHeavyweightComponentEnabled(boolean bl) {
        boolean bl2 = this._heavyweightComponentEnabled;
        if (this._heavyweightComponentEnabled != bl) {
            this._heavyweightComponentEnabled = bl;
            this.firePropertyChange(PROPERTY_HEAVYWEIGHT_COMPONENT_ENABLED, bl2, this._heavyweightComponentEnabled);
        }
    }

    public void setOneTouchExpandable(boolean bl) {
        boolean bl2 = this._oneTouchExpandable;
        if (bl2 != bl) {
            this._oneTouchExpandable = bl;
            LayoutManager layoutManager = this.getLayout();
            if (layoutManager instanceof JideBoxLayout) {
                ((JideBoxLayout)layoutManager).setResetWhenInvalidate(true);
            }
            if (bl) {
                this.setDividerSize(this.oneTouchExpandableDividerSize);
            } else {
                this.setDividerSize(UIDefaultsLookup.getInt("JideSplitPane.dividerSize"));
            }
            this.firePropertyChange(ONE_TOUCH_EXPANDABLE_PROPERTY, bl2, this._oneTouchExpandable);
            this.revalidate();
            this.repaint();
            if (layoutManager instanceof JideBoxLayout) {
                ((JideBoxLayout)layoutManager).setResetWhenInvalidate(false);
            }
        }
    }

    public boolean isOneTouchExpandable() {
        return this._oneTouchExpandable;
    }

    public void setLeftOneTouchButtonImageIcon(ImageIcon imageIcon) {
        this._leftOneTouchButtonImageIcon = imageIcon;
    }

    public ImageIcon getLeftOneTouchButtonImageIcon() {
        return this._leftOneTouchButtonImageIcon;
    }

    public void setRightOneTouchButtonImageIcon(ImageIcon imageIcon) {
        this._rightOneTouchButtonImageIcon = imageIcon;
    }

    public ImageIcon getRightOneTouchButtonImageIcon() {
        return this._rightOneTouchButtonImageIcon;
    }

    public void setDividerLocations(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            this.setDividerLocation(i, n);
        }
    }

    public int[] getDividerLocations() {
        int n = this.getPaneCount();
        if (this.getPaneCount() == 0) {
            return new int[0];
        }
        int[] nArray = new int[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            nArray[i] = this.getDividerLocation(i);
        }
        return nArray;
    }

    private class JideSplitPaneHeavyweightWrapper
    extends HeavyweightWrapper {
        public JideSplitPaneHeavyweightWrapper(Component component) {
            super(component);
        }
    }

    private class JideSplitPaneContour
    extends Contour {
        public JideSplitPaneContour() {
        }

        public JideSplitPaneContour(int n) {
            super(n);
        }
    }

    protected class AccessibleJideSplitPane
    extends JComponent.AccessibleJComponent {
        private static final long serialVersionUID = -6167624875135108683L;

        protected AccessibleJideSplitPane() {
            super(JideSplitPane.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JideSplitPane.this.getOrientation() == 0) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }
    }
}

