/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.utilities.compression;

import com.thinkbuzan.chaos.utilities.compression.ZIPFileEntry;
import com.thinkbuzan.chaos.utilities.compression.listener.UtilsZipListener;
import ipworkszip.IPWorksZipException;
import ipworkszip.ZIPFile;
import ipworkszip.Zip;
import ipworkszip.ZipEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZipUtils {
    private static final Logger a;
    public static int b;
    private static final String[] z;

    private ZipUtils() {
    }

    private static Zip a() throws IOExceptionWithCause {
        Zip zip = new Zip();
        zip.setRuntimeLicense(z[19]);
        try {
            zip.setCompressionLevel(2);
        }
        catch (IPWorksZipException iPWorksZipException) {
            throw new IOExceptionWithCause(z[20], (Throwable)iPWorksZipException);
        }
        return zip;
    }

    public static void zipFiles(Map<File, String> map, String string, String string2) throws IOException {
        int n = b;
        ArrayList<ZIPFileEntry> arrayList = new ArrayList<ZIPFileEntry>();
        for (Map.Entry<File, String> entry : map.entrySet()) {
            arrayList.add(new ZIPFileEntry(entry.getKey(), entry.getValue()));
            if (n == 0) continue;
        }
        ZipUtils.zipFiles(arrayList, string, string2);
    }

    public static void zipFiles(List<ZIPFileEntry> list, String string, String string2) throws IOException {
        int n = b;
        if (list == null) {
            a.error((Object)z[3]);
            return;
        }
        Zip zip = ZipUtils.a();
        for (ZIPFileEntry zIPFileEntry : list) {
            ZIPFile zIPFile = new ZIPFile(zIPFileEntry.getCompressedName(), zIPFileEntry.getFile().getPath());
            zip.getFiles().add((Object)zIPFile);
            if (n == 0) continue;
        }
        try {
            zip.setArchiveFile(string);
            if (string2 != null && !"".equals(string2)) {
                zip.setPassword(string2);
            }
            zip.compress();
        }
        catch (Exception exception) {
            throw new IOExceptionWithCause(z[2], (Throwable)exception);
        }
    }

    public static void zip(File file, File file2) throws IOException {
        int n = b;
        if (file == null || !file.isDirectory()) {
            throw new IllegalArgumentException(z[7] + file + "]");
        }
        Zip zip = ZipUtils.a();
        try {
            zip.setRecurseSubdirectories(true);
            zip.includeFiles(file.getPath() + File.separator + "*");
            zip.setArchiveFile(file2.getPath());
            zip.compress();
        }
        catch (Exception exception) {
            throw new IOExceptionWithCause(z[2], (Throwable)exception);
        }
        if (ZIPFileEntry.c) {
            b = ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDir(String string, String string2, ActionListener actionListener, List<String> list) throws IOException {
        int n = b;
        ZipUtils.a(string, z[15]);
        ZipUtils.a(string2, z[12]);
        ZipUtils.a(list, z[11]);
        if (a.isDebugEnabled()) {
            a.debug((Object)(z[13] + string + z[14] + string2));
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string2));
        try {
            ZipUtils.a(string, zipOutputStream, "", actionListener, list);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)zipOutputStream);
        }
        if (n != 0) {
            ZIPFileEntry.c = !ZIPFileEntry.c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(String string, ZipOutputStream zipOutputStream, String string2, ActionListener actionListener, List<String> list) throws IOException {
        int n = b;
        File file = new File(string);
        String[] stringArray = file.list();
        byte[] byArray = new byte[4096];
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            File file2 = new File(file, stringArray[i]);
            if (list.contains(file2.getAbsolutePath()) && n == 0) continue;
            if (file2.isDirectory()) {
                object = file2.getPath();
                ZipUtils.a((String)object, zipOutputStream, string2 + file2.getName() + "/", actionListener, list);
                if (n == 0) continue;
            }
            object = new FileInputStream(file2);
            try {
                ZipEntry zipEntry = new ZipEntry(string2 + file2.getName());
                zipOutputStream.putNextEntry(zipEntry);
                n2 = ((FileInputStream)object).read(byArray);
                while (n2 != -1) {
                    zipOutputStream.write(byArray, 0, n2);
                    n2 = ((FileInputStream)object).read(byArray);
                    if (n == 0) continue;
                }
                if (actionListener == null) continue;
                actionListener.actionPerformed(new ActionEvent(file2.getAbsolutePath(), 0, null));
                continue;
            }
            finally {
                ((FileInputStream)object).close();
            }
        }
    }

    public static void unzip(File file, File file2) throws IOException {
        ZipUtils.unzip(file2.getAbsolutePath(), file.getAbsolutePath(), null);
    }

    public static void unzip(InputStream inputStream, File file) throws IOException {
        ZipUtils.a(file.getAbsolutePath(), inputStream, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unzip(String string, String string2, ActionListener actionListener) throws IOException {
        ZipUtils.a(string, z[8]);
        ZipUtils.a((Object)string2, z[18]);
        if (a.isDebugEnabled()) {
            a.debug((Object)(z[16] + string2 + z[17] + string));
        }
        Zip zip = ZipUtils.a();
        UtilsZipListener utilsZipListener = null;
        try {
            zip.setArchiveFile(string2);
            zip.setExtractToPath(string);
            if (actionListener != null) {
                utilsZipListener = new UtilsZipListener(actionListener, zip);
                zip.addZipEventListener((ZipEventListener)utilsZipListener);
            }
            zip.extractAll();
            if (utilsZipListener == null) return;
        }
        catch (Exception exception) {
            try {
                throw new IOExceptionWithCause(z[2], (Throwable)exception);
            }
            catch (Throwable throwable) {
                if (utilsZipListener == null) throw throwable;
                zip.removeZipEventListener(utilsZipListener);
                throw throwable;
            }
        }
        zip.removeZipEventListener((ZipEventListener)utilsZipListener);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(String string, InputStream inputStream, ActionListener actionListener) throws IOException {
        int n = b;
        ZipUtils.a(string, z[8]);
        ZipUtils.a(inputStream, z[10]);
        if (a.isDebugEnabled()) {
            a.debug((Object)(z[9] + string));
        }
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream));
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                block13: {
                    int n2;
                    File file;
                    File file2;
                    String string2;
                    block12: {
                        string2 = zipEntry.getName();
                        if (!zipEntry.isDirectory()) break block12;
                        string2 = string2.substring(0, string2.length() - 1);
                        new File(string + File.separator + string2).mkdir();
                        if (n == 0) break block13;
                    }
                    if (!(file2 = new File((file = new File(string + File.separator + string2)).getParent())).exists()) {
                        file2.mkdirs();
                    }
                    file.createNewFile();
                    if (actionListener != null) {
                        actionListener.actionPerformed(new ActionEvent(file.getAbsolutePath(), 0, null));
                    }
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    do {
                        if ((n2 = zipInputStream.read()) == -1) continue;
                        ((OutputStream)bufferedOutputStream).write(n2);
                    } while (n2 != -1);
                    ((OutputStream)bufferedOutputStream).close();
                }
                if (n == 0) continue;
                break;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)zipInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(File file, String string) throws IOException {
        ZipUtils.a((Object)file, z[6]);
        ZipUtils.a(string, z[5]);
        String string2 = ZipUtils.a(string);
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string2.equals(zipEntry.getName())) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)zipInputStream);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(File file, String string) throws IOException {
        int n = b;
        ZipUtils.a((Object)file, z[6]);
        ZipUtils.a(string, z[5]);
        InputStream inputStream = ZipUtils.a(file, string);
        if (inputStream == null) {
            return null;
        }
        try {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[4096];
            while ((n2 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
                if (n == 0) continue;
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private static InputStream a(File file, String string) throws IOException {
        ZipEntry zipEntry;
        ZipUtils.a((Object)file, z[6]);
        ZipUtils.a(string, z[5]);
        String string2 = ZipUtils.a(string);
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (!string2.equals(zipEntry.getName())) continue;
            return zipInputStream;
        }
        IOUtils.closeQuietly((InputStream)zipInputStream);
        return null;
    }

    public static int countFilesInZip(File file) throws IOException {
        ZipUtils.a((Object)file, z[0]);
        int n = 0;
        try {
            Zip zip = ZipUtils.a();
            zip.setArchiveFile(file.getPath());
            zip.scan();
            n = zip.getFiles().size();
        }
        catch (Exception exception) {
            throw new IOExceptionWithCause(z[1], (Throwable)exception);
        }
        return n;
    }

    private static void a(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    private static void a(String string, String string2) {
        ZipUtils.a((Object)string, string2);
        if ("".equals(string.trim())) {
            throw new IllegalArgumentException(string2 + z[4]);
        }
    }

    private static String a(String string) {
        String string2 = string.replace("\\", "/");
        if (string2.length() > 1 && string2.charAt(0) == '/') {
            return string2.substring(1);
        }
        return string2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block230: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block229: {
                char[] cArray3;
                Object var0;
                block228: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block227: {
                        char[] cArray5;
                        block226: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block225: {
                                char[] cArray7;
                                block224: {
                                    int n8;
                                    int n9;
                                    char[] cArray8;
                                    block223: {
                                        char[] cArray9;
                                        block222: {
                                            int n10;
                                            int n11;
                                            char[] cArray10;
                                            block221: {
                                                char[] cArray11;
                                                block220: {
                                                    int n12;
                                                    int n13;
                                                    char[] cArray12;
                                                    block219: {
                                                        char[] cArray13;
                                                        block218: {
                                                            int n14;
                                                            int n15;
                                                            char[] cArray14;
                                                            block217: {
                                                                char[] cArray15;
                                                                block216: {
                                                                    int n16;
                                                                    int n17;
                                                                    char[] cArray16;
                                                                    block215: {
                                                                        char[] cArray17;
                                                                        block214: {
                                                                            int n18;
                                                                            int n19;
                                                                            char[] cArray18;
                                                                            block213: {
                                                                                char[] cArray19;
                                                                                block212: {
                                                                                    int n20;
                                                                                    int n21;
                                                                                    char[] cArray20;
                                                                                    block211: {
                                                                                        char[] cArray21;
                                                                                        block210: {
                                                                                            int n22;
                                                                                            int n23;
                                                                                            char[] cArray22;
                                                                                            block209: {
                                                                                                char[] cArray23;
                                                                                                block208: {
                                                                                                    int n24;
                                                                                                    int n25;
                                                                                                    char[] cArray24;
                                                                                                    block207: {
                                                                                                        char[] cArray25;
                                                                                                        block206: {
                                                                                                            int n26;
                                                                                                            int n27;
                                                                                                            char[] cArray26;
                                                                                                            block205: {
                                                                                                                char[] cArray27;
                                                                                                                block204: {
                                                                                                                    int n28;
                                                                                                                    int n29;
                                                                                                                    char[] cArray28;
                                                                                                                    block203: {
                                                                                                                        char[] cArray29;
                                                                                                                        block202: {
                                                                                                                            int n30;
                                                                                                                            int n31;
                                                                                                                            char[] cArray30;
                                                                                                                            block201: {
                                                                                                                                char[] cArray31;
                                                                                                                                block200: {
                                                                                                                                    int n32;
                                                                                                                                    int n33;
                                                                                                                                    char[] cArray32;
                                                                                                                                    block199: {
                                                                                                                                        char[] cArray33;
                                                                                                                                        block198: {
                                                                                                                                            int n34;
                                                                                                                                            int n35;
                                                                                                                                            char[] cArray34;
                                                                                                                                            block197: {
                                                                                                                                                char[] cArray35;
                                                                                                                                                block196: {
                                                                                                                                                    int n36;
                                                                                                                                                    int n37;
                                                                                                                                                    char[] cArray36;
                                                                                                                                                    block195: {
                                                                                                                                                        char[] cArray37;
                                                                                                                                                        block194: {
                                                                                                                                                            int n38;
                                                                                                                                                            int n39;
                                                                                                                                                            char[] cArray38;
                                                                                                                                                            block193: {
                                                                                                                                                                char[] cArray39;
                                                                                                                                                                block192: {
                                                                                                                                                                    int n40;
                                                                                                                                                                    int n41;
                                                                                                                                                                    char[] cArray40;
                                                                                                                                                                    block191: {
                                                                                                                                                                        char[] cArray41;
                                                                                                                                                                        block190: {
                                                                                                                                                                            int n42;
                                                                                                                                                                            int n43;
                                                                                                                                                                            char[] cArray42;
                                                                                                                                                                            block189: {
                                                                                                                                                                                stringArray = new String[21];
                                                                                                                                                                                var0 = null;
                                                                                                                                                                                char[] cArray43 = "\u001fAe\u0018f:G|\u0013a5@J\u001fbP\u000ej\u001fb\\Hy\u001aw\\Mq\u00182\u0012AdVp\u0019\u000e~\u0003~\u0010".toCharArray();
                                                                                                                                                                                n3 = 0;
                                                                                                                                                                                int n44 = cArray43.length;
                                                                                                                                                                                cArray42 = cArray43;
                                                                                                                                                                                n43 = n44;
                                                                                                                                                                                if (n44 <= 1) break block189;
                                                                                                                                                                                cArray41 = cArray42;
                                                                                                                                                                                n42 = n43;
                                                                                                                                                                                if (n43 <= n3) break block190;
                                                                                                                                                                            }
                                                                                                                                                                            do {
                                                                                                                                                                                char[] cArray44 = cArray42;
                                                                                                                                                                                char[] cArray45 = cArray42;
                                                                                                                                                                                int n45 = n3;
                                                                                                                                                                                while (true) {
                                                                                                                                                                                    int n46;
                                                                                                                                                                                    char c = cArray44[n45];
                                                                                                                                                                                    switch (n3 % 5) {
                                                                                                                                                                                        case 0: {
                                                                                                                                                                                            n46 = 124;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        case 1: {
                                                                                                                                                                                            n46 = 46;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        case 2: {
                                                                                                                                                                                            n46 = 16;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        case 3: {
                                                                                                                                                                                            n46 = 118;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        default: {
                                                                                                                                                                                            n46 = 18;
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                    cArray44[n45] = (char)(c ^ n46);
                                                                                                                                                                                    ++n3;
                                                                                                                                                                                    cArray42 = cArray45;
                                                                                                                                                                                    n43 = n43;
                                                                                                                                                                                    if (n43 != 0) break;
                                                                                                                                                                                    cArray45 = cArray42;
                                                                                                                                                                                    n42 = n43;
                                                                                                                                                                                    n45 = n43;
                                                                                                                                                                                    cArray44 = cArray42;
                                                                                                                                                                                }
                                                                                                                                                                                cArray41 = cArray42;
                                                                                                                                                                                n42 = n43;
                                                                                                                                                                            } while (n43 > n3);
                                                                                                                                                                        }
                                                                                                                                                                        stringArray[0] = new String(cArray41).intern();
                                                                                                                                                                        var0 = null;
                                                                                                                                                                        char[] cArray46 = "?Ae\u001av\\@\u007f\u00022\u000fMq\u00182\bFuVh\u0015^0\u0017`\u001fFy\u0000w".toCharArray();
                                                                                                                                                                        n3 = 0;
                                                                                                                                                                        int n47 = cArray46.length;
                                                                                                                                                                        cArray40 = cArray46;
                                                                                                                                                                        n41 = n47;
                                                                                                                                                                        if (n47 <= 1) break block191;
                                                                                                                                                                        cArray39 = cArray40;
                                                                                                                                                                        n40 = n41;
                                                                                                                                                                        if (n41 <= n3) break block192;
                                                                                                                                                                    }
                                                                                                                                                                    do {
                                                                                                                                                                        char[] cArray47 = cArray40;
                                                                                                                                                                        char[] cArray48 = cArray40;
                                                                                                                                                                        int n48 = n3;
                                                                                                                                                                        while (true) {
                                                                                                                                                                            int n49;
                                                                                                                                                                            char c = cArray47[n48];
                                                                                                                                                                            switch (n3 % 5) {
                                                                                                                                                                                case 0: {
                                                                                                                                                                                    n49 = 124;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                case 1: {
                                                                                                                                                                                    n49 = 46;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                case 2: {
                                                                                                                                                                                    n49 = 16;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                case 3: {
                                                                                                                                                                                    n49 = 118;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                default: {
                                                                                                                                                                                    n49 = 18;
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                            cArray47[n48] = (char)(c ^ n49);
                                                                                                                                                                            ++n3;
                                                                                                                                                                            cArray40 = cArray48;
                                                                                                                                                                            n41 = n41;
                                                                                                                                                                            if (n41 != 0) break;
                                                                                                                                                                            cArray48 = cArray40;
                                                                                                                                                                            n40 = n41;
                                                                                                                                                                            n48 = n41;
                                                                                                                                                                            cArray47 = cArray40;
                                                                                                                                                                        }
                                                                                                                                                                        cArray39 = cArray40;
                                                                                                                                                                        n40 = n41;
                                                                                                                                                                    } while (n41 > n3);
                                                                                                                                                                }
                                                                                                                                                                stringArray[1] = new String(cArray39).intern();
                                                                                                                                                                var0 = null;
                                                                                                                                                                char[] cArray49 = "?Ae\u001av\\@\u007f\u00022\u001f\\u\u0017f\u0019\u000ed\u001ew\\Ty\u00062\u001d\\s\u001e{\nK".toCharArray();
                                                                                                                                                                n3 = 0;
                                                                                                                                                                int n50 = cArray49.length;
                                                                                                                                                                cArray38 = cArray49;
                                                                                                                                                                n39 = n50;
                                                                                                                                                                if (n50 <= 1) break block193;
                                                                                                                                                                cArray37 = cArray38;
                                                                                                                                                                n38 = n39;
                                                                                                                                                                if (n39 <= n3) break block194;
                                                                                                                                                            }
                                                                                                                                                            do {
                                                                                                                                                                char[] cArray50 = cArray38;
                                                                                                                                                                char[] cArray51 = cArray38;
                                                                                                                                                                int n51 = n3;
                                                                                                                                                                while (true) {
                                                                                                                                                                    int n52;
                                                                                                                                                                    char c = cArray50[n51];
                                                                                                                                                                    switch (n3 % 5) {
                                                                                                                                                                        case 0: {
                                                                                                                                                                            n52 = 124;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        case 1: {
                                                                                                                                                                            n52 = 46;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        case 2: {
                                                                                                                                                                            n52 = 16;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        case 3: {
                                                                                                                                                                            n52 = 118;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        default: {
                                                                                                                                                                            n52 = 18;
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                    cArray50[n51] = (char)(c ^ n52);
                                                                                                                                                                    ++n3;
                                                                                                                                                                    cArray38 = cArray51;
                                                                                                                                                                    n39 = n39;
                                                                                                                                                                    if (n39 != 0) break;
                                                                                                                                                                    cArray51 = cArray38;
                                                                                                                                                                    n38 = n39;
                                                                                                                                                                    n51 = n39;
                                                                                                                                                                    cArray50 = cArray38;
                                                                                                                                                                }
                                                                                                                                                                cArray37 = cArray38;
                                                                                                                                                                n38 = n39;
                                                                                                                                                            } while (n39 > n3);
                                                                                                                                                        }
                                                                                                                                                        stringArray[2] = new String(cArray37).intern();
                                                                                                                                                        var0 = null;
                                                                                                                                                        char[] cArray52 = "\u0006G`Vt\u0015Bu\u00052\u001fO|\u001aw\u0018\u000eg\u001ff\u0014\u000eqV|\tB|Vt\u0015BuV~\u0015]dZ2\u000eKd\u0003`\u0012G~\u0011".toCharArray();
                                                                                                                                                        n3 = 0;
                                                                                                                                                        int n53 = cArray52.length;
                                                                                                                                                        cArray36 = cArray52;
                                                                                                                                                        n37 = n53;
                                                                                                                                                        if (n53 <= 1) break block195;
                                                                                                                                                        cArray35 = cArray36;
                                                                                                                                                        n36 = n37;
                                                                                                                                                        if (n37 <= n3) break block196;
                                                                                                                                                    }
                                                                                                                                                    do {
                                                                                                                                                        char[] cArray53 = cArray36;
                                                                                                                                                        char[] cArray54 = cArray36;
                                                                                                                                                        int n54 = n3;
                                                                                                                                                        while (true) {
                                                                                                                                                            int n55;
                                                                                                                                                            char c = cArray53[n54];
                                                                                                                                                            switch (n3 % 5) {
                                                                                                                                                                case 0: {
                                                                                                                                                                    n55 = 124;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 1: {
                                                                                                                                                                    n55 = 46;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 2: {
                                                                                                                                                                    n55 = 16;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 3: {
                                                                                                                                                                    n55 = 118;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                default: {
                                                                                                                                                                    n55 = 18;
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                            cArray53[n54] = (char)(c ^ n55);
                                                                                                                                                            ++n3;
                                                                                                                                                            cArray36 = cArray54;
                                                                                                                                                            n37 = n37;
                                                                                                                                                            if (n37 != 0) break;
                                                                                                                                                            cArray54 = cArray36;
                                                                                                                                                            n36 = n37;
                                                                                                                                                            n54 = n37;
                                                                                                                                                            cArray53 = cArray36;
                                                                                                                                                        }
                                                                                                                                                        cArray35 = cArray36;
                                                                                                                                                        n36 = n37;
                                                                                                                                                    } while (n37 > n3);
                                                                                                                                                }
                                                                                                                                                stringArray[3] = new String(cArray35).intern();
                                                                                                                                                var0 = null;
                                                                                                                                                char[] cArray55 = "TGcVw\u0011^d\u000f;".toCharArray();
                                                                                                                                                n3 = 0;
                                                                                                                                                int n56 = cArray55.length;
                                                                                                                                                cArray34 = cArray55;
                                                                                                                                                n35 = n56;
                                                                                                                                                if (n56 <= 1) break block197;
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n34 = n35;
                                                                                                                                                if (n35 <= n3) break block198;
                                                                                                                                            }
                                                                                                                                            do {
                                                                                                                                                char[] cArray56 = cArray34;
                                                                                                                                                char[] cArray57 = cArray34;
                                                                                                                                                int n57 = n3;
                                                                                                                                                while (true) {
                                                                                                                                                    int n58;
                                                                                                                                                    char c = cArray56[n57];
                                                                                                                                                    switch (n3 % 5) {
                                                                                                                                                        case 0: {
                                                                                                                                                            n58 = 124;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 1: {
                                                                                                                                                            n58 = 46;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 2: {
                                                                                                                                                            n58 = 16;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 3: {
                                                                                                                                                            n58 = 118;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        default: {
                                                                                                                                                            n58 = 18;
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                    cArray56[n57] = (char)(c ^ n58);
                                                                                                                                                    ++n3;
                                                                                                                                                    cArray34 = cArray57;
                                                                                                                                                    n35 = n35;
                                                                                                                                                    if (n35 != 0) break;
                                                                                                                                                    cArray57 = cArray34;
                                                                                                                                                    n34 = n35;
                                                                                                                                                    n57 = n35;
                                                                                                                                                    cArray56 = cArray34;
                                                                                                                                                }
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n34 = n35;
                                                                                                                                            } while (n35 > n3);
                                                                                                                                        }
                                                                                                                                        stringArray[4] = new String(cArray33).intern();
                                                                                                                                        var0 = null;
                                                                                                                                        char[] cArray58 = "\u0012O}\u00132\u001fO~V|\u0013Z0\u0014w\\@e\u001a~".toCharArray();
                                                                                                                                        n3 = 0;
                                                                                                                                        int n59 = cArray58.length;
                                                                                                                                        cArray32 = cArray58;
                                                                                                                                        n33 = n59;
                                                                                                                                        if (n59 <= 1) break block199;
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n32 = n33;
                                                                                                                                        if (n33 <= n3) break block200;
                                                                                                                                    }
                                                                                                                                    do {
                                                                                                                                        char[] cArray59 = cArray32;
                                                                                                                                        char[] cArray60 = cArray32;
                                                                                                                                        int n60 = n3;
                                                                                                                                        while (true) {
                                                                                                                                            int n61;
                                                                                                                                            char c = cArray59[n60];
                                                                                                                                            switch (n3 % 5) {
                                                                                                                                                case 0: {
                                                                                                                                                    n61 = 124;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 1: {
                                                                                                                                                    n61 = 46;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 2: {
                                                                                                                                                    n61 = 16;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 3: {
                                                                                                                                                    n61 = 118;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                default: {
                                                                                                                                                    n61 = 18;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            cArray59[n60] = (char)(c ^ n61);
                                                                                                                                            ++n3;
                                                                                                                                            cArray32 = cArray60;
                                                                                                                                            n33 = n33;
                                                                                                                                            if (n33 != 0) break;
                                                                                                                                            cArray60 = cArray32;
                                                                                                                                            n32 = n33;
                                                                                                                                            n60 = n33;
                                                                                                                                            cArray59 = cArray32;
                                                                                                                                        }
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n32 = n33;
                                                                                                                                    } while (n33 > n3);
                                                                                                                                }
                                                                                                                                stringArray[5] = new String(cArray31).intern();
                                                                                                                                var0 = null;
                                                                                                                                char[] cArray61 = "\u0006G`Vt\u0015BuVq\u001d@0\u0018}\b\u000er\u00132\u0012[|\u001a".toCharArray();
                                                                                                                                n3 = 0;
                                                                                                                                int n62 = cArray61.length;
                                                                                                                                cArray30 = cArray61;
                                                                                                                                n31 = n62;
                                                                                                                                if (n62 <= 1) break block201;
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n30 = n31;
                                                                                                                                if (n31 <= n3) break block202;
                                                                                                                            }
                                                                                                                            do {
                                                                                                                                char[] cArray62 = cArray30;
                                                                                                                                char[] cArray63 = cArray30;
                                                                                                                                int n63 = n3;
                                                                                                                                while (true) {
                                                                                                                                    int n64;
                                                                                                                                    char c = cArray62[n63];
                                                                                                                                    switch (n3 % 5) {
                                                                                                                                        case 0: {
                                                                                                                                            n64 = 124;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 1: {
                                                                                                                                            n64 = 46;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 2: {
                                                                                                                                            n64 = 16;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 3: {
                                                                                                                                            n64 = 118;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        default: {
                                                                                                                                            n64 = 18;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    cArray62[n63] = (char)(c ^ n64);
                                                                                                                                    ++n3;
                                                                                                                                    cArray30 = cArray63;
                                                                                                                                    n31 = n31;
                                                                                                                                    if (n31 != 0) break;
                                                                                                                                    cArray63 = cArray30;
                                                                                                                                    n30 = n31;
                                                                                                                                    n63 = n31;
                                                                                                                                    cArray62 = cArray30;
                                                                                                                                }
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n30 = n31;
                                                                                                                            } while (n31 > n3);
                                                                                                                        }
                                                                                                                        stringArray[6] = new String(cArray29).intern();
                                                                                                                        var0 = null;
                                                                                                                        char[] cArray64 = "(FuVv\u0015\\u\u0015f\u0013\\iVf\u0013\u000ej\u001fb\\Ce\u0005f\\LuVs\\Xq\u001a{\u0018\u000et\u001f`\u0019Md\u0019`\u0005\u000eK".toCharArray();
                                                                                                                        n3 = 0;
                                                                                                                        int n65 = cArray64.length;
                                                                                                                        cArray28 = cArray64;
                                                                                                                        n29 = n65;
                                                                                                                        if (n65 <= 1) break block203;
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n28 = n29;
                                                                                                                        if (n29 <= n3) break block204;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        char[] cArray65 = cArray28;
                                                                                                                        char[] cArray66 = cArray28;
                                                                                                                        int n66 = n3;
                                                                                                                        while (true) {
                                                                                                                            int n67;
                                                                                                                            char c = cArray65[n66];
                                                                                                                            switch (n3 % 5) {
                                                                                                                                case 0: {
                                                                                                                                    n67 = 124;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 1: {
                                                                                                                                    n67 = 46;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 2: {
                                                                                                                                    n67 = 16;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 3: {
                                                                                                                                    n67 = 118;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                default: {
                                                                                                                                    n67 = 18;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            cArray65[n66] = (char)(c ^ n67);
                                                                                                                            ++n3;
                                                                                                                            cArray28 = cArray66;
                                                                                                                            n29 = n29;
                                                                                                                            if (n29 != 0) break;
                                                                                                                            cArray66 = cArray28;
                                                                                                                            n28 = n29;
                                                                                                                            n66 = n29;
                                                                                                                            cArray65 = cArray28;
                                                                                                                        }
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n28 = n29;
                                                                                                                    } while (n29 > n3);
                                                                                                                }
                                                                                                                stringArray[7] = new String(cArray27).intern();
                                                                                                                var0 = null;
                                                                                                                char[] cArray67 = "\fOb\u0017\u007f\\Jy\u00042\u001fO~V|\u0013Z0\u0014w\\K}\u0006f\u0005\u000ec\u0002`\u0015@w".toCharArray();
                                                                                                                n3 = 0;
                                                                                                                int n68 = cArray67.length;
                                                                                                                cArray26 = cArray67;
                                                                                                                n27 = n68;
                                                                                                                if (n68 <= 1) break block205;
                                                                                                                cArray25 = cArray26;
                                                                                                                n26 = n27;
                                                                                                                if (n27 <= n3) break block206;
                                                                                                            }
                                                                                                            do {
                                                                                                                char[] cArray68 = cArray26;
                                                                                                                char[] cArray69 = cArray26;
                                                                                                                int n69 = n3;
                                                                                                                while (true) {
                                                                                                                    int n70;
                                                                                                                    char c = cArray68[n69];
                                                                                                                    switch (n3 % 5) {
                                                                                                                        case 0: {
                                                                                                                            n70 = 124;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 1: {
                                                                                                                            n70 = 46;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 2: {
                                                                                                                            n70 = 16;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 3: {
                                                                                                                            n70 = 118;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        default: {
                                                                                                                            n70 = 18;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    cArray68[n69] = (char)(c ^ n70);
                                                                                                                    ++n3;
                                                                                                                    cArray26 = cArray69;
                                                                                                                    n27 = n27;
                                                                                                                    if (n27 != 0) break;
                                                                                                                    cArray69 = cArray26;
                                                                                                                    n26 = n27;
                                                                                                                    n69 = n27;
                                                                                                                    cArray68 = cArray26;
                                                                                                                }
                                                                                                                cArray25 = cArray26;
                                                                                                                n26 = n27;
                                                                                                            } while (n27 > n3);
                                                                                                        }
                                                                                                        stringArray[8] = new String(cArray25).intern();
                                                                                                        var0 = null;
                                                                                                        char[] cArray70 = ")@j\u001fb\\Zx\u00132\u000fZb\u0013s\u0011\u000ed\u00192\u0018GbL2".toCharArray();
                                                                                                        n3 = 0;
                                                                                                        int n71 = cArray70.length;
                                                                                                        cArray24 = cArray70;
                                                                                                        n25 = n71;
                                                                                                        if (n71 <= 1) break block207;
                                                                                                        cArray23 = cArray24;
                                                                                                        n24 = n25;
                                                                                                        if (n25 <= n3) break block208;
                                                                                                    }
                                                                                                    do {
                                                                                                        char[] cArray71 = cArray24;
                                                                                                        char[] cArray72 = cArray24;
                                                                                                        int n72 = n3;
                                                                                                        while (true) {
                                                                                                            int n73;
                                                                                                            char c = cArray71[n72];
                                                                                                            switch (n3 % 5) {
                                                                                                                case 0: {
                                                                                                                    n73 = 124;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 1: {
                                                                                                                    n73 = 46;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 2: {
                                                                                                                    n73 = 16;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 3: {
                                                                                                                    n73 = 118;
                                                                                                                    break;
                                                                                                                }
                                                                                                                default: {
                                                                                                                    n73 = 18;
                                                                                                                }
                                                                                                            }
                                                                                                            cArray71[n72] = (char)(c ^ n73);
                                                                                                            ++n3;
                                                                                                            cArray24 = cArray72;
                                                                                                            n25 = n25;
                                                                                                            if (n25 != 0) break;
                                                                                                            cArray72 = cArray24;
                                                                                                            n24 = n25;
                                                                                                            n72 = n25;
                                                                                                            cArray71 = cArray24;
                                                                                                        }
                                                                                                        cArray23 = cArray24;
                                                                                                        n24 = n25;
                                                                                                    } while (n25 > n3);
                                                                                                }
                                                                                                stringArray[9] = new String(cArray23).intern();
                                                                                                var0 = null;
                                                                                                char[] cArray73 = "\fOb\u0017\u007f\\Ty\u0006A\b\\u\u0017\u007f\\Mq\u00182\u0012AdVp\u0019\u000e~\u0003~\u0010".toCharArray();
                                                                                                n3 = 0;
                                                                                                int n74 = cArray73.length;
                                                                                                cArray22 = cArray73;
                                                                                                n23 = n74;
                                                                                                if (n74 <= 1) break block209;
                                                                                                cArray21 = cArray22;
                                                                                                n22 = n23;
                                                                                                if (n23 <= n3) break block210;
                                                                                            }
                                                                                            do {
                                                                                                char[] cArray74 = cArray22;
                                                                                                char[] cArray75 = cArray22;
                                                                                                int n75 = n3;
                                                                                                while (true) {
                                                                                                    int n76;
                                                                                                    char c = cArray74[n75];
                                                                                                    switch (n3 % 5) {
                                                                                                        case 0: {
                                                                                                            n76 = 124;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 1: {
                                                                                                            n76 = 46;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 2: {
                                                                                                            n76 = 16;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 3: {
                                                                                                            n76 = 118;
                                                                                                            break;
                                                                                                        }
                                                                                                        default: {
                                                                                                            n76 = 18;
                                                                                                        }
                                                                                                    }
                                                                                                    cArray74[n75] = (char)(c ^ n76);
                                                                                                    ++n3;
                                                                                                    cArray22 = cArray75;
                                                                                                    n23 = n23;
                                                                                                    if (n23 != 0) break;
                                                                                                    cArray75 = cArray22;
                                                                                                    n22 = n23;
                                                                                                    n75 = n23;
                                                                                                    cArray74 = cArray22;
                                                                                                }
                                                                                                cArray21 = cArray22;
                                                                                                n22 = n23;
                                                                                            } while (n23 > n3);
                                                                                        }
                                                                                        stringArray[10] = new String(cArray21).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray76 = "\fOb\u0017\u007f\\Gw\u0018}\u000eK\\\u001fa\b\u000es\u0017|\\@\u007f\u00022\u001eK0\u0018g\u0010B".toCharArray();
                                                                                        n3 = 0;
                                                                                        int n77 = cArray76.length;
                                                                                        cArray20 = cArray76;
                                                                                        n21 = n77;
                                                                                        if (n77 <= 1) break block211;
                                                                                        cArray19 = cArray20;
                                                                                        n20 = n21;
                                                                                        if (n21 <= n3) break block212;
                                                                                    }
                                                                                    do {
                                                                                        char[] cArray77 = cArray20;
                                                                                        char[] cArray78 = cArray20;
                                                                                        int n78 = n3;
                                                                                        while (true) {
                                                                                            int n79;
                                                                                            char c = cArray77[n78];
                                                                                            switch (n3 % 5) {
                                                                                                case 0: {
                                                                                                    n79 = 124;
                                                                                                    break;
                                                                                                }
                                                                                                case 1: {
                                                                                                    n79 = 46;
                                                                                                    break;
                                                                                                }
                                                                                                case 2: {
                                                                                                    n79 = 16;
                                                                                                    break;
                                                                                                }
                                                                                                case 3: {
                                                                                                    n79 = 118;
                                                                                                    break;
                                                                                                }
                                                                                                default: {
                                                                                                    n79 = 18;
                                                                                                }
                                                                                            }
                                                                                            cArray77[n78] = (char)(c ^ n79);
                                                                                            ++n3;
                                                                                            cArray20 = cArray78;
                                                                                            n21 = n21;
                                                                                            if (n21 != 0) break;
                                                                                            cArray78 = cArray20;
                                                                                            n20 = n21;
                                                                                            n78 = n21;
                                                                                            cArray77 = cArray20;
                                                                                        }
                                                                                        cArray19 = cArray20;
                                                                                        n20 = n21;
                                                                                    } while (n21 > n3);
                                                                                }
                                                                                stringArray[11] = new String(cArray19).intern();
                                                                                var0 = null;
                                                                                char[] cArray79 = "\fOb\u0017\u007f\\Ty\u0006T\u0015BuVq\u001d@0\u0018}\b\u000er\u00132\u0012[|\u001a".toCharArray();
                                                                                n3 = 0;
                                                                                int n80 = cArray79.length;
                                                                                cArray18 = cArray79;
                                                                                n19 = n80;
                                                                                if (n80 <= 1) break block213;
                                                                                cArray17 = cArray18;
                                                                                n18 = n19;
                                                                                if (n19 <= n3) break block214;
                                                                            }
                                                                            do {
                                                                                char[] cArray80 = cArray18;
                                                                                char[] cArray81 = cArray18;
                                                                                int n81 = n3;
                                                                                while (true) {
                                                                                    int n82;
                                                                                    char c = cArray80[n81];
                                                                                    switch (n3 % 5) {
                                                                                        case 0: {
                                                                                            n82 = 124;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n82 = 46;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n82 = 16;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n82 = 118;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n82 = 18;
                                                                                        }
                                                                                    }
                                                                                    cArray80[n81] = (char)(c ^ n82);
                                                                                    ++n3;
                                                                                    cArray18 = cArray81;
                                                                                    n19 = n19;
                                                                                    if (n19 != 0) break;
                                                                                    cArray81 = cArray18;
                                                                                    n18 = n19;
                                                                                    n81 = n19;
                                                                                    cArray80 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n18 = n19;
                                                                            } while (n19 > n3);
                                                                        }
                                                                        stringArray[12] = new String(cArray17).intern();
                                                                        var0 = null;
                                                                        char[] cArray82 = "\u0006G`\u0006{\u0012I0\u0002z\u0019\u000et\u001f`\u0019Md\u0019`\u0005\u000e0".toCharArray();
                                                                        n3 = 0;
                                                                        int n83 = cArray82.length;
                                                                        cArray16 = cArray82;
                                                                        n17 = n83;
                                                                        if (n83 <= 1) break block215;
                                                                        cArray15 = cArray16;
                                                                        n16 = n17;
                                                                        if (n17 <= n3) break block216;
                                                                    }
                                                                    do {
                                                                        char[] cArray83 = cArray16;
                                                                        char[] cArray84 = cArray16;
                                                                        int n84 = n3;
                                                                        while (true) {
                                                                            int n85;
                                                                            char c = cArray83[n84];
                                                                            switch (n3 % 5) {
                                                                                case 0: {
                                                                                    n85 = 124;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n85 = 46;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n85 = 16;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n85 = 118;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n85 = 18;
                                                                                }
                                                                            }
                                                                            cArray83[n84] = (char)(c ^ n85);
                                                                            ++n3;
                                                                            cArray16 = cArray84;
                                                                            n17 = n17;
                                                                            if (n17 != 0) break;
                                                                            cArray84 = cArray16;
                                                                            n16 = n17;
                                                                            n84 = n17;
                                                                            cArray83 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n16 = n17;
                                                                    } while (n17 > n3);
                                                                }
                                                                stringArray[13] = new String(cArray15).intern();
                                                                var0 = null;
                                                                char[] cArray85 = "\\\u000ey\u0018f\u0013\u000ej\u001fb:G|\u0013(\\".toCharArray();
                                                                n3 = 0;
                                                                int n86 = cArray85.length;
                                                                cArray14 = cArray85;
                                                                n15 = n86;
                                                                if (n86 <= 1) break block217;
                                                                cArray13 = cArray14;
                                                                n14 = n15;
                                                                if (n15 <= n3) break block218;
                                                            }
                                                            do {
                                                                char[] cArray86 = cArray14;
                                                                char[] cArray87 = cArray14;
                                                                int n87 = n3;
                                                                while (true) {
                                                                    int n88;
                                                                    char c = cArray86[n87];
                                                                    switch (n3 % 5) {
                                                                        case 0: {
                                                                            n88 = 124;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n88 = 46;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n88 = 16;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n88 = 118;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n88 = 18;
                                                                        }
                                                                    }
                                                                    cArray86[n87] = (char)(c ^ n88);
                                                                    ++n3;
                                                                    cArray14 = cArray87;
                                                                    n15 = n15;
                                                                    if (n15 != 0) break;
                                                                    cArray87 = cArray14;
                                                                    n14 = n15;
                                                                    n87 = n15;
                                                                    cArray86 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n14 = n15;
                                                            } while (n15 > n3);
                                                        }
                                                        stringArray[14] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray88 = "\fOb\u0017\u007f\\Jy\u0004w\u001fZ\u007f\u0004k\\Mq\u00182\u0012AdVp\u0019\u000e~\u0003~\u0010".toCharArray();
                                                        n3 = 0;
                                                        int n89 = cArray88.length;
                                                        cArray12 = cArray88;
                                                        n13 = n89;
                                                        if (n89 <= 1) break block219;
                                                        cArray11 = cArray12;
                                                        n12 = n13;
                                                        if (n13 <= n3) break block220;
                                                    }
                                                    do {
                                                        char[] cArray89 = cArray12;
                                                        char[] cArray90 = cArray12;
                                                        int n90 = n3;
                                                        while (true) {
                                                            int n91;
                                                            char c = cArray89[n90];
                                                            switch (n3 % 5) {
                                                                case 0: {
                                                                    n91 = 124;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n91 = 46;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n91 = 16;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n91 = 118;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n91 = 18;
                                                                }
                                                            }
                                                            cArray89[n90] = (char)(c ^ n91);
                                                            ++n3;
                                                            cArray12 = cArray90;
                                                            n13 = n13;
                                                            if (n13 != 0) break;
                                                            cArray90 = cArray12;
                                                            n12 = n13;
                                                            n90 = n13;
                                                            cArray89 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n12 = n13;
                                                    } while (n13 > n3);
                                                }
                                                stringArray[15] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray91 = ")@j\u001fb\\Zx\u00132\u001aG|\u00132\\".toCharArray();
                                                n3 = 0;
                                                int n92 = cArray91.length;
                                                cArray10 = cArray91;
                                                n11 = n92;
                                                if (n92 <= 1) break block221;
                                                cArray9 = cArray10;
                                                n10 = n11;
                                                if (n11 <= n3) break block222;
                                            }
                                            do {
                                                char[] cArray92 = cArray10;
                                                char[] cArray93 = cArray10;
                                                int n93 = n3;
                                                while (true) {
                                                    int n94;
                                                    char c = cArray92[n93];
                                                    switch (n3 % 5) {
                                                        case 0: {
                                                            n94 = 124;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n94 = 46;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n94 = 16;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n94 = 118;
                                                            break;
                                                        }
                                                        default: {
                                                            n94 = 18;
                                                        }
                                                    }
                                                    cArray92[n93] = (char)(c ^ n94);
                                                    ++n3;
                                                    cArray10 = cArray93;
                                                    n11 = n11;
                                                    if (n11 != 0) break;
                                                    cArray93 = cArray10;
                                                    n10 = n11;
                                                    n93 = n11;
                                                    cArray92 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n10 = n11;
                                            } while (n11 > n3);
                                        }
                                        stringArray[16] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray94 = "\\Z\u007fVv\u0015\\*V".toCharArray();
                                        n3 = 0;
                                        int n95 = cArray94.length;
                                        cArray8 = cArray94;
                                        n9 = n95;
                                        if (n95 <= 1) break block223;
                                        cArray7 = cArray8;
                                        n8 = n9;
                                        if (n9 <= n3) break block224;
                                    }
                                    do {
                                        char[] cArray95 = cArray8;
                                        char[] cArray96 = cArray8;
                                        int n96 = n3;
                                        while (true) {
                                            int n97;
                                            char c = cArray95[n96];
                                            switch (n3 % 5) {
                                                case 0: {
                                                    n97 = 124;
                                                    break;
                                                }
                                                case 1: {
                                                    n97 = 46;
                                                    break;
                                                }
                                                case 2: {
                                                    n97 = 16;
                                                    break;
                                                }
                                                case 3: {
                                                    n97 = 118;
                                                    break;
                                                }
                                                default: {
                                                    n97 = 18;
                                                }
                                            }
                                            cArray95[n96] = (char)(c ^ n97);
                                            ++n3;
                                            cArray8 = cArray96;
                                            n9 = n9;
                                            if (n9 != 0) break;
                                            cArray96 = cArray8;
                                            n8 = n9;
                                            n96 = n9;
                                            cArray95 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n8 = n9;
                                    } while (n9 > n3);
                                }
                                stringArray[17] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray97 = "\fOb\u0017\u007f\\Ty\u00062\u001aG|\u00132\u001fO~V|\u0013Z0\u0014w\\@e\u001a~".toCharArray();
                                n3 = 0;
                                int n98 = cArray97.length;
                                cArray6 = cArray97;
                                n7 = n98;
                                if (n98 <= 1) break block225;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block226;
                            }
                            do {
                                char[] cArray98 = cArray6;
                                char[] cArray99 = cArray6;
                                int n99 = n3;
                                while (true) {
                                    int n100;
                                    char c = cArray98[n99];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n100 = 124;
                                            break;
                                        }
                                        case 1: {
                                            n100 = 46;
                                            break;
                                        }
                                        case 2: {
                                            n100 = 16;
                                            break;
                                        }
                                        case 3: {
                                            n100 = 118;
                                            break;
                                        }
                                        default: {
                                            n100 = 18;
                                        }
                                    }
                                    cArray98[n99] = (char)(c ^ n100);
                                    ++n3;
                                    cArray6 = cArray99;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray99 = cArray6;
                                    n6 = n7;
                                    n99 = n7;
                                    cArray98 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        stringArray[18] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray100 = "O\u001f%7&=\u001d(C$H\u001f$3'D\u001b\"B$O\u001d%F&N\u001a#E!O\u001a#G!H\u001e F\"L\u001e F\"L\u001e F\"L\u001e F\"L\u001e F\"L\u001e F\"L\u001e F\"L\u001e F\"L\u001e F\"H\u0018%C!K\u001d)C'O\u001d#G!N\u001e F\"H\u0019$E'E\u001a!C$I\u001e%E'I\u001d$B&Hk$B\"L\u001e ".toCharArray();
                        n3 = 0;
                        int n101 = cArray100.length;
                        cArray4 = cArray100;
                        n5 = n101;
                        if (n101 <= 1) break block227;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block228;
                    }
                    do {
                        char[] cArray101 = cArray4;
                        char[] cArray102 = cArray4;
                        int n102 = n3;
                        while (true) {
                            int n103;
                            char c = cArray101[n102];
                            switch (n3 % 5) {
                                case 0: {
                                    n103 = 124;
                                    break;
                                }
                                case 1: {
                                    n103 = 46;
                                    break;
                                }
                                case 2: {
                                    n103 = 16;
                                    break;
                                }
                                case 3: {
                                    n103 = 118;
                                    break;
                                }
                                default: {
                                    n103 = 18;
                                }
                            }
                            cArray101[n102] = (char)(c ^ n103);
                            ++n3;
                            cArray4 = cArray102;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray102 = cArray4;
                            n4 = n5;
                            n102 = n5;
                            cArray101 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[19] = new String(cArray3).intern();
                var0 = null;
                char[] cArray103 = "?Ae\u001av\\@\u007f\u00022\u000eKc\u0013f\\Ty\u00062\u001d\\s\u001e{\nK".toCharArray();
                n3 = 0;
                int n104 = cArray103.length;
                cArray2 = cArray103;
                n2 = n104;
                if (n104 <= 1) break block229;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block230;
            }
            do {
                char[] cArray104 = cArray2;
                char[] cArray105 = cArray2;
                int n105 = n3;
                while (true) {
                    int n106;
                    char c = cArray104[n105];
                    switch (n3 % 5) {
                        case 0: {
                            n106 = 124;
                            break;
                        }
                        case 1: {
                            n106 = 46;
                            break;
                        }
                        case 2: {
                            n106 = 16;
                            break;
                        }
                        case 3: {
                            n106 = 118;
                            break;
                        }
                        default: {
                            n106 = 18;
                        }
                    }
                    cArray104[n105] = (char)(c ^ n106);
                    ++n3;
                    cArray2 = cArray105;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray105 = cArray2;
                    n = n2;
                    n105 = n2;
                    cArray104 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[20] = new String(cArray).intern();
        z = stringArray;
        a = Logger.getLogger(ZipUtils.class);
    }
}

