/*
 * Decompiled with CFR 0.152.
 */
package com.buzanonline.chaos.guiutilities.image;

import com.buzanonline.chaos.guiutilities.math.MathUtilities;
import com.thinkbuzan.chaos.guiutilities.dialogs.AbstractProgressMonitor;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ImageUtilities {
    private static final BufferedImage a = new BufferedImage(1, 1, 12);
    private static final int b = (int)Math.pow(2.0, 8.0);
    public static int c;

    private ImageUtilities() {
    }

    public static BufferedImage getResizedInstance(BufferedImage bufferedImage, int n, int n2) {
        int n3;
        block3: {
            block2: {
                if (!bufferedImage.getColorModel().hasAlpha()) break block2;
                n3 = 2;
                if (c == 0) break block3;
            }
            n3 = 1;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, n3);
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage ensureTypeIs(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2;
        block3: {
            block2: {
                if (bufferedImage.getType() != n) break block2;
                bufferedImage2 = bufferedImage;
                if (c == 0) break block3;
            }
            bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
            Graphics graphics = bufferedImage2.getGraphics();
            graphics.drawImage(bufferedImage, 0, 0, null);
            graphics.dispose();
        }
        return bufferedImage2;
    }

    public static BufferedImage getFasterScaledInstance(BufferedImage bufferedImage, int n, int n2, Object object, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        Graphics2D graphics2D;
        BufferedImage bufferedImage2;
        BufferedImage bufferedImage3;
        int n7;
        boolean bl2;
        int n8;
        block18: {
            block17: {
                block16: {
                    block15: {
                        n8 = c;
                        bl2 = bl;
                        if (bl2) {
                            n7 = bufferedImage.getWidth();
                            int n9 = bufferedImage.getHeight();
                            if (n7 <= n || n9 <= n2) {
                                bl2 = false;
                            }
                        }
                        if (bufferedImage.getTransparency() != 1) break block15;
                        n7 = 1;
                        if (n8 == 0) break block16;
                    }
                    n7 = 2;
                }
                bufferedImage3 = bufferedImage;
                bufferedImage2 = null;
                graphics2D = null;
                n6 = bufferedImage3.getWidth();
                n5 = bufferedImage3.getHeight();
                if (!bl2) break block17;
                n4 = bufferedImage.getWidth();
                n3 = bufferedImage.getHeight();
                if (n8 == 0) break block18;
            }
            n4 = n;
            n3 = n2;
        }
        do {
            if (bl2 && n4 > n && (n4 /= 2) < n) {
                n4 = n;
            }
            if (bl2 && n3 > n2 && (n3 /= 2) < n2) {
                n3 = n2;
            }
            if (bufferedImage2 == null) {
                bufferedImage2 = new BufferedImage(n4, n3, n7);
                graphics2D = bufferedImage2.createGraphics();
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            graphics2D.drawImage(bufferedImage3, 0, 0, n4, n3, 0, 0, n6, n5, null);
            n6 = n4;
            n5 = n3;
            bufferedImage3 = bufferedImage2;
        } while (n4 != n || n3 != n2);
        if (graphics2D != null) {
            graphics2D.dispose();
        }
        if (n != bufferedImage3.getWidth() || n2 != bufferedImage3.getHeight()) {
            bufferedImage2 = new BufferedImage(n, n2, n7);
            graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)bufferedImage3, 0, 0, null);
            graphics2D.dispose();
            bufferedImage3 = bufferedImage2;
        }
        if (AbstractProgressMonitor.e) {
            c = ++n8;
        }
        return bufferedImage3;
    }

    public static void drawImageWithinBoundsNoCrop(Graphics2D graphics2D, BufferedImage bufferedImage, int n, int n2, int n3, int n4, Color color) {
        int n5;
        int n6;
        int n7;
        int n8;
        block3: {
            int n9;
            double d;
            block2: {
                double d2;
                d = (double)bufferedImage.getWidth() / (double)bufferedImage.getHeight();
                if (!(d > (d2 = (double)n3 / (double)n4))) break block2;
                n8 = n3;
                n7 = (int)((double)n3 / d);
                n9 = (n4 - n7) / 2 + 1;
                n6 = n;
                n5 = n2 + n9;
                graphics2D.setColor(color);
                graphics2D.fillRect(n, n2, n3, n9);
                graphics2D.fillRect(n, n2 + n4 - n9, n3, n9);
                if (c == 0) break block3;
            }
            n8 = (int)((double)n4 * d);
            n7 = n4;
            n9 = (n3 - n8) / 2 + 1;
            n6 = n + n9;
            n5 = n2;
            graphics2D.setColor(color);
            graphics2D.fillRect(n, n2, n9, n4);
            graphics2D.fillRect(n + n3 - n9, n2, n9, n4);
        }
        graphics2D.drawImage(bufferedImage, n6, n5, n8, n7, null);
    }

    public static void drawImageWithinBoundsAllowCrop(Graphics2D graphics2D, BufferedImage bufferedImage, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        block3: {
            int n7;
            double d;
            block2: {
                double d2;
                d = (double)bufferedImage.getWidth() / (double)bufferedImage.getHeight();
                if (!(d < (d2 = (double)n / (double)n2))) break block2;
                n6 = n;
                n5 = (int)((double)n / d);
                n7 = (n5 - n2) / 2;
                n4 = 0;
                n3 = -n7;
                if (c == 0) break block3;
            }
            n6 = (int)((double)n2 * d);
            n5 = n2;
            n7 = (n6 - n) / 2;
            n4 = -n7;
            n3 = 0;
        }
        graphics2D.drawImage(bufferedImage, n4, n3, n6, n5, null);
    }

    public static BufferedImage getDesaturatedInstance(BufferedImage bufferedImage, float f) {
        return ImageUtilities.desaturate(ImageUtilities.copy(bufferedImage), f);
    }

    public static BufferedImage desaturate(BufferedImage bufferedImage, float f) {
        int n = c;
        int[] nArray = new int[bufferedImage.getWidth() * bufferedImage.getHeight()];
        bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), nArray, 0, bufferedImage.getWidth());
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            int n3 = (n2 & 0xFF000000) >> 24;
            int n4 = (n2 & 0xFF0000) >> 16;
            int n5 = (n2 & 0xFF00) >> 8;
            int n6 = (n2 & 0xFF) >> 0;
            int n7 = (int)(0.3 * (double)n4 + 0.59 * (double)n5 + 0.11 * (double)n6);
            int n8 = MathUtilities.mix(n4, n7, f);
            int n9 = MathUtilities.mix(n5, n7, f);
            int n10 = MathUtilities.mix(n6, n7, f);
            nArray[i] = (n3 << 24) + (n8 << 16) + (n9 << 8) + (n10 << 0);
            if (n == 0) continue;
        }
        bufferedImage.setRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), nArray, 0, bufferedImage.getWidth());
        return bufferedImage;
    }

    public static BufferedImage getTintedInstance(BufferedImage bufferedImage, Color color) {
        return ImageUtilities.tint(ImageUtilities.copy(bufferedImage), color);
    }

    public static BufferedImage tint(BufferedImage bufferedImage, Color color) {
        int n = c;
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        int[] nArray = new int[bufferedImage.getWidth() * bufferedImage.getHeight()];
        bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), nArray, 0, bufferedImage.getWidth());
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            int n3 = (n2 & 0xFF000000) >> 24;
            int n4 = (n2 & 0xFF0000) >> 16;
            int n5 = (n2 & 0xFF00) >> 8;
            int n6 = (n2 & 0xFF) >> 0;
            float f = fArray[2] * (float)Math.max(n4, Math.max(n5, n6)) / (float)b;
            Color color2 = Color.getHSBColor(fArray[0], fArray[1], f);
            nArray[i] = (n3 << 24) + (color2.getRed() << 16) + (color2.getGreen() << 8) + (color2.getBlue() << 0);
            if (n == 0) continue;
        }
        bufferedImage.setRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), nArray, 0, bufferedImage.getWidth());
        return bufferedImage;
    }

    public static BufferedImage iconToImage(Icon icon) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics graphics = bufferedImage.getGraphics();
        icon.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        return bufferedImage;
    }

    public static ImageIcon createTintedIcon(ImageIcon imageIcon, Color color) {
        BufferedImage bufferedImage = ImageUtilities.iconToImage(imageIcon);
        ImageUtilities.tint(bufferedImage, color);
        return new ImageIcon(bufferedImage);
    }

    public static Graphics getHelperGraphics() {
        return a.getGraphics();
    }

    public static BufferedImage applyShine(BufferedImage bufferedImage) {
        int n = c;
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        GeneralPath generalPath = new GeneralPath();
        float f = 0.0f;
        float f2 = 0.75f * (float)bufferedImage.getHeight();
        float f3 = bufferedImage.getWidth();
        float f4 = 0.85f * (float)bufferedImage.getHeight();
        float f5 = 0.5f * (float)bufferedImage.getWidth();
        float f6 = 0.9f * (float)bufferedImage.getHeight();
        generalPath.moveTo(0.0f, f2);
        generalPath.quadTo(f5, f6, f3, f4);
        generalPath.lineTo(bufferedImage.getWidth(), bufferedImage.getHeight());
        generalPath.lineTo(0.0f, bufferedImage.getHeight());
        Color color = new Color(255, 255, 255, 100);
        Color color2 = new Color(255, 255, 255, 0);
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, 0.0f, bufferedImage.getHeight(), color2));
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f7 = 0.2f;
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.2f));
        graphics2D.setColor(Color.BLACK);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        if (n != 0) {
            AbstractProgressMonitor.e = !AbstractProgressMonitor.e;
        }
        return bufferedImage;
    }

    public static BufferedImage getShinedInstance(BufferedImage bufferedImage) {
        return ImageUtilities.applyShine(ImageUtilities.copy(bufferedImage));
    }

    public static BufferedImage copy(BufferedImage bufferedImage) {
        int n;
        block3: {
            block2: {
                if (!bufferedImage.getColorModel().hasAlpha()) break block2;
                n = 2;
                if (c == 0) break block3;
            }
            n = 1;
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, null);
        graphics.dispose();
        return bufferedImage2;
    }

    public static BufferedImage toBufferedImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        return bufferedImage;
    }
}

