/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.infobox.impl.base;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.preferences.PreferencesService;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.gaia.infobox.ConfirmType;
import com.thinkbuzan.gaia.infobox.impl.base.InfoBoxActionListener;
import com.thinkbuzan.gaia.infobox.impl.base.InfoBoxDialog;
import com.thinkbuzan.gaia.infobox.impl.base.WelcomeDialog;
import java.awt.Window;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class InfoBoxBuilder {
    private static final String DEFAULT_YES_BUTTON_TXY = "com.thinkbuzan.i18n.common.yes";
    private static final String DEFAULT_NO_BUTTON_TXY = "com.thinkbuzan.i18n.common.no";
    private static final String DEFAULT_OK_BUTTON_TXY = "com.thinkbuzan.i18n.common.ok";
    private static final String DEFAULT_CANCEL_BUTTON_TXY = "com.thinkbuzan.i18n.common.cancel";
    private final transient I18n i18n;
    private final transient PreferencesService preferencesService;
    private final transient ActionManager actionManager;
    private static final Logger LOGGER = Logger.getLogger(InfoBoxBuilder.class);

    public InfoBoxBuilder(I18n i18nIn, PreferencesService preferences, ActionManager actionManagerIn) {
        this.validateInfoBoxBuilder(i18nIn, preferences, actionManagerIn);
        this.i18n = i18nIn;
        this.preferencesService = preferences;
        this.actionManager = actionManagerIn;
    }

    private void validateInfoBoxBuilder(I18n i18nIn, PreferencesService preferences, ActionManager actionManagerIn) {
        if (null == i18nIn) {
            throw new IllegalArgumentException("i18nIn can't be null.");
        }
        if (null == preferences) {
            throw new IllegalArgumentException("preferences can't be null.");
        }
        if (null == actionManagerIn) {
            throw new IllegalArgumentException("action manager can't be null.");
        }
    }

    public final InfoBoxDialog buildActionDialog(Window parent, String titleKey, String messageKey, Icon icon, String buttonTextKey, String gaiaAction, String closeButtonTxtKey, String preferenceKey, boolean preferenceChecked) {
        this.validateBuildActionDialog(titleKey, messageKey, icon, buttonTextKey, gaiaAction, closeButtonTxtKey);
        if (!this.isDialogNeeded(preferenceKey)) {
            return null;
        }
        boolean addPreferenceCheckBox = this.shouldAddPreferenceCheckBox(preferenceKey);
        InfoBoxDialog infoBox = this.instanceInfoBoxDialog(parent, addPreferenceCheckBox);
        infoBox.setTitle(this.getLocalizedText(titleKey));
        infoBox.setMessage(this.getLocalizedText(messageKey));
        infoBox.setIcon(icon);
        this.addActionButton(buttonTextKey, gaiaAction, preferenceKey, infoBox);
        this.addCloseButton(closeButtonTxtKey, preferenceKey, infoBox);
        infoBox.pack();
        infoBox.setLocationRelativeTo(null);
        return infoBox;
    }

    public final InfoBoxDialog buildActionDialog(Window parent, String titleKey, String messageKey, Icon icon, String buttonTextKey, String gaiaAction, String closeButtonTxtKey, String preferenceKey) {
        return this.buildActionDialog(parent, titleKey, messageKey, icon, buttonTextKey, gaiaAction, closeButtonTxtKey, preferenceKey, false);
    }

    private boolean shouldAddPreferenceCheckBox(String preferenceKey) {
        return preferenceKey != null && !"".equals(preferenceKey.trim());
    }

    private void validateBuildActionDialog(String titleKey, String messageKey, Icon icon, String buttonTextKey, String gaiaAction, String closeButtonTxtKey) {
        this.validateTitleKey(titleKey);
        this.validateMessageKey(messageKey);
        this.validateIcon(icon);
        this.validateButtonTextKey(buttonTextKey);
        if (null == gaiaAction) {
            throw new IllegalArgumentException("gaiaAction can't be null.");
        }
        this.validateCloseButtonTextKey(closeButtonTxtKey);
    }

    private void addActionButton(String buttonTextKey, String gaiaAction, String preferenceKey, InfoBoxDialog infoBox) {
        JButton actionButton = new JButton(this.getLocalizedText(buttonTextKey));
        actionButton.addActionListener(new InfoBoxActionListener(this.preferencesService.getHiddenSystemPreferences(), this.actionManager, infoBox, preferenceKey, gaiaAction));
        infoBox.addButton(actionButton);
    }

    private void addActionButton(String buttonTextKey, String gaiaAction, String preferenceKey, InfoBoxDialog infoBox, Object[] actionParams) {
        JButton actionButton = new JButton(this.getLocalizedText(buttonTextKey));
        actionButton.addActionListener(new InfoBoxActionListener(this.preferencesService.getHiddenSystemPreferences(), this.actionManager, infoBox, preferenceKey, gaiaAction, actionParams));
        infoBox.addButton(actionButton);
    }

    private void addCloseButton(String closeButtonTxtKey, String preferenceKey, InfoBoxDialog infoBox) {
        JButton closeButton = new JButton(this.getLocalizedText(closeButtonTxtKey));
        closeButton.addActionListener(new InfoBoxActionListener(this.preferencesService.getHiddenSystemPreferences(), infoBox, preferenceKey));
        infoBox.addButton(closeButton);
    }

    public final InfoBoxDialog buildConfirmDialog(Window parent, String titleKey, String messageKey, Icon icon, ConfirmType confirmType, String gaiaAction, String preferenceKey) {
        this.validateBuildConfirmDialog(titleKey, messageKey, icon, confirmType, gaiaAction);
        if (!this.isDialogNeeded(preferenceKey)) {
            return null;
        }
        boolean addPreferenceCheckBox = this.shouldAddPreferenceCheckBox(preferenceKey);
        InfoBoxDialog infoBox = this.instanceInfoBoxDialog(parent, addPreferenceCheckBox);
        infoBox.setTitle(this.getLocalizedText(titleKey));
        infoBox.setMessage(this.getLocalizedText(messageKey));
        infoBox.setIcon(icon);
        if (confirmType.equals((Object)ConfirmType.OK_CANCEL_OPTION)) {
            this.addActionButton(DEFAULT_OK_BUTTON_TXY, gaiaAction, preferenceKey, infoBox);
            this.addCloseButton(DEFAULT_CANCEL_BUTTON_TXY, preferenceKey, infoBox);
        } else {
            this.addActionButton(DEFAULT_YES_BUTTON_TXY, gaiaAction, preferenceKey, infoBox);
            this.addCloseButton(DEFAULT_NO_BUTTON_TXY, preferenceKey, infoBox);
        }
        infoBox.pack();
        infoBox.setLocationRelativeTo(null);
        return infoBox;
    }

    private void validateBuildConfirmDialog(String titleKey, String messageKey, Icon icon, ConfirmType confirmType, String gaiaAction) {
        this.validateTitleKey(titleKey);
        this.validateMessageKey(messageKey);
        this.validateIcon(icon);
        if (null == confirmType) {
            throw new IllegalArgumentException("buttonTextKey can't be empty.");
        }
        if (null == gaiaAction) {
            throw new IllegalArgumentException("gaiaAction can't be null.");
        }
    }

    public final InfoBoxDialog buildHelpDialog(Window parent, String titleKey, String messageKey, Icon icon, String buttonTextKey, String helpTopic, String closeButtonTxtKey, String preferenceKey) {
        this.validateBuildHelpDialog(titleKey, messageKey, icon, buttonTextKey, helpTopic, closeButtonTxtKey);
        if (!this.isDialogNeeded(preferenceKey)) {
            return null;
        }
        boolean addPreferenceCheckBox = this.shouldAddPreferenceCheckBox(preferenceKey);
        InfoBoxDialog infoBox = this.instanceInfoBoxDialog(parent, addPreferenceCheckBox);
        infoBox.setTitle(this.getLocalizedText(titleKey));
        infoBox.setMessage(this.getLocalizedText(messageKey));
        infoBox.setIcon(icon);
        this.addActionButton(buttonTextKey, "TODO", preferenceKey, infoBox);
        this.addCloseButton(closeButtonTxtKey, preferenceKey, infoBox);
        infoBox.pack();
        infoBox.setLocationRelativeTo(null);
        return infoBox;
    }

    private void validateBuildHelpDialog(String titleKey, String messageKey, Icon icon, String buttonTextKey, String helpTopic, String closeButtonTxtKey) {
        if (null == titleKey || "".equals(titleKey.trim())) {
            throw new IllegalArgumentException("titltKey can't be empty.");
        }
        this.validateMessageKey(messageKey);
        this.validateIcon(icon);
        this.validateButtonTextKey(buttonTextKey);
        if (null == helpTopic || "".equals(helpTopic.trim())) {
            throw new IllegalArgumentException("helpTopic can't be empty.");
        }
        this.validateCloseButtonTextKey(closeButtonTxtKey);
    }

    public final InfoBoxDialog buildLinkDialog(Window parent, String titleKey, String messageKey, Icon icon, String buttonTextKey, URL hyperLink, String closeButtonTxtKey, String preferenceKey, boolean preferenceChecked) {
        this.validateBuildLinkDialog(titleKey, messageKey, icon, buttonTextKey, hyperLink, closeButtonTxtKey);
        if (!this.isDialogNeeded(preferenceKey)) {
            return null;
        }
        boolean addPreferenceCheckBox = this.shouldAddPreferenceCheckBox(preferenceKey);
        InfoBoxDialog infoBox = this.instanceInfoBoxDialog(parent, addPreferenceCheckBox, preferenceChecked);
        infoBox.setTitle(this.getLocalizedText(titleKey));
        infoBox.setMessage(this.getLocalizedText(messageKey));
        infoBox.setIcon(icon);
        try {
            this.addActionButton(buttonTextKey, "com.thinkbuzan.gaia.actions.open.OpenURIAction", preferenceKey, infoBox, new Object[]{new URI(hyperLink.getAuthority() + hyperLink.getPath())});
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"Couldn't add action listsner to button!", (Throwable)e);
        }
        this.addCloseButton(closeButtonTxtKey, preferenceKey, infoBox);
        infoBox.pack();
        infoBox.setLocationRelativeTo(null);
        return infoBox;
    }

    public final InfoBoxDialog buildLinkDialog(Window parent, String titleKey, String messageKey, Icon icon, String buttonTextKey, URL hyperLink, String closeButtonTxtKey, String preferenceKey) {
        return this.buildLinkDialog(parent, titleKey, messageKey, icon, buttonTextKey, hyperLink, closeButtonTxtKey, preferenceKey, false);
    }

    private void validateBuildLinkDialog(String titleKey, String messageKey, Icon icon, String buttonTextKey, URL hyperLink, String closeButtonTxtKey) {
        if (null == titleKey || "".equals(titleKey.trim())) {
            throw new IllegalArgumentException("titleKey key can't be empty.");
        }
        this.validateMessageKey(messageKey);
        this.validateIcon(icon);
        this.validateButtonTextKey(buttonTextKey);
        if (null == hyperLink) {
            throw new IllegalArgumentException("hyperLink can't be null.");
        }
        this.validateCloseButtonTextKey(closeButtonTxtKey);
    }

    public final InfoBoxDialog buildMessageDialog(Window parent, String titleKey, String messageKey, Icon icon, String closeButtonTxtKey, String preferenceKey, boolean preferenceChecked) {
        this.validateBuildMessageDialog(titleKey, messageKey, icon, closeButtonTxtKey);
        if (!this.isDialogNeeded(preferenceKey)) {
            return null;
        }
        boolean addPreferenceCheckBox = this.shouldAddPreferenceCheckBox(preferenceKey);
        InfoBoxDialog infoBox = this.instanceInfoBoxDialog(parent, addPreferenceCheckBox, preferenceChecked);
        infoBox.setTitle(this.getLocalizedText(titleKey));
        infoBox.setMessage(this.getLocalizedText(messageKey));
        infoBox.setIcon(icon);
        this.addCloseButton(closeButtonTxtKey, preferenceKey, infoBox);
        infoBox.pack();
        infoBox.setLocationRelativeTo(null);
        return infoBox;
    }

    public final InfoBoxDialog buildMessageDialog(Window parent, String titleKey, String messageKey, Icon icon, String closeButtonTxtKey, String preferenceKey) {
        return this.buildMessageDialog(parent, titleKey, messageKey, icon, closeButtonTxtKey, preferenceKey, false);
    }

    private boolean isDialogNeeded(String preferenceKey) {
        if (preferenceKey == null || "".equals(preferenceKey.trim())) {
            return true;
        }
        return !this.preferencesService.getHiddenSystemPreferences().getBoolean(preferenceKey, false);
    }

    private void validateBuildMessageDialog(String titleKey, String messageKey, Icon icon, String closeButtonTxtKey) {
        this.validateTitleKey(titleKey);
        this.validateMessageKey(messageKey);
        this.validateIcon(icon);
        this.validateCloseButtonTextKey(closeButtonTxtKey);
    }

    private String getLocalizedText(String key) {
        return this.i18n.getLocalizedText(key);
    }

    private InfoBoxDialog instanceInfoBoxDialog(Window parent, boolean addPreferenceCheckBox, boolean preferenceChecked) {
        InfoBoxDialog infoBox = parent instanceof JDialog ? new InfoBoxDialog((JDialog)parent, this.i18n, preferenceChecked, addPreferenceCheckBox, false) : (parent instanceof JFrame ? new InfoBoxDialog((JFrame)parent, this.i18n, preferenceChecked, addPreferenceCheckBox, false) : new InfoBoxDialog((JFrame)null, this.i18n, preferenceChecked, addPreferenceCheckBox, false));
        return infoBox;
    }

    private InfoBoxDialog instanceInfoBoxDialog(Window parent, boolean addPreferenceCheckBox) {
        return this.instanceInfoBoxDialog(parent, addPreferenceCheckBox, false);
    }

    private void validateMessageKey(String messageKey) {
        if (null == messageKey || "".equals(messageKey.trim())) {
            throw new IllegalArgumentException("messageKey can't be empty.");
        }
    }

    private void validateButtonTextKey(String buttonTextKey) {
        if (null == buttonTextKey || "".equals(buttonTextKey.trim())) {
            throw new IllegalArgumentException("buttonTextKey can't be empty.");
        }
    }

    private void validateCloseButtonTextKey(String closeButtonTxtKey) {
        if (null == closeButtonTxtKey || "".equals(closeButtonTxtKey.trim())) {
            throw new IllegalArgumentException("closeButtonTxtKey can't be empty.");
        }
    }

    private void validateTitleKey(String titleKey) {
        if (null == titleKey || "".equals(titleKey.trim())) {
            throw new IllegalArgumentException("titleKey can't be empty.");
        }
    }

    private void validateIcon(Icon icon) {
        if (null == icon) {
            throw new IllegalArgumentException("icon can't be null.");
        }
    }

    public final WelcomeDialog buildWelcomeDialog(Window parent) {
        this.validateBuildWelcomeDialog(parent);
        WelcomeDialog welcome = this.instanceWelcomeDialog(parent);
        welcome.pack();
        welcome.setLocationRelativeTo(null);
        return welcome;
    }

    private void validateBuildWelcomeDialog(Window parent) {
        if (parent == null) {
            throw new IllegalArgumentException("parent can't be null");
        }
        if (!(parent instanceof Window)) {
            throw new IllegalArgumentException("parent must be instanceof Window");
        }
    }

    private WelcomeDialog instanceWelcomeDialog(Window parent) {
        WelcomeDialog welcome = parent instanceof JFrame ? new WelcomeDialog((JFrame)parent, this.i18n) : new WelcomeDialog((JFrame)null, this.i18n);
        return welcome;
    }
}

