/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.infobox.impl.base;

import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.pascal.guielements.utils.HTMLUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class InfoBoxDialog
extends JDialog {
    private static final long serialVersionUID = 6324669177854951322L;
    private static final int DEFAULT_GAP = 20;
    private static final int MESSAGE_WIDTH_MAX = 550;
    private static final String PREFERENCE_CHECKBOX_TXT = "com.thinkbuzan.i18n.infobox.donotshowagain";
    private final transient I18n i18n;
    private transient JPanel buttonPanel;
    private transient JPanel contentPanel;
    private transient JPanel iconPanel;
    private transient JPanel messagePanel;
    private transient JLabel messageLbl;
    private transient JPanel footerPanel;
    private transient JLabel footerLbl;
    private transient JPanel buttonFooterPanel;
    private transient JCheckBox preferenceCheckBox;

    public InfoBoxDialog(JFrame parent, I18n i18nIn, boolean preferenceSetting, boolean addPreferenceCheckBox, boolean checkBoxLast) {
        super(parent);
        this.i18n = i18nIn;
        this.initialiseDialog(preferenceSetting, addPreferenceCheckBox, checkBoxLast);
    }

    public InfoBoxDialog(JDialog parent, I18n i18nIn, boolean preferenceSetting, boolean addPreferenceCheckBox, boolean checkBoxLast) {
        super(parent);
        this.i18n = i18nIn;
        this.initialiseDialog(preferenceSetting, addPreferenceCheckBox, checkBoxLast);
    }

    private void initialiseDialog(boolean preferenceSetting, boolean addPreferenceCheckBox, boolean checkBoxLast) {
        this.messageLbl = this.getMessageLabel();
        this.footerLbl = this.getMessageLabel();
        this.messageLbl.setFont(this.messageLbl.getFont().deriveFont(this.messageLbl.getFont().getSize2D() + 1.0f));
        JPanel preferencePanel = null;
        if (addPreferenceCheckBox) {
            preferencePanel = this.createPreferencePanel(preferenceSetting, checkBoxLast);
        }
        if (checkBoxLast) {
            this.initContentPanel(null);
            this.initButtonPanel(preferencePanel);
        } else {
            this.initContentPanel(preferencePanel);
            this.initButtonPanel(null);
        }
        this.initLayout();
        if (SystemInfo.isLinux()) {
            this.changeBackgroundColour(this.buttonPanel);
            this.changeBackgroundColour(this.iconPanel);
            this.changeBackgroundColour(this.contentPanel);
            this.changeBackgroundColour(this.messagePanel);
            this.changeBackgroundColour(this.footerPanel);
            this.changeBackgroundColour(this.buttonFooterPanel);
        }
    }

    private JPanel createPreferencePanel(boolean preferenceSetting, boolean checkBoxLast) {
        LookAndFeel current = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.preferenceCheckBox = new JCheckBox(this.i18n.getLocalizedText(PREFERENCE_CHECKBOX_TXT));
        try {
            UIManager.setLookAndFeel(current);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.preferenceCheckBox.setSelected(preferenceSetting);
        JPanel preferencePanel = new JPanel();
        if (checkBoxLast) {
            preferencePanel.setLayout(new FlowLayout(2));
        } else {
            preferencePanel.setLayout(new FlowLayout(1));
        }
        preferencePanel.add(this.preferenceCheckBox);
        if (SystemInfo.isLinux()) {
            this.changeBackgroundColour(preferencePanel);
        }
        return preferencePanel;
    }

    private void changeBackgroundColour(JPanel panel) {
        panel.setOpaque(true);
        panel.setBackground(Color.WHITE);
    }

    private JLabel getMessageLabel() {
        JLabel lbl = new JLabel(){
            private static final long serialVersionUID = -2815600265212592377L;

            public void setText(String text) {
                if (text == null) {
                    super.setText(text);
                } else {
                    super.setText("<html><div style=\"text-align:center\">" + text.replaceAll("\n", "<br>") + "</div></html>");
                }
            }
        };
        lbl.setHorizontalAlignment(0);
        return lbl;
    }

    private void initContentPanel(JPanel prefPanel) {
        this.contentPanel = new JPanel(new BorderLayout(20, 20));
        Border panelBorder = BorderFactory.createEmptyBorder(20, 20, 20, 20);
        this.contentPanel.setBorder(panelBorder);
        this.iconPanel = new JPanel();
        this.contentPanel.add((Component)this.iconPanel, "West");
        this.messagePanel = new JPanel();
        this.contentPanel.add((Component)this.messagePanel, "Center");
        if (prefPanel != null) {
            this.contentPanel.add((Component)prefPanel, "South");
        }
    }

    private void initButtonPanel(JPanel prefPanel) {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(1, 10, 0));
        this.footerPanel = new JPanel();
        this.buttonFooterPanel = new JPanel(new BorderLayout(10, 10));
        Border panelBorder = BorderFactory.createEmptyBorder(0, 20, 0, 20);
        this.buttonFooterPanel.setBorder(panelBorder);
        this.buttonFooterPanel.add((Component)this.buttonPanel, "North");
        this.buttonFooterPanel.add((Component)this.footerPanel, "Center");
        if (prefPanel != null) {
            this.buttonFooterPanel.add((Component)prefPanel, "South");
        }
    }

    public final void setIcon(Icon icon) {
        this.iconPanel.removeAll();
        if (icon != null) {
            BoxLayout layout = new BoxLayout(this.iconPanel, 1);
            this.iconPanel.setLayout(layout);
            Box box = Box.createVerticalBox();
            JLabel iconLabel = new JLabel();
            iconLabel.setIcon(icon);
            box.add(iconLabel);
            box.add(Box.createVerticalGlue());
            this.iconPanel.add(box);
        }
    }

    public final void setMessage(String message) {
        this.validateSetMessage(message);
        this.messagePanel.setLayout(new BoxLayout(this.messagePanel, 0));
        this.messagePanel.removeAll();
        this.messageLbl.setText(message);
        this.messageLbl.setBackground(this.messagePanel.getBackground());
        int prefW = Math.min(550, this.messageLbl.getPreferredSize().width);
        int prefH = HTMLUtils.getPreferredHeight((JLabel)this.messageLbl, (int)prefW);
        this.messageLbl.setPreferredSize(new Dimension(prefW, prefH));
        this.messagePanel.add(Box.createHorizontalGlue());
        this.messagePanel.add(this.messageLbl);
        this.messagePanel.add(Box.createHorizontalGlue());
    }

    public final void setFooterMessage(String message) {
        this.footerPanel.setLayout(new BoxLayout(this.footerPanel, 0));
        this.footerPanel.removeAll();
        if (message != null) {
            this.footerLbl.setText(message);
            this.footerLbl.setBackground(this.footerPanel.getBackground());
            int prefW = Math.min(550, this.footerLbl.getPreferredSize().width);
            int prefH = HTMLUtils.getPreferredHeight((JLabel)this.footerLbl, (int)prefW);
            this.footerLbl.setPreferredSize(new Dimension(prefW, prefH));
            this.footerPanel.add(Box.createHorizontalGlue());
            this.footerPanel.add(this.footerLbl);
            this.footerPanel.add(Box.createHorizontalGlue());
        }
    }

    private void validateSetMessage(String message) {
        if (null == message || message.trim().equals("")) {
            throw new IllegalArgumentException("message can't be empty.");
        }
    }

    public final void addButton(JButton button) {
        this.validateAddButton(button);
        this.buttonPanel.add(button);
    }

    private void validateAddButton(JButton button) {
        if (null == button) {
            throw new IllegalArgumentException("button can't be null.");
        }
        if (null == button.getText() || "".equals(button.getText().trim())) {
            throw new IllegalArgumentException("button text can't be empty.");
        }
    }

    private void initLayout() {
        int margin = SystemInfo.isLinux() ? 0 : 5;
        this.setModal(true);
        this.setLayout(new BorderLayout(margin, margin));
        this.add((Component)this.contentPanel, "Center");
        this.add((Component)this.buttonFooterPanel, "South");
        this.setResizable(false);
    }

    public final boolean isPreferenceCheckBoxSelected() {
        if (this.preferenceCheckBox == null) {
            return false;
        }
        return this.preferenceCheckBox.isSelected();
    }
}

