/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.infobox.impl.mac;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.preferences.PreferencesService;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.gaia.infobox.ConfirmType;
import com.thinkbuzan.gaia.infobox.InfoBox;
import com.thinkbuzan.gaia.infobox.impl.base.InfoBoxBuilder;
import com.thinkbuzan.gaia.infobox.impl.base.InfoBoxDialog;
import com.thinkbuzan.gaia.infobox.impl.base.WelcomeDialog;
import com.thinkbuzan.gaia.infobox.resources.ImageResourceManager;
import java.awt.Window;
import java.net.URL;
import javax.swing.Icon;

public class MacInfoBox
implements InfoBox {
    private static final Icon DEFAULT_MESSAGE_ICON = ImageResourceManager.getImageIcon("MAC_MESSAGE.png");
    private static final Icon DEFAULT_CONFIRM_ICON = ImageResourceManager.getImageIcon("MAC_CONFIRM.png");
    private static final Icon DEFAULT_HELP_ICON = ImageResourceManager.getImageIcon("MAC_HELP.png");
    private static final Icon DEFAULT_LINK_ICON = ImageResourceManager.getImageIcon("MAC_LINK.png");
    private static final Icon DEFAULT_ACTION_ICON = ImageResourceManager.getImageIcon("MAC_ACTION.png");
    private final transient InfoBoxBuilder builder;

    public MacInfoBox(I18n i18nIn, PreferencesService preferencesService, ActionManager actionManager) {
        this.builder = new InfoBoxBuilder(i18nIn, preferencesService, actionManager);
    }

    public final void showMessageDialog(Window parent, String title, String message, Icon icon, String preferenceKey, boolean preferenceChecked) {
        InfoBoxDialog baseInfoBox = this.builder.buildMessageDialog(parent, title, message, icon, "com.thinkbuzan.i18n.common.ok", preferenceKey, preferenceChecked);
        if (baseInfoBox != null) {
            baseInfoBox.setVisible(true);
        }
    }

    public final void showMessageDialog(Window parent, String title, String message, Icon icon, String preferenceKey) {
        this.showMessageDialog(parent, title, message, icon, preferenceKey, false);
    }

    public final void showMessageDialog(Window parent, String title, String message, String preferenceKey) {
        this.showMessageDialog(parent, title, message, DEFAULT_MESSAGE_ICON, preferenceKey, false);
    }

    public final void showMessageDialog(Window parent, String title, String message, String preferenceKey, boolean preferenceChecked) {
        this.showMessageDialog(parent, title, message, DEFAULT_MESSAGE_ICON, preferenceKey, preferenceChecked);
    }

    public final void showConfirmDialog(Window parent, String title, String message, Icon icon, ConfirmType type, String gaiaAction, String preferenceKey) {
        InfoBoxDialog baseInfoBox = this.builder.buildConfirmDialog(parent, title, message, icon, type, gaiaAction, preferenceKey);
        baseInfoBox.setVisible(true);
    }

    public final void showConfirmDialog(Window parent, String title, String message, ConfirmType type, String gaiaAction, String preferenceKey) {
        this.showConfirmDialog(parent, title, message, DEFAULT_CONFIRM_ICON, type, gaiaAction, preferenceKey);
    }

    public final void showHelpDialog(Window parent, String title, String message, Icon icon, String buttonText, String helpTopic, String preferenceKey) {
        InfoBoxDialog baseInfoBox = this.builder.buildHelpDialog(parent, title, message, icon, buttonText, helpTopic, "com.thinkbuzan.i18n.common.ok", preferenceKey);
        baseInfoBox.setVisible(true);
    }

    public final void showHelpDialog(Window parent, String title, String message, String buttonText, String helpTopic, String preferenceKey) {
        this.showHelpDialog(parent, title, message, DEFAULT_HELP_ICON, buttonText, helpTopic, preferenceKey);
    }

    public final void showLinkDialog(Window parent, String title, String message, Icon icon, String buttonText, URL hyperLink, String preferenceKey, boolean preferenceChecked) {
        InfoBoxDialog baseInfoBox = this.builder.buildLinkDialog(parent, title, message, icon, buttonText, hyperLink, "com.thinkbuzan.i18n.common.ok", preferenceKey, preferenceChecked);
        if (baseInfoBox != null) {
            baseInfoBox.setVisible(true);
        }
    }

    public final void showLinkDialog(Window parent, String title, String message, String buttonText, URL hyperLink, String preferenceKey, boolean preferenceChecked) {
        this.showLinkDialog(parent, title, message, DEFAULT_LINK_ICON, buttonText, hyperLink, preferenceKey, preferenceChecked);
    }

    public final void showLinkDialog(Window parent, String title, String message, Icon icon, String buttonText, URL hyperLink, String preferenceKey) {
        this.showLinkDialog(parent, title, message, icon, buttonText, hyperLink, preferenceKey, false);
    }

    public final void showLinkDialog(Window parent, String title, String message, String buttonText, URL hyperLink, String preferenceKey) {
        this.showLinkDialog(parent, title, message, DEFAULT_LINK_ICON, buttonText, hyperLink, preferenceKey);
    }

    public final void showActionDialog(Window parent, String title, String message, Icon icon, String buttonText, String gaiaAction, String preferenceKey) {
        InfoBoxDialog baseInfoBox = this.builder.buildActionDialog(parent, title, message, icon, buttonText, gaiaAction, "com.thinkbuzan.i18n.common.cancel", preferenceKey);
        baseInfoBox.setVisible(true);
    }

    public final void showActionDialog(Window parent, String title, String message, String buttonText, String gaiaAction, String preferenceKey) {
        this.showActionDialog(parent, title, message, DEFAULT_ACTION_ICON, buttonText, gaiaAction, preferenceKey);
    }

    public final void showWelcomeDialog(Window parent) {
        WelcomeDialog welcome = this.builder.buildWelcomeDialog(parent);
        welcome.setVisible(true);
    }
}

