/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.infobox.osgi;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.preferences.PreferencesService;
import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.internationalization.ITextBundle;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.gaia.infobox.InfoBox;
import com.thinkbuzan.gaia.infobox.InfoBoxFactory;
import com.thinkbuzan.gaia.infobox.impl.linux.LinuxInfoBox;
import com.thinkbuzan.gaia.infobox.impl.mac.MacInfoBox;
import com.thinkbuzan.gaia.infobox.impl.windows.WindowsInfoBox;
import com.thinkbuzan.gaia.infobox.osgi.Services;
import com.thinkbuzan.gaia.infobox2.impl.InfoBoxFactoryImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class OSGiManager
implements BundleActivator {
    private transient ServiceRegistration infoBoxService;
    private transient ServiceRegistration infoBoxFactoryRegistration;
    private transient OSGiService<I18n> i18nService;
    private static final String INFO_BOX_MESSAGES_I18N_FILE = "/i18nproperties/InfoBoxMessages";

    public final void start(BundleContext context) {
        InfoBox infoBox;
        this.i18nService = new OSGiService(context, I18n.class);
        I18n i18n = (I18n)this.i18nService.get();
        ITextBundle bundle = new ITextBundle(){

            public ClassLoader getClassLoader() {
                return this.getClass().getClassLoader();
            }

            public String getPropertyFileBaseName() {
                return OSGiManager.INFO_BOX_MESSAGES_I18N_FILE;
            }
        };
        i18n.register(bundle);
        PreferencesService preferencesService = (PreferencesService)new OSGiService(context, PreferencesService.class).get();
        ActionManager actionManager = (ActionManager)new OSGiService(context, ActionManager.class).get();
        Services services = new Services(i18n, preferencesService, actionManager);
        if (SystemInfo.isWindows()) {
            infoBox = new WindowsInfoBox(i18n, preferencesService, actionManager);
        } else if (SystemInfo.isMacOSX()) {
            infoBox = new MacInfoBox(i18n, preferencesService, actionManager);
        } else if (SystemInfo.isLinux()) {
            infoBox = new LinuxInfoBox(i18n, preferencesService, actionManager);
        } else {
            throw new UnsupportedOperationException("unsupported OS");
        }
        this.infoBoxService = context.registerService(InfoBox.class.getName(), (Object)infoBox, null);
        this.infoBoxFactoryRegistration = context.registerService(InfoBoxFactory.class.getName(), (Object)new InfoBoxFactoryImpl(services), null);
    }

    public final void stop(BundleContext context) {
        this.infoBoxService.unregister();
        this.infoBoxFactoryRegistration.unregister();
        this.i18nService.close();
    }
}

