/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.infobox2.impl;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.preferences.Preferences;
import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.chaos.guiutilities.framepositioning.FramePositioningUtilities;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.gaia.infobox.IInfoBox;
import com.thinkbuzan.gaia.infobox.InfoBoxIcon;
import com.thinkbuzan.gaia.infobox.impl.base.InfoBoxActionListener;
import com.thinkbuzan.gaia.infobox.impl.base.InfoBoxDialog;
import com.thinkbuzan.gaia.infobox.osgi.Services;
import com.thinkbuzan.gaia.infobox.resources.ImageResourceManager;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public abstract class AbstractInfoBox
implements IInfoBox {
    protected static final transient String DEFAULT_CLOSE_BUTTON_TXY = "com.thinkbuzan.i18n.common.ok";
    protected static final transient String DEFAULT_CANCEL_BUTTON_TXY = "com.thinkbuzan.i18n.common.cancel";
    protected static final String DEFAULT_YES_BUTTON_TXY = "com.thinkbuzan.i18n.common.yes";
    protected static final String DEFAULT_NO_BUTTON_TXY = "com.thinkbuzan.i18n.common.no";
    protected static final String DEFAULT_OK_BUTTON_TXY = "com.thinkbuzan.i18n.common.ok";
    public static final Icon WINDOWS_ICON = ImageResourceManager.getImageIcon("Message.png");
    public static final Icon MAC_ICON = ImageResourceManager.getImageIcon("MAC_MESSAGE.png");
    public static final Icon LINUX_ICON = ImageResourceManager.getImageIcon("LINUX_MESSAGE.png");
    public static final Icon WARNING_ICON = ImageResourceManager.getImageIcon("warningicon.png");
    public static final Icon UPGRADE_ICON = ImageResourceManager.getImageIcon("upgradeicon.png");
    public static final Icon OPTION_ICON = ImageResourceManager.getImageIcon("Help.png");
    private final transient Services services;
    private transient Window parent;
    private transient String title = "";
    private transient String message = "";
    private transient String footer = "";
    private transient String preferenceKey;
    private transient Icon icon;
    private transient boolean checkBoxInitiallyChecked;
    private transient String closeButtonText;
    private transient boolean userPrefs;
    private transient boolean hiddenPrefs = true;
    private transient boolean checkBoxUnder;

    public AbstractInfoBox(Services servicesIn) {
        this.services = servicesIn;
        if (SystemInfo.isWindows()) {
            this.setIcon(WINDOWS_ICON);
        } else if (SystemInfo.isAnyMac()) {
            this.setIcon(MAC_ICON);
        } else {
            this.setIcon(LINUX_ICON);
        }
        I18n i18n = this.getServices().getI18n();
        this.closeButtonText = i18n.getLocalizedText("com.thinkbuzan.i18n.common.ok");
    }

    public final void setParent(Window parentIn) {
        this.parent = parentIn;
    }

    public final void setTitle(String text) {
        this.title = text;
    }

    public final void setTitleI18N(String key) {
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("key must not be null or an empty string");
        }
        I18n i18n = this.services.getI18n();
        this.title = i18n.getLocalizedText(key);
    }

    public final void setTitleI18N(String key, Object ... parameters) {
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("key must not be null or an empty string");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        I18n i18n = this.services.getI18n();
        this.title = i18n.getLocalizedText(key, parameters);
    }

    public final void setMessage(String text) {
        this.message = text;
    }

    public final void setMessageI18N(String key) {
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("key must not be null or an empty string");
        }
        I18n i18n = this.services.getI18n();
        this.message = i18n.getLocalizedText(key);
    }

    public final void setMessageI18N(String key, Object ... parameters) {
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("key must not be null or an empty string");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        I18n i18n = this.services.getI18n();
        this.message = i18n.getLocalizedText(key, parameters);
    }

    public final void setFooterMessage(String text) {
        this.footer = text;
    }

    public final void setFooterMessageI18N(String key) {
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("key must not be null or an empty string");
        }
        I18n i18n = this.services.getI18n();
        this.footer = i18n.getLocalizedText(key);
    }

    public final void setFooterMessageI18N(String key, Object ... parameters) {
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("key must not be null or an empty string");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        I18n i18n = this.services.getI18n();
        this.footer = i18n.getLocalizedText(key, parameters);
    }

    public final void setPreferenceKey(String preferenceKeyIn) {
        this.preferenceKey = preferenceKeyIn;
        if (this.preferenceKey != null && this.preferenceKey.trim().equals("")) {
            this.preferenceKey = null;
        }
    }

    public final void setIcon(InfoBoxIcon infoBoxIcon) {
        if (infoBoxIcon == null) {
            throw new IllegalArgumentException("infoBoxIcon must not be null");
        }
        switch (infoBoxIcon) {
            case OPTION: {
                this.setIcon(OPTION_ICON);
                break;
            }
            case UPGRADE: {
                this.setIcon(UPGRADE_ICON);
                break;
            }
            default: {
                this.setIcon(WARNING_ICON);
            }
        }
    }

    public final void setIcon(Icon iconIn) {
        this.icon = iconIn;
    }

    public final void setCheckBoxInitiallyChecked(boolean checkBoxInitiallyCheckedIn) {
        this.checkBoxInitiallyChecked = checkBoxInitiallyCheckedIn;
    }

    public final void setCloseButtonTextI18n(String key) {
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("key must not be null or an empty string");
        }
        I18n i18n = this.services.getI18n();
        this.closeButtonText = i18n.getLocalizedText(key);
    }

    public final void setCloseButtonTextI18n(String key, Object ... parameters) {
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("key must not be null or an empty string");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        I18n i18n = this.services.getI18n();
        this.closeButtonText = i18n.getLocalizedText(key, parameters);
    }

    public final void show() {
        this.show(false);
    }

    public final void show(boolean modal) {
        if (!this.shouldShowDialog()) {
            return;
        }
        InfoBoxDialog dialog = this.createInfoBoxDialog();
        dialog.setModal(modal);
        dialog.setTitle(this.title);
        dialog.setMessage(this.message);
        dialog.setFooterMessage(this.footer);
        dialog.setIcon(this.icon);
        this.addButtons(dialog);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        FramePositioningUtilities.positionDialog((JDialog)dialog);
        dialog.setVisible(true);
    }

    protected abstract void addButtons(InfoBoxDialog var1);

    public final Window getParent() {
        return this.parent;
    }

    public final String getTitle() {
        return this.title;
    }

    public final String getMessage() {
        return this.message;
    }

    public final String getPreferenceKey() {
        return this.preferenceKey;
    }

    public final Icon getIcon() {
        return this.icon;
    }

    public final boolean isCheckBoxInitiallyChecked() {
        return this.checkBoxInitiallyChecked;
    }

    public final String getCloseButtonText() {
        return this.closeButtonText;
    }

    private InfoBoxDialog createInfoBoxDialog() {
        boolean addPreferenceCheckBox;
        I18n i18n = this.services.getI18n();
        boolean bl = addPreferenceCheckBox = this.preferenceKey != null;
        InfoBoxDialog dialog = this.parent instanceof JDialog ? new InfoBoxDialog((JDialog)this.parent, i18n, this.checkBoxInitiallyChecked, addPreferenceCheckBox, this.checkBoxUnder) : (this.parent instanceof JFrame ? new InfoBoxDialog((JFrame)this.parent, i18n, this.checkBoxInitiallyChecked, addPreferenceCheckBox, this.checkBoxUnder) : new InfoBoxDialog((JFrame)null, i18n, this.checkBoxInitiallyChecked, addPreferenceCheckBox, this.checkBoxUnder));
        return dialog;
    }

    private boolean shouldShowDialog() {
        if (this.preferenceKey == null) {
            return true;
        }
        Preferences preferences = this.services.getPreferences(this.userPrefs, this.hiddenPrefs);
        boolean defaultValue = false;
        return !preferences.getBoolean(this.preferenceKey, false);
    }

    protected final void addActionButton(String buttonText, String gaiaAction, InfoBoxDialog infoBox, Object ... actionParameters) {
        if (buttonText == null) {
            throw new IllegalArgumentException("buttonText must not be null");
        }
        if (gaiaAction == null) {
            throw new IllegalArgumentException("gaiaAction must not be null");
        }
        if (infoBox == null) {
            throw new IllegalArgumentException("infoBox must not be null");
        }
        if (actionParameters == null) {
            throw new IllegalArgumentException("actionParameters must not be null");
        }
        ActionManager actionManager = this.services.getActionManager();
        LookAndFeel current = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        JButton actionButton = new JButton(buttonText);
        try {
            UIManager.setLookAndFeel(current);
        }
        catch (Exception ex) {
            // empty catch block
        }
        actionButton.addActionListener(new InfoBoxActionListener(this.services.getPreferences(this.userPrefs, this.hiddenPrefs), actionManager, infoBox, this.preferenceKey, gaiaAction, actionParameters));
        infoBox.addButton(actionButton);
    }

    protected final void addCloseButton(InfoBoxDialog infoBox) {
        if (infoBox == null) {
            throw new IllegalArgumentException("infoBox must not be null");
        }
        LookAndFeel current = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        JButton closeButton = new JButton(this.closeButtonText);
        try {
            UIManager.setLookAndFeel(current);
        }
        catch (Exception ex) {
            // empty catch block
        }
        closeButton.addActionListener(new InfoBoxActionListener(this.services.getPreferences(this.userPrefs, this.hiddenPrefs), infoBox, this.preferenceKey));
        infoBox.addButton(closeButton);
    }

    public final Services getServices() {
        return this.services;
    }

    public final boolean isUseUserPreferences() {
        return this.userPrefs;
    }

    public final void setUseUserPreferences(boolean userPrefsIn) {
        this.userPrefs = userPrefsIn;
    }

    public final boolean isUseHiddenPreferences() {
        return this.hiddenPrefs;
    }

    public final void setUseHiddenPreferences(boolean hiddenPrefsIn) {
        this.hiddenPrefs = hiddenPrefsIn;
    }

    public final void setCheckBoxUnderOptions(boolean under) {
        this.checkBoxUnder = under;
    }
}

