/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.infobox2.impl;

import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.gaia.infobox.ILinkInfoBox;
import com.thinkbuzan.gaia.infobox.impl.base.InfoBoxDialog;
import com.thinkbuzan.gaia.infobox.osgi.Services;
import com.thinkbuzan.gaia.infobox.resources.ImageResourceManager;
import com.thinkbuzan.gaia.infobox2.impl.AbstractInfoBox;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public final class LinkInfoBox
extends AbstractInfoBox
implements ILinkInfoBox {
    public static final Icon WINDOWS_ICON = ImageResourceManager.getImageIcon("MAC_LINK.png");
    public static final Icon MAC_ICON = ImageResourceManager.getImageIcon("MAC_LINK.png");
    public static final Icon LINUX_ICON = ImageResourceManager.getImageIcon("LINUX_LINK.png");
    private static final transient Logger LOGGER = Logger.getLogger(LinkInfoBox.class);
    private transient URL url;
    private transient String buttonText = "";

    public LinkInfoBox(Services services) {
        super(services);
        if (SystemInfo.isWindows()) {
            this.setIcon(WINDOWS_ICON);
        } else if (SystemInfo.isAnyMac()) {
            this.setIcon(MAC_ICON);
        } else {
            this.setIcon(LINUX_ICON);
        }
    }

    public void setURL(URL urlIn) {
        this.url = urlIn;
    }

    public URL getURL() {
        return this.url;
    }

    public void setButtonTextI18N(String key) {
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("key must not be null or an empty string");
        }
        I18n i18n = this.getServices().getI18n();
        this.buttonText = i18n.getLocalizedText(key);
    }

    public String getButtonText() {
        return this.buttonText;
    }

    protected void addButtons(InfoBoxDialog dialog) {
        try {
            if (this.url != null) {
                String actionID = "com.thinkbuzan.gaia.actions.open.OpenURIAction";
                Object[] actionParameters = new Object[]{new URI(this.url.getAuthority() + this.url.getPath())};
                this.addActionButton(this.buttonText, "com.thinkbuzan.gaia.actions.open.OpenURIAction", dialog, actionParameters);
            }
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"Couldn't add action listsner to button!", (Throwable)e);
        }
        this.addCloseButton(dialog);
    }
}

