/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.infobox2.impl;

import com.thinkbuzan.gaia.infobox.IOptionsInfoBox;
import com.thinkbuzan.gaia.infobox.InfoBoxIcon;
import com.thinkbuzan.gaia.infobox.impl.base.InfoBoxActionListener;
import com.thinkbuzan.gaia.infobox.impl.base.InfoBoxDialog;
import com.thinkbuzan.gaia.infobox.osgi.Services;
import com.thinkbuzan.gaia.infobox2.impl.AbstractInfoBox;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public final class OptionsInfoBox
extends AbstractInfoBox
implements IOptionsInfoBox {
    private final transient List<Option> options = new ArrayList<Option>();
    private transient IOptionsInfoBox.IOptionListener listener;
    private transient boolean optionChosen;

    public OptionsInfoBox(Services servicesIn, boolean useIcon) {
        super(servicesIn);
        if (useIcon) {
            this.setIcon(InfoBoxIcon.OPTION);
        } else {
            this.setIcon((Icon)null);
        }
    }

    public void addOption(String optionID, String optionText, ImageIcon icon) {
        this.validateParams(optionID, optionText);
        this.options.add(new Option(optionID, optionText, icon));
    }

    private void validateParams(String optionID, String optionText) {
        if (optionID == null || optionText == null) {
            throw new IllegalArgumentException("invalidArguments to addOption! optionID=" + optionID + ", optionText=" + optionText);
        }
    }

    public void addOptionI18n(String optionID, String i18nKey, ImageIcon icon) {
        this.validateParams(optionID, i18nKey);
        this.addOption(optionID, this.getServices().getI18n().getLocalizedText(i18nKey), icon);
    }

    public void addOptionI18n(String optionID, String i18nKey, ImageIcon icon, Object ... params) {
        this.validateParams(optionID, i18nKey);
        this.addOption(optionID, this.getServices().getI18n().getLocalizedText(i18nKey, params), icon);
    }

    public void setOptionListener(IOptionsInfoBox.IOptionListener listenerIn) {
        this.listener = listenerIn;
    }

    protected void addButtons(InfoBoxDialog dialog) {
        this.optionChosen = false;
        for (Option option : this.options) {
            dialog.addButton(this.createOptionButton(dialog, option));
        }
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                super.windowClosing(evt);
                if (!OptionsInfoBox.this.optionChosen && OptionsInfoBox.this.listener != null) {
                    OptionsInfoBox.this.listener.optionChosen(null);
                }
            }
        });
    }

    private JButton createOptionButton(InfoBoxDialog dialog, Option option) {
        JButton button = new JButton(option.text);
        if (option.icon != null) {
            button.setIcon(option.icon);
            button.setHorizontalTextPosition(0);
            button.setHorizontalAlignment(0);
            button.setVerticalTextPosition(3);
        }
        button.addActionListener(new InfoBoxActionListener(this.getServices().getPreferences(this.isUseUserPreferences(), this.isUseHiddenPreferences()), dialog, this.getPreferenceKey(), this.listener, option.optionID));
        return button;
    }

    private static final class Option {
        private final transient String optionID;
        private final transient String text;
        private final transient Icon icon;

        private Option(String idIn, String textIn, Icon iconIn) {
            this.optionID = idIn;
            this.text = textIn;
            this.icon = iconIn;
        }
    }
}

