/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.border;

import com.explodingpixels.widgets.WindowUtils;
import java.awt.Color;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JComponent;
import javax.swing.border.MatteBorder;

public class FocusStateMatteBorder
extends MatteBorder {
    private final Color fFocusedColor;
    private final Color fUnfocusedColor;
    private final JComponent fComponentToTrackFocusOf;

    public FocusStateMatteBorder(int top, int left, int bottom, int right, Color focusedColor, Color unfocusedColor, JComponent componentToTrackFocusOf) {
        super(top, left, bottom, right, focusedColor);
        this.fFocusedColor = focusedColor;
        this.fUnfocusedColor = unfocusedColor;
        this.fComponentToTrackFocusOf = componentToTrackFocusOf;
        this.updateColor(true);
        WindowUtils.installWeakWindowFocusListener(this.fComponentToTrackFocusOf, this.createWindowFocusListener());
    }

    private void updateColor(boolean focused) {
        this.color = focused ? this.fFocusedColor : this.fUnfocusedColor;
        this.fComponentToTrackFocusOf.repaint();
    }

    private WindowFocusListener createWindowFocusListener() {
        return new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                FocusStateMatteBorder.this.updateColor(true);
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                FocusStateMatteBorder.this.updateColor(false);
            }
        };
    }
}

