/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.audionotes;

import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmICell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.mxgraph.mindmap.util.PropertyUtilities;
import com.mxgraph.mindmap.util.mmUtils;
import com.thinkbuzan.chaos.audiosystem.AudioCodec;
import com.thinkbuzan.chaos.audiosystem.AudioFactory;
import com.thinkbuzan.chaos.audiosystem.IAudioTools;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.entities.AudioNote;
import com.thinkbuzan.gaia.export.BasicExportPanel;
import com.thinkbuzan.gaia.export.Category;
import com.thinkbuzan.gaia.export.IExporter;
import com.thinkbuzan.gaia.export.IExporterListener;
import com.thinkbuzan.gaia.export.IFileType;
import com.thinkbuzan.gaia.export.audionotes.AudioNotesFileType;
import com.thinkbuzan.gaia.export.audionotes.i18n.AudioNotesExporterI18N;
import com.thinkbuzan.gaia.export.audionotes.license.IBundleLicenser;
import com.thinkbuzan.gaia.export.audionotes.osgi.OSGIManager;
import com.thinkbuzan.gaia.export.audionotes.resources.ResourcesManager;
import com.thinkbuzan.gaia.export.unlicensed.TrialExporterPanel;
import com.thinkbuzan.gaia.export.unlicensed.UnlicensedExporterPanel;
import com.thinkbuzan.gaia.mapstorage.IMMFileType;
import com.thinkbuzan.gaia.mapstorage.MapStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioNotesExporter
implements IExporter {
    private static final Logger LOG = Logger.getLogger(AudioNotesExporter.class);
    private final transient List<AudioNote> audioList = new ArrayList<AudioNote>();
    private final transient Map<String, Integer> descriptionMap = new HashMap<String, Integer>();
    private static Icon icon;
    private transient IExporterListener audioExporterListener;
    private transient IEditorComponent editorComponent;
    private transient BasicExportPanel audioNotesComponent;
    private transient File exportFile;
    private final IBundleLicenser licenser;
    private final transient IAudioTools audioTools;

    public AudioNotesExporter(IBundleLicenser licenserIn) {
        this.licenser = licenserIn;
        AudioFactory audioFactory = OSGIManager.getAudioFactory();
        if (audioFactory == null) {
            LOG.error((Object)"Did not expect AudioFactory to be null");
            this.audioTools = null;
        } else {
            this.audioTools = audioFactory.createAudioTools();
        }
    }

    public final void export(IEditorComponent editorComponentIn, File file, IExporterListener exporterListener) {
        this.validateExport(editorComponentIn, file, exporterListener);
        this.editorComponent = editorComponentIn;
        this.audioExporterListener = exporterListener;
        this.exportFile = file;
        List floatingIdeaCells = this.editorComponent.getFloatingIdeas();
        ArrayList<mmIStructureCell> cells = new ArrayList<mmIStructureCell>();
        mmUtils.sortByOrder(cells);
        for (mmFloatingIdeaCell fic : floatingIdeaCells) {
            cells.add((mmIStructureCell)fic);
        }
        this.processAudioNote(cells);
        for (mmFloatingIdeaCell fic : this.editorComponent.getFlowchartCells()) {
            this.checkForAudioNote((mmICell)fic);
        }
        this.processSameDescription();
        this.processAudioFile();
        this.editorComponent = null;
    }

    public final void export(IEditorComponent editorComponentIn, File outputFile, IExporterListener exporterListener, Object ... objects) {
        this.export(editorComponentIn, outputFile, exporterListener);
    }

    private void processAudioFile() {
        float step = 0.0f;
        for (AudioNote audioNote : this.audioList) {
            String description = audioNote.getDescription();
            this.descriptionMap.put(description, this.descriptionMap.get(description) - 1);
            this.copyAudioFileToLocale(audioNote);
            float decade = 10.0f;
            float currentProgressor = (step += 1.0f) / (float)this.audioList.size();
            currentProgressor = Math.round(currentProgressor * 10.0f);
            this.audioExporterListener.exportProgress(currentProgressor /= 10.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAudioFileToLocale(AudioNote audioNote) {
        MapStorage mapStorage = this.editorComponent.getMapStorage();
        InputStream inputStream = mapStorage.read(audioNote.getUid() + ".wav", IMMFileType.DATA);
        if (inputStream == null) {
            LOG.error((Object)"Did not expect inputStream to be null");
            return;
        }
        if ("WAV".equals(audioNote.getCodec())) {
            this.copyAudioFileToLocale(audioNote, inputStream);
        } else if ("GSM".equals(audioNote.getCodec())) {
            if (this.audioTools == null) {
                LOG.error((Object)"Could not transcode GSM to WAV because audioTools is null");
                return;
            }
            File wavFile = null;
            FileInputStream wavInput = null;
            try {
                wavFile = this.transcodeToWavFile(inputStream, AudioCodec.GSM);
                if (wavFile == null) {
                    LOG.error((Object)"Did not expect wavFile to be null");
                } else {
                    wavInput = new FileInputStream(wavFile);
                    this.copyAudioFileToLocale(audioNote, wavInput);
                }
            }
            catch (Exception exception) {
                LOG.error((Object)"Could not transcode GSM to WAV", (Throwable)exception);
            }
            finally {
                boolean returnValue;
                if (wavFile != null && !(returnValue = wavFile.delete())) {
                    LOG.error((Object)("Could not delete " + wavFile));
                }
                if (wavInput != null) {
                    try {
                        wavInput.close();
                    }
                    catch (IOException exception) {
                        LOG.error((Object)"Could not close wavInput", (Throwable)exception);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File transcodeToWavFile(InputStream inputStream, AudioCodec audioCodec) throws Exception {
        File temporaryFile = null;
        File wavTemporaryFile = null;
        try {
            temporaryFile = this.writeInputStreamToTemporaryFile(inputStream);
            if (temporaryFile == null) {
                LOG.error((Object)"Did not expect temporaryFile to be null");
            } else {
                wavTemporaryFile = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
                this.audioTools.transcode(temporaryFile, audioCodec, wavTemporaryFile, AudioCodec.WAV);
            }
        }
        finally {
            boolean returnValue;
            if (temporaryFile != null && !(returnValue = temporaryFile.delete())) {
                LOG.error((Object)("Could not delete " + temporaryFile));
            }
        }
        return wavTemporaryFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeInputStreamToTemporaryFile(InputStream inputStream) throws Exception {
        File temporaryFile = null;
        FileOutputStream output = null;
        try {
            int bytesRead;
            temporaryFile = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
            output = new FileOutputStream(temporaryFile);
            int bufferSize = 8192;
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
            output.close();
            inputStream.close();
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException exception) {
                    LOG.error((Object)"Could not close output", (Throwable)exception);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException exception) {
                    LOG.error((Object)"Could not close inputStream", (Throwable)exception);
                }
            }
        }
        return temporaryFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAudioFileToLocale(AudioNote audioNote, InputStream inputStream) {
        String audioNotesExpDirPath = this.exportFile.getAbsolutePath();
        File audioNotesExpDir = new File(audioNotesExpDirPath);
        try {
            if (!audioNotesExpDir.exists() && !audioNotesExpDir.mkdir()) {
                LOG.error((Object)("Export directory \"" + audioNotesExpDirPath + "\"for the audio notes is not created "));
            }
            File audioFile = new File(audioNotesExpDirPath + File.separator + audioNote.getDescription() + ".wav");
            FileOutputStream outputStream = null;
            try {
                if (!audioFile.createNewFile()) {
                    LOG.error((Object)("Audio file \"" + audioFile.getAbsolutePath() + "\" is not created in the export directory."));
                }
                outputStream = new FileOutputStream(audioFile);
                int bufferSize = 1024;
                byte[] buf = new byte[1024];
                int len = inputStream.read(buf);
                while (len > 0) {
                    ((OutputStream)outputStream).write(buf, 0, len);
                    len = inputStream.read(buf);
                }
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)"FileNotException occured while copying the audio file to locale", (Throwable)e);
            }
            catch (IOException e1) {
                LOG.error((Object)"IOException occured while copying the audio file to locale", (Throwable)e1);
            }
            finally {
                inputStream.close();
                if (outputStream != null) {
                    ((OutputStream)outputStream).close();
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)"IOException occured while copying the audio file to locale", (Throwable)e);
        }
    }

    private void processSameDescription() {
        for (AudioNote audioNote : this.audioList) {
            String description = audioNote.getDescription();
            if (this.descriptionMap.containsKey(description)) {
                this.descriptionMap.put(description, this.descriptionMap.get(description) + 1);
                continue;
            }
            this.descriptionMap.put(description, 1);
        }
    }

    private void processAudioNote(List<mmIStructureCell> cells) {
        for (int i = 0; i < cells.size(); ++i) {
            this.checkForAudioNote((mmICell)cells.get(i));
            List mainBranches = mmUtils.getSortedChildBranches((mmIStructureCell)cells.get(i));
            if (mainBranches == null || mainBranches.isEmpty()) continue;
            ArrayList<mmIStructureCell> childList = new ArrayList<mmIStructureCell>();
            for (mmBranchCell childCell : mainBranches) {
                childList.add((mmIStructureCell)childCell);
            }
            this.processAudioNote(childList);
        }
    }

    private void checkForAudioNote(mmICell cell) {
        List audioNote = PropertyUtilities.getPropertyList((mmICell)cell, (String)"com.thinkbuzan.gaia.cell.audionotes2", AudioNote.class);
        if (audioNote != null && !audioNote.isEmpty()) {
            this.audioList.addAll(audioNote);
        }
    }

    private void validateExport(IEditorComponent editorComponentIn, File file, IExporterListener exporterListener) {
        if (editorComponentIn == null) {
            throw new IllegalArgumentException("IEditorComponent can not be null.");
        }
        if (file == null) {
            throw new IllegalArgumentException("Output File can not be null.");
        }
        if (exporterListener == null) {
            throw new IllegalArgumentException("Exporter listener can not be null.");
        }
    }

    public final JComponent getComponent() {
        switch (this.getLicenseState()) {
            case full: {
                if (this.audioNotesComponent == null) {
                    this.audioNotesComponent = new BasicExportPanel(AudioNotesExporterI18N.getLocalizedText("com.thinkbuzan.i18n.audioNotesexporter.component.text"), false);
                }
                return this.audioNotesComponent;
            }
            case trial: {
                return TrialExporterPanel.getInstance((I18n)AudioNotesExporterI18N.getI18n());
            }
        }
        return UnlicensedExporterPanel.getInstance((I18n)AudioNotesExporterI18N.getI18n());
    }

    public final Icon getIcon() {
        if (icon == null) {
            icon = ResourcesManager.getImageIcon("export.png");
        }
        return icon;
    }

    public final String getId() {
        return AudioNotesExporter.class.getPackage().getName();
    }

    public final String getName() {
        return AudioNotesExporterI18N.getLocalizedText("com.thinkbuzan.i18n.common.audioNotes");
    }

    public final IFileType getOutputFileType() {
        return new AudioNotesFileType();
    }

    public final Category.CategoryId getCategoryId() {
        return Category.CategoryId.AUDIO;
    }

    public final IExporter.LicenseState getLicenseState() {
        return this.licenser.getAudioNotesExporterState();
    }
}

