/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.audionotes.osgi;

import com.thinkbuzan.chaos.audiosystem.AudioFactory;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.internationalization.ITextBundle;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.chaos.utilities.edtutilities.EDTUtilities;
import com.thinkbuzan.gaia.export.ExportManager;
import com.thinkbuzan.gaia.export.IExporter;
import com.thinkbuzan.gaia.export.audionotes.AudioNotesExporter;
import com.thinkbuzan.gaia.export.audionotes.i18n.AudioNotesExporterI18N;
import com.thinkbuzan.gaia.export.audionotes.license.BundleLicenser;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public final class OSGIManager
implements BundleActivator {
    protected static final String BASE_NAME_OF_MESSAGES_FILE = "/i18nproperties/AudioNotesExporterMessages";
    private static transient AudioFactory audioFactory;

    public void start(final BundleContext context) {
        final BundleLicenser licenser = new BundleLicenser(context);
        OSGiService audioFactoryService = new OSGiService(context, AudioFactory.class);
        audioFactory = (AudioFactory)audioFactoryService.get();
        audioFactoryService.close();
        final ITextBundle bundle = this.getTextBundle();
        EDTUtilities.runOnEDT((Runnable)new Runnable(){

            public void run() {
                OSGiService service = new OSGiService(context, I18n.class);
                I18n i18n = (I18n)service.get();
                i18n.register(bundle);
                AudioNotesExporterI18N.setI18n(i18n);
                OSGiService exportManager = new OSGiService(context, ExportManager.class);
                ((ExportManager)exportManager.get()).register((IExporter)new AudioNotesExporter(licenser));
                exportManager.close();
            }
        });
    }

    public static AudioFactory getAudioFactory() {
        return audioFactory;
    }

    private ITextBundle getTextBundle() {
        ITextBundle bundle = new ITextBundle(){

            public ClassLoader getClassLoader() {
                return OSGIManager.class.getClassLoader();
            }

            public String getPropertyFileBaseName() {
                return OSGIManager.BASE_NAME_OF_MESSAGES_FILE;
            }
        };
        return bundle;
    }

    public final void stop(BundleContext context) {
    }
}

