/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.audionotes.resources;

import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public final class ResourcesManager {
    public static final String ICON_NAME = "export.png";
    private static final Logger LOG = Logger.getLogger(ResourcesManager.class);

    private ResourcesManager() {
    }

    public static ImageIcon getImageIcon(String imageFileName) {
        ResourcesManager.validateGetImageIcon(imageFileName);
        try {
            InputStream inputStream = ResourcesManager.class.getResourceAsStream(imageFileName);
            return new ImageIcon(ImageIO.read(inputStream));
        }
        catch (IOException e) {
            return null;
        }
    }

    private static void validateGetImageIcon(String iamgeFileName) {
        if (null == iamgeFileName || iamgeFileName.length() == 0) {
            throw new IllegalArgumentException("image file name can't be null or empty");
        }
        InputStream inputStream = ResourcesManager.class.getResourceAsStream(iamgeFileName);
        if (null == inputStream) {
            throw new IllegalArgumentException("image file doesn't exsit.");
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            LOG.error((Object)"IOException occured while copying the audio file to locale", (Throwable)e);
        }
    }
}

