/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.launcherservice.actions;

import com.buzanonline.chaos.action.AbstractAction;
import com.buzanonline.chaos.systemstate.ISystemState;
import com.thinkbuzan.chaos.launcherservice.LauncherService;
import java.net.URI;
import org.apache.log4j.Logger;

public final class OpenURIAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(OpenURIAction.class);
    private static final String ACTION_ID = "com.thinkbuzan.gaia.actions.open.OpenURIAction";
    private final transient LauncherService launcher;

    public OpenURIAction(LauncherService launcherIn) {
        this.launcher = launcherIn;
    }

    public String getId() {
        return ACTION_ID;
    }

    public void runAction(Object ... parameters) {
        this.validateRunActionWebURIs(parameters);
        URI[] uris = new URI[parameters.length];
        System.arraycopy(parameters, 0, uris, 0, parameters.length);
        this.openURIUsingLauncherService(uris);
    }

    private void validateRunActionWebURIs(Object ... parameters) {
        if (null == parameters) {
            throw new IllegalArgumentException("Parameters are null.");
        }
        for (Object obj : parameters) {
            if (obj instanceof URI) continue;
            throw new IllegalArgumentException("Only URI can be opened in Open URI Actions.");
        }
    }

    private void openURIUsingLauncherService(URI[] uris) {
        for (URI uri : uris) {
            LOG.debug((Object)("Opening URI: " + uri.toString()));
            this.launcher.launchWeb(uri);
        }
    }

    public void systemStateChanged(ISystemState systemState) {
    }
}

