/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.launcherservice.impl;

import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.chaos.launcherservice.LauncherService;
import com.thinkbuzan.chaos.launcherservice.osgi.I18nService;
import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.exceptionhandler.BrowserLauncherErrorHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class LauncherServiceImpl
implements LauncherService {
    private static final Logger LOG = Logger.getLogger(LauncherServiceImpl.class);
    private static final String DEFAULT_EMAIL_SCHEME = "mailto:";
    private static final String DEFAULT_WEB_SCHEME = "http://";
    private static final boolean IS_MAC = SystemInfo.isAnyMac();
    private static final boolean IS_LINUX = SystemInfo.isLinux();
    private static final boolean IS_DESKTOP_SUPPORTED = LauncherServiceImpl.isDesktopSupported();

    public final boolean launchFile(File file) {
        this.validateLaunch(file);
        if (IS_DESKTOP_SUPPORTED) {
            return this.openFileWithJavaDesktop(file);
        }
        if (IS_MAC) {
            return this.openFileWithMacRuntime(file);
        }
        if (IS_LINUX) {
            return this.openFileWithLinuxRuntime(file);
        }
        throw new UnsupportedOperationException("Launcher service requires JDK 1.6 or above with Desktop supported unless running on Mac");
    }

    private void validateLaunch(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file can't be null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("file doesn't exist");
        }
    }

    private static boolean isDesktopSupported() {
        try {
            Class<?> desktopClazz = Class.forName("java.awt.Desktop");
            Method isDesktopSupportedMethod = desktopClazz.getMethod("isDesktopSupported", new Class[0]);
            Object result = isDesktopSupportedMethod.invoke(desktopClazz, new Object[0]);
            boolean desktopClassSupported = (Boolean)result;
            if (desktopClassSupported) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)e);
        }
        catch (SecurityException e) {
            LOG.error((Object)e);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)e);
        }
        return false;
    }

    private boolean openFileWithJavaDesktop(File file) {
        file = this.getCanonicalFile(file);
        try {
            Class<?> desktopClazz = Class.forName("java.awt.Desktop");
            Method getDesktopMethod = desktopClazz.getMethod("getDesktop", new Class[0]);
            Object desktop = getDesktopMethod.invoke(desktopClazz, new Object[0]);
            Method openMethod = desktopClazz.getMethod("open", File.class);
            openMethod.invoke(desktop, file);
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)e);
        }
        catch (SecurityException e) {
            LOG.error((Object)e);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)"do not support open operation", (Throwable)e);
        }
        return this.openFile(file);
    }

    private boolean openFile(File file) {
        file = this.getCanonicalFile(file);
        try {
            Runtime.getRuntime().exec("rundll32 SHELL32.DLL,ShellExec_RunDLL " + file);
        }
        catch (IOException e) {
            LOG.error((Object)e);
            return false;
        }
        return true;
    }

    private boolean openFileWithMacRuntime(File file) {
        file = this.getCanonicalFile(file);
        try {
            String line;
            String[] command = new String[]{"open", file.getAbsolutePath()};
            Process process = Runtime.getRuntime().exec(command);
            process.waitFor();
            process.exitValue();
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            BufferedReader outputReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = errorReader.readLine()) != null) {
                LOG.error((Object)(Arrays.asList(command) + " : " + line));
            }
            while ((line = outputReader.readLine()) != null) {
                LOG.error((Object)(Arrays.asList(command) + " : " + line));
            }
            return true;
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
        catch (InterruptedException e) {
            LOG.error((Object)e);
        }
        return false;
    }

    private boolean openFileWithLinuxRuntime(File file) {
        file = this.getCanonicalFile(file);
        try {
            Process process = Runtime.getRuntime().exec("gnome-open " + file.getAbsolutePath());
            process.waitFor();
            process.exitValue();
            return true;
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
        catch (InterruptedException e) {
            LOG.error((Object)e);
        }
        return false;
    }

    public final boolean launchWeb(URI uri) {
        this.validateLaunchWeb(uri);
        URI webAddress = uri;
        if (webAddress.getScheme() == null) {
            try {
                webAddress = new URI(DEFAULT_WEB_SCHEME + webAddress);
            }
            catch (URISyntaxException ex) {
                LOG.error((Object)("Could not set the protocol for the email address " + webAddress), (Throwable)ex);
            }
        }
        return this.launchLink(webAddress.toString());
    }

    private void validateLaunchWeb(URI url) {
        if (null == url) {
            throw new IllegalArgumentException("url can't be null.");
        }
    }

    public final boolean launchEmail(URI uri) {
        return this.launchEmail(uri, null);
    }

    public final boolean launchEmail(URI uri, String subjectIn) {
        this.validateLaunchEmail(uri);
        URI emailAddress = uri;
        if (emailAddress.getScheme() == null) {
            try {
                emailAddress = new URI(DEFAULT_EMAIL_SCHEME + emailAddress);
            }
            catch (URISyntaxException ex) {
                LOG.error((Object)("Could not set the protocol for the email address " + emailAddress), (Throwable)ex);
            }
        }
        StringBuffer protocolBuf = new StringBuffer(emailAddress.toString());
        int atIndex = protocolBuf.indexOf("?");
        String subject = "";
        if (subjectIn != null) {
            subject = subjectIn.trim();
        }
        if (atIndex != -1 && subject.length() > 0) {
            protocolBuf.delete(atIndex, protocolBuf.length());
        }
        subject = subject.replaceAll(" ", "%20");
        protocolBuf.append("?subject=");
        protocolBuf.append(subject);
        return this.launchLink(protocolBuf.toString());
    }

    private void validateLaunchEmail(URI uri) {
        if (null == uri) {
            throw new IllegalArgumentException("url can't be null.");
        }
        if (uri.getScheme() != null && !"mailto".equals(uri.getScheme())) {
            throw new IllegalArgumentException("Invalid protocol " + uri.getScheme());
        }
    }

    private boolean launchLink(String webAddress) {
        try {
            if (IS_MAC) {
                try {
                    Class<?> macClass = Class.forName("com.apple.eio.FileManager");
                    Method openURL = macClass.getDeclaredMethod("openURL", String.class);
                    openURL.invoke(null, webAddress);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                    this.displayErrorMessage();
                    return false;
                }
            } else {
                BrowserLauncher launcher = new BrowserLauncher(null, (BrowserLauncherErrorHandler)new CustomBrowserLauncherErrorHandler());
                launcher.openURLinBrowser(webAddress);
            }
            return true;
        }
        catch (BrowserLaunchingInitializingException e) {
            LOG.error((Object)e);
        }
        catch (UnsupportedOperatingSystemException e) {
            LOG.error((Object)e);
        }
        this.displayErrorMessage();
        return false;
    }

    private File getCanonicalFile(File file) {
        block2: {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException exception) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)"Could not get canonical file", (Throwable)exception);
            }
        }
        return file;
    }

    private void displayErrorMessage() {
        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), I18nService.getI18n().getLocalizedText("com.thinkbuzan.i18n.launcherservice.errorlaunchinglink.message"), I18nService.getI18n().getLocalizedText("Error Launching Link"), 0);
    }

    private static class CustomBrowserLauncherErrorHandler
    implements BrowserLauncherErrorHandler {
        private CustomBrowserLauncherErrorHandler() {
        }

        public void handleException(Exception exc) {
            LOG.error((Object)"Couldn't launch link ", (Throwable)exc);
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), I18nService.getI18n().getLocalizedText("com.thinkbuzan.i18n.launcherservice.errorlaunchinglink.message"), I18nService.getI18n().getLocalizedText("com.thinkbuzan.i18n.launcherservice.errorlaunchinglink.title"), 0);
        }
    }
}

