/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.launcherservice.osgi;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.action.IAction;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.internationalization.ITextBundle;
import com.thinkbuzan.chaos.launcherservice.LauncherService;
import com.thinkbuzan.chaos.launcherservice.actions.OpenURIAction;
import com.thinkbuzan.chaos.launcherservice.impl.LauncherServiceImpl;
import com.thinkbuzan.chaos.launcherservice.osgi.I18nService;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class OSGiManager
implements BundleActivator {
    private transient ServiceRegistration registration;
    private static final String PROPERTIES_BASE_NAME = "i18nproperties/LauncherServiceMessages";

    public final void start(BundleContext context) {
        this.registerI18n(context);
        LauncherServiceImpl launcherService = new LauncherServiceImpl();
        OSGiService actionManager = new OSGiService(context, ActionManager.class);
        ((ActionManager)actionManager.get()).addAction((IAction)new OpenURIAction(launcherService));
        this.registration = context.registerService(LauncherService.class.getName(), (Object)launcherService, null);
    }

    private void registerI18n(BundleContext context) {
        OSGiService i18nService = new OSGiService(context, I18n.class);
        I18n i18n = (I18n)i18nService.get();
        i18n.register(new ITextBundle(){

            public ClassLoader getClassLoader() {
                return this.getClass().getClassLoader();
            }

            public String getPropertyFileBaseName() {
                return OSGiManager.PROPERTIES_BASE_NAME;
            }
        });
        I18nService.setI18n(i18n);
        i18nService.close();
    }

    public final void stop(BundleContext context) {
        this.registration.unregister();
    }
}

