/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.formatpanel.ui;

import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmFloatingTextCell;
import com.mxgraph.mindmap.model.mmFlowCell;
import com.mxgraph.mindmap.model.mmFlowConnectorCell;
import com.mxgraph.mindmap.model.mmRelationshipCell;
import com.thinkbuzan.apollo.ui.core.mac.YosemitePagedPanel;
import com.thinkbuzan.apollo.ui.core.win.component.LionScrollBarUI;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.dozer.sidepanels.formatpanel.osgi.ServiceManager;
import com.thinkbuzan.dozer.sidepanels.formatpanel.resources.ResourceManager;
import com.thinkbuzan.dozer.sidepanels.formatpanel.ui.BrainstormFormatSidePanel;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actionsupport.ViewTypeSupport;
import com.thinkbuzan.gaia.editor.listeners.EditorListener;
import com.thinkbuzan.gaia.ui.sidepanels.ISidePanel;
import com.thinkbuzan.pascal.services.editor.SketchModeListener;
import com.thinkbuzan.pascal.services.editor.listeners.SelectionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ScrollBarUI;

public abstract class AbstractFormatSidePanel
extends JPanel
implements ISidePanel,
SelectionListener,
SketchModeListener {
    private static final long serialVersionUID = 1L;
    private static final String FORMAT_PANEL_ID = "com.thinkbuzan.dozer.sidepanels.format";
    protected static final int PANEL_PREF_HEIGHT = 330;
    private static final String FONT_TITLE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.font");
    private static final String BRANCH_TITLE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.branch");
    private static final String CONVERT_TITLE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.convert");
    private static final String BRANCH_ART_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.branchArt");
    private static final String COLOURS_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.color");
    private static final Color BACKGROUND_COLOUR = Color.decode("#f7f7f7");
    protected static final Color PANEL_BORDER_COLOUR = Color.decode("#cfcfcf");
    protected static final int SUBTITLE_FONT_STYLE = 1;
    protected static final float SUBTITLE_FONT_SIZE = 12.0f;
    protected static final Color SUBTITLE_FONT_COLOUR = Color.decode("#444057");
    protected static final int SUBTITLE_PADDING = 10;
    private static final int NUMBER_BRANCH_ART_ITEMS_PER_PAGE = 6;
    private static final Color PANEL_BACKGROUND_COLOUR = Color.decode("#f7f7f7");
    private JPanel branchArtHolder;
    protected JPanel contentHolder;
    protected JPanel emptyContentHolder;
    private JPanel allContentHolder;
    private BrainstormFormatSidePanel brainstormFormatPanel;

    public AbstractFormatSidePanel() {
        this.setOpaque(true);
        this.setBackground(BACKGROUND_COLOUR);
        this.setLayout(new BorderLayout());
        this.contentHolder = new JPanel();
        this.contentHolder.setOpaque(false);
        this.contentHolder.setLayout(new BoxLayout(this.contentHolder, 1));
        this.contentHolder.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.allContentHolder = new JPanel();
        this.allContentHolder.setOpaque(false);
        this.allContentHolder.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.contentHolder);
        JPanel jPanel3 = new JPanel();
        jPanel3.setOpaque(false);
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.getVerticalScrollBar().setUI((ScrollBarUI)new LionScrollBarUI(jScrollPane.getVerticalScrollBar()));
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        this.allContentHolder = new JPanel();
        this.allContentHolder.setBackground(PANEL_BACKGROUND_COLOUR);
        this.allContentHolder.setLayout(new BorderLayout());
        this.allContentHolder.add((Component)jScrollPane, "Center");
        this.add((Component)this.allContentHolder, "Center");
        this.branchArtHolder = new JPanel();
        this.branchArtHolder.setOpaque(false);
        this.branchArtHolder.setLayout(new BoxLayout(this.branchArtHolder, 0));
        ServiceManager.getEditorManager().addEditorListener(new EditorListener(){

            public void editorChanged(IEditorComponent iEditorComponent) {
                if (iEditorComponent != null) {
                    iEditorComponent.removeSelectionListener((SelectionListener)AbstractFormatSidePanel.this);
                    iEditorComponent.addSelectionListener((SelectionListener)AbstractFormatSidePanel.this);
                    iEditorComponent.removeSketchModeListener((SketchModeListener)AbstractFormatSidePanel.this);
                    iEditorComponent.addSketchModeListener((SketchModeListener)AbstractFormatSidePanel.this);
                    AbstractFormatSidePanel.this.refresh();
                }
            }
        });
    }

    public final void refresh() {
        try {
            IEditorComponent iEditorComponent = ServiceManager.getEditorManager().getCurrentEditorComponent();
            if (iEditorComponent != null && iEditorComponent.getGraphComponent() != null && iEditorComponent.getGraphComponent().getGraph() != null) {
                this.selectionChanged(iEditorComponent.getGraphComponent().getGraph().getSelectionCells());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract JComponent getComponent();

    public abstract Dimension getPreferredSize();

    public String getID() {
        return FORMAT_PANEL_ID;
    }

    public JComponent getComponent(String string) {
        return null;
    }

    public Icon getIcon() {
        return ResourceManager.createImageIcon("icon.png");
    }

    public String getLabel() {
        return ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.format");
    }

    public boolean supportsView(String string) {
        boolean bl = ViewTypeSupport.MIND_MAP_VIEW_ID.equalsIgnoreCase(string) ? true : (ViewTypeSupport.PROJECT_MANAGEMENT_VIEW_ID.equalsIgnoreCase(string) ? true : (ViewTypeSupport.TD_VIEW_ID.equalsIgnoreCase(string) ? true : (ViewTypeSupport.BRAINSTORM_VIEW.equalsIgnoreCase(string) ? true : (ViewTypeSupport.FAST_CAPTURE_VIEW.equalsIgnoreCase(string) ? true : ViewTypeSupport.TIMELINE_VIEW.equalsIgnoreCase(string)))));
        return bl;
    }

    public void selectionChanged(final Object ... objectArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ServiceManager.getEditorManager() == null || ServiceManager.getEditorManager().getAllEditorComponents().isEmpty()) {
                    return;
                }
                AbstractFormatSidePanel.this.resetBranchArtPanel();
                AbstractFormatSidePanel.this.contentHolder.removeAll();
                boolean bl = false;
                String string = ServiceManager.getEditorManager().getCurrentEditorComponent().getView().getId();
                if (ViewTypeSupport.BRAINSTORM_VIEW.equalsIgnoreCase(string)) {
                    AbstractFormatSidePanel.this.setupBrainstormFormatPanel(objectArray);
                    bl = true;
                } else if (AbstractFormatSidePanel.this.isSketchInProgress()) {
                    AbstractFormatSidePanel.this.setupSketchPanel();
                    bl = true;
                } else if (objectArray != null && objectArray.length > 0) {
                    boolean bl2;
                    boolean bl3 = bl2 = ViewTypeSupport.MIND_MAP_VIEW_ID.equalsIgnoreCase(string) || ViewTypeSupport.TD_VIEW_ID.equalsIgnoreCase(string) || ViewTypeSupport.PROJECT_MANAGEMENT_VIEW_ID.equalsIgnoreCase(string);
                    if (bl2 && AbstractFormatSidePanel.this.isSelectionValidForBranchArtPanel(objectArray)) {
                        AbstractFormatSidePanel.this.setupBranchArtPanel();
                        bl = true;
                    }
                    if (bl2 && AbstractFormatSidePanel.this.isSelectionValidForFont(objectArray)) {
                        AbstractFormatSidePanel.this.setupFontPanel();
                        bl = true;
                    }
                    if (bl2 && AbstractFormatSidePanel.this.isSelectionValidForBranch(objectArray)) {
                        AbstractFormatSidePanel.this.setupBranchPanel();
                        bl = true;
                    }
                    if (AbstractFormatSidePanel.this.isSelectionValidForColours(objectArray)) {
                        AbstractFormatSidePanel.this.setupColoursPanel();
                        bl = true;
                    }
                    if (bl2 && AbstractFormatSidePanel.this.isSelectionValidForArrow(objectArray)) {
                        AbstractFormatSidePanel.this.setupArrowPanel();
                        bl = true;
                    }
                    if (bl2 && AbstractFormatSidePanel.this.isSelectionValidForConvert(objectArray)) {
                        AbstractFormatSidePanel.this.setupConvertPanel();
                        bl = true;
                    }
                }
                if (bl) {
                    AbstractFormatSidePanel.this.removeAll();
                    AbstractFormatSidePanel.this.add(AbstractFormatSidePanel.this.allContentHolder);
                } else {
                    AbstractFormatSidePanel.this.removeAll();
                    AbstractFormatSidePanel.this.add(AbstractFormatSidePanel.this.emptyContentHolder);
                }
                AbstractFormatSidePanel.this.revalidate();
                AbstractFormatSidePanel.this.repaint();
            }
        });
    }

    private final void resetBranchArtPanel() {
        this.branchArtHolder.removeAll();
    }

    private final boolean isSketchInProgress() {
        try {
            if (ServiceManager.getEditorManager() != null && ServiceManager.getEditorManager().getCurrentEditorComponent() != null && ServiceManager.getEditorManager().getCurrentEditorComponent().isInSketchMode()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected abstract void setupSketchPanel();

    private final void setupBrainstormFormatPanel(Object ... objectArray) {
        if (this.brainstormFormatPanel == null) {
            this.brainstormFormatPanel = new BrainstormFormatSidePanel();
        }
        this.contentHolder.add(this.brainstormFormatPanel);
        this.brainstormFormatPanel.updateSelection(objectArray);
    }

    private final boolean isSelectionValidForBranchArtPanel(Object ... objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            boolean bl = true;
            for (Object object : objectArray) {
                if (object instanceof mmBranchCell) continue;
                bl = false;
                break;
            }
            return bl;
        }
        return false;
    }

    private final void setupBranchArtPanel() {
        JPanel jPanel;
        ArrayList arrayList = new ArrayList();
        ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.SetupBranchArtPagesAction", new Object[]{arrayList});
        ArrayList<JPanel> arrayList2 = new ArrayList<JPanel>();
        JPanel jPanel2 = this.getBranchArtBasePanel();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i != 0 && i % 6 == 0) {
                if (i != arrayList.size() - 1) {
                    arrayList2.add(jPanel2);
                }
                jPanel2 = this.getBranchArtBasePanel();
            }
            jPanel = new JPanel();
            jPanel.setOpaque(false);
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add((Component)arrayList.get(i));
            jPanel.setMinimumSize(new Dimension(75, 75));
            jPanel.setMaximumSize(new Dimension(75, 75));
            jPanel.setPreferredSize(new Dimension(75, 75));
            jPanel2.add(jPanel);
        }
        arrayList2.add(jPanel2);
        YosemitePagedPanel yosemitePagedPanel = new YosemitePagedPanel(BRANCH_ART_TEXT, arrayList2);
        jPanel = new JPanel();
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.WHITE);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add((Component)yosemitePagedPanel);
        this.branchArtHolder.add(jPanel);
        this.contentHolder.add(this.branchArtHolder);
        this.revalidate();
        this.repaint();
    }

    private final JPanel getBranchArtBasePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new GridLayout(2, 3));
        jPanel.setMinimumSize(new Dimension(jPanel.getMinimumSize().width, 200));
        jPanel.setMaximumSize(new Dimension(jPanel.getMaximumSize().width, 200));
        jPanel.setPreferredSize(new Dimension(jPanel.getPreferredSize().width, 200));
        return jPanel;
    }

    private final boolean isSelectionValidForFont(Object ... objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            boolean bl = true;
            for (Object object : objectArray) {
                if (object instanceof mmBranchCell || object instanceof mmFloatingIdeaCell || object instanceof mmFloatingTextCell || object instanceof mmRelationshipCell || object instanceof mmFlowConnectorCell || object instanceof mmFlowCell) continue;
                bl = false;
                break;
            }
            return bl;
        }
        return false;
    }

    private final void setupFontPanel() {
        this.contentHolder.add(this.getSubSectionTitleLabel(FONT_TITLE_TEXT));
        ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.SetupFontPanelAction", new Object[]{this.contentHolder});
        this.contentHolder.add(this.getBorderComponent());
        this.revalidate();
        this.repaint();
    }

    private final JPanel getSubSectionTitleLabel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
        JLabel jLabel = new JLabel(string);
        jLabel.setOpaque(false);
        jLabel.setHorizontalAlignment(2);
        jLabel.setFont(ApplicationFont.getRegularFont((int)1, (float)12.0f));
        jLabel.setForeground(SUBTITLE_FONT_COLOUR);
        jPanel.add((Component)jLabel, "North");
        return jPanel;
    }

    private final JPanel getBorderComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, PANEL_BORDER_COLOUR));
        return jPanel;
    }

    private final boolean isSelectionValidForBranch(Object ... objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            boolean bl = true;
            for (Object object : objectArray) {
                if (object instanceof mmBranchCell) continue;
                bl = false;
                break;
            }
            return bl;
        }
        return false;
    }

    private final void setupBranchPanel() {
        this.contentHolder.add(this.getSubSectionTitleLabel(BRANCH_TITLE_TEXT));
        ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.SetupBranchPanelAction", new Object[]{this.contentHolder});
        this.contentHolder.add(this.getBorderComponent());
        this.revalidate();
        this.repaint();
    }

    private final boolean isSelectionValidForColours(Object ... objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            boolean bl = true;
            for (Object object : objectArray) {
                if (object instanceof mmBranchCell || object instanceof mmFloatingIdeaCell || object instanceof mmFloatingTextCell || object instanceof mmRelationshipCell || object instanceof mmFlowConnectorCell || object instanceof mmFlowCell) continue;
                bl = false;
                break;
            }
            return bl;
        }
        return false;
    }

    private final void setupColoursPanel() {
        this.contentHolder.add(this.getSubSectionTitleLabel(COLOURS_TEXT));
        ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.SetupColoursPanelAction", new Object[]{this.contentHolder});
        this.contentHolder.add(this.getBorderComponent());
        this.revalidate();
        this.repaint();
    }

    private final boolean isSelectionValidForArrow(Object ... objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            boolean bl = true;
            for (Object object : objectArray) {
                if (object instanceof mmRelationshipCell || object instanceof mmFlowConnectorCell) continue;
                bl = false;
                break;
            }
            return bl;
        }
        return false;
    }

    private final void setupArrowPanel() {
        ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.SetupArrowPanelAction", new Object[]{this.contentHolder});
        this.contentHolder.add(this.getBorderComponent());
        this.revalidate();
        this.repaint();
    }

    private final boolean isSelectionValidForConvert(Object ... objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            boolean bl = true;
            for (Object object : objectArray) {
                if (object instanceof mmBranchCell) continue;
                bl = false;
                break;
            }
            return bl;
        }
        return false;
    }

    private final void setupConvertPanel() {
        this.contentHolder.add(this.getSubSectionTitleLabel(CONVERT_TITLE_TEXT));
        ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.SetupConvertPanelAction", new Object[]{this.contentHolder});
        this.revalidate();
        this.repaint();
    }
}

