/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.formatpanel.ui;

import com.jidesoft.utils.SystemInfo;
import com.mxgraph.mindmap.model.mmCell;
import com.thinkbuzan.apollo.ui.core.mac.YosemiteButton;
import com.thinkbuzan.apollo.ui.core.mac.YosemiteButtonGroup;
import com.thinkbuzan.apollo.ui.core.mac.YosemitePagedPanel;
import com.thinkbuzan.dozer.sidepanels.formatpanel.action.SelectionSupport;
import com.thinkbuzan.dozer.sidepanels.formatpanel.osgi.ServiceManager;
import com.thinkbuzan.dozer.sidepanels.formatpanel.resources.ResourceManager;
import com.thinkbuzan.dozer.sidepanels.formatpanel.ui.NoSelectionPanel;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.phoenix.brainstorm.model.IdeaCell;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrainstormFormatSidePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final Color BRAINSTORM_WHITE_COLOUR = Color.white;
    public static final Color BRAINSTORM_WHITE_BORDER_COLOUR = Color.decode("#262626");
    public static final Color BRAINSTORM_BLACK_COLOUR = Color.decode("#474949");
    public static final Color BRAINSTORM_BLACK_BORDER_COLOUR = Color.decode("#262626");
    public static final Color BRAINSTORM_RED_COLOUR = Color.decode("#d9534f");
    public static final Color BRAINSTORM_RED_BORDER_COLOUR = Color.decode("#262626");
    public static final Color BRAINSTORM_YELLOW_COLOUR = Color.decode("#fdf27e");
    public static final Color BRAINSTORM_YELLOW_BORDER_COLOUR = Color.decode("#262626");
    public static final Color BRAINSTORM_LIGHT_BLUE_COLOUR = Color.decode("#5bc0de");
    public static final Color BRAINSTORM_LIGHT_BLUE_BORDER_COLOUR = Color.decode("#262626");
    public static final Color BRAINSTORM_DARK_BLUE_COLOUR = Color.decode("#428bca");
    public static final Color BRAINSTORM_DARK_BLUE_BORDER_COLOUR = Color.decode("#242424");
    public static final Color BRAINSTORM_GREEN_COLOUR = Color.decode("#5cb85c");
    public static final Color BRAINSTORM_GREEN_BORDER_COLOUR = Color.decode("#262626");
    public static final Color BRAINSTORM_ORANGE_COLOUR = Color.decode("#f0ad4e");
    public static final Color BRAINSTORM_ORANGE_BORDER_COLOUR = Color.decode("#262626");
    public static final Color SIDE_PANEL_BORDER_COLOUR = Color.decode("#c7c7c7");
    public static final Color SIDE_PANEL_BACKGROUND_COLOUR = Color.decode("#f7f7f7");
    public static final int SIDE_PANEL_WIDTH_WINDOWS = 270;
    public static final int SIDE_PANEL_WIDTH_MAC = 250;
    public static final int SIDE_PANEL_MIN_HEIGHT = 200;
    public static final int TAB_HEIGHT = 30;
    private static final String EDIT_KEY = "com.thinkbuzan.i18n.common.edit";
    private static final String DELETE_KEY = "com.thinkbuzan.i18n.common.delete";
    private static final String COLOURS_KEY = "com.thinkbuzan.i18n.common.colours";
    private static final String ACTION_KEY = "com.thinkbuzan.i18n.process.action";
    private static final String TOGGLE_SIZE_KEY = "com.thinkbuzan.i18n.common.toggleSize";
    public static final String EDIT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.edit");
    public static final String DELETE = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.delete");
    public static final String COLOURS = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.colours");
    public static final String ACTION = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.process.action");
    public static final String TOGGLE_SIZE = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.toggleSize");
    private static final String PNG = ".png";
    private static final String ACTIVE = "_active";
    private static final String INACTIVE = "_inactive";
    private static final String BRAINSTORM_IDEA_TOGGLE_SMALL = "idea_small_switch";
    private static final String BRAINSTORM_IDEA_TOGGLE_LARGE = "idea_switch";
    public static final ImageIcon BRAINSTORM_TOGGLE_SMALL_ICON_ACTIVE = ResourceManager.getRetinaIcon("idea_small_switch_active.png");
    public static final ImageIcon BRAINSTORM_TOGGLE_LARGE_ICON_ACTIVE = ResourceManager.getRetinaIcon("idea_switch_active.png");
    public static final ImageIcon BRAINSTORM_TOGGLE_SMALL_ICON_INACTIVE = ResourceManager.getRetinaIcon("idea_small_switch.png");
    public static final ImageIcon BRAINSTORM_TOGGLE_LARGE_ICON_INACTIVE = ResourceManager.getRetinaIcon("idea_switch.png");
    private static final int LEFT_PADDING = 0;
    private static final int TOP_PADDING = 14;
    private static final Dimension BUTTON_SIZE = new Dimension(40, 40);
    private static final int WHITE = 0;
    private static final int BLACK = 1;
    private static final int YELLOW = 2;
    private static final int RED = 3;
    private static final int LIGHT_BLUE = 4;
    private static final int DARK_BLUE = 5;
    private static final int ORANGE = 6;
    private static final int GREEN = 7;
    private static final String SMALL_BUTTON = "small";
    private static final String LARGE_BUTTON = "large";
    private static final String EDIT_ACTION_ID = "com.thinkbuzan.apollo.brainstorm.actions.EditAction";
    private static final String DELETE_ACTION_ID = "com.thinkbuzan.apollo.brainstorm.actions.DeleteAction";
    private static final String FONT_TITLE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.font");
    private static final String FORMAT_PANEL_CARD_NO_SELECTION_ID = "noselection";
    private static final String FORMAT_PANEL_CARD_EDITOR_ID = "brainstorm";
    private static final float LABEL_FONT_SIZE = 12.0f;
    private final transient JPanel colourPanel = new JPanel();
    private final transient JPanel actionsPanel = new JPanel();
    private final transient JPanel ideaSizePanel = new JPanel();
    private final transient JPanel formatPanel = new JPanel();
    private final transient YosemiteButtonGroup buttonGroup = new YosemiteButtonGroup();
    private final transient SelectionSupport selectionSupport;
    private CardLayout cardLayout = new CardLayout();
    private JPanel cardPanel = new JPanel();

    public BrainstormFormatSidePanel() {
        this.setBackground(SIDE_PANEL_BACKGROUND_COLOUR);
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.createContentPanel();
        JPanel jPanel2 = this.createNoSelectionPanel();
        this.cardPanel.setOpaque(false);
        this.cardPanel.setLayout(this.cardLayout);
        this.cardPanel.add(FORMAT_PANEL_CARD_NO_SELECTION_ID, jPanel2);
        this.cardPanel.add(FORMAT_PANEL_CARD_EDITOR_ID, jPanel);
        this.add((Component)this.cardPanel, "Center");
        this.selectionSupport = new SelectionSupport(){

            public void updateState(IEditorComponent iEditorComponent, Object[] objectArray) {
                BrainstormFormatSidePanel.this.updateSelection(objectArray);
            }

            public void updateState() {
                BrainstormFormatSidePanel.this.updateSelection(null);
            }
        };
        this.cardLayout.show(this.cardPanel, FORMAT_PANEL_CARD_NO_SELECTION_ID);
    }

    public void updateSelection(Object[] objectArray) {
        boolean bl = false;
        boolean bl2 = false;
        if (objectArray != null) {
            ArrayList<mmCell> arrayList = new ArrayList<mmCell>(objectArray.length);
            for (Object object : objectArray) {
                if (!(object instanceof mmCell)) continue;
                arrayList.add((mmCell)object);
            }
            if (arrayList.size() == 0) {
                bl = true;
            } else if (arrayList.size() == 1) {
                this.setButtonGroupState(arrayList);
                bl2 = true;
            } else {
                this.setButtonGroupState(arrayList);
                bl2 = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            this.buttonGroup.setEnabled(false);
            this.cardLayout.show(this.cardPanel, FORMAT_PANEL_CARD_NO_SELECTION_ID);
        } else {
            this.cardLayout.show(this.cardPanel, FORMAT_PANEL_CARD_EDITOR_ID);
        }
        this.buttonGroup.setEnabled(bl2);
    }

    private void setButtonGroupState(ArrayList<mmCell> arrayList) {
        if (arrayList.get(0) instanceof IdeaCell) {
            IdeaCell ideaCell = (IdeaCell)arrayList.get(0);
            JButton jButton = this.buttonGroup.getButtonById(SMALL_BUTTON);
            JButton jButton2 = this.buttonGroup.getButtonById(LARGE_BUTTON);
            if (ideaCell.isSmall()) {
                this.buttonGroup.selectButtonById(SMALL_BUTTON);
                jButton.setIcon(BRAINSTORM_TOGGLE_SMALL_ICON_ACTIVE);
                jButton2.setIcon(BRAINSTORM_TOGGLE_LARGE_ICON_INACTIVE);
            } else {
                this.buttonGroup.selectButtonById(LARGE_BUTTON);
                jButton.setIcon(BRAINSTORM_TOGGLE_SMALL_ICON_INACTIVE);
                jButton2.setIcon(BRAINSTORM_TOGGLE_LARGE_ICON_ACTIVE);
            }
        }
    }

    private void setupColoursSection() {
        this.colourPanel.setOpaque(false);
        this.colourPanel.setLayout(new BoxLayout(this.colourPanel, 3));
        this.colourPanel.setBorder(BorderFactory.createEmptyBorder(14, 0, 0, 0));
        JLabel jLabel = this.createHeadingLabel(COLOURS);
        this.colourPanel.add(jLabel);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.WHITE);
        jPanel.setLayout(new FlowLayout(1, 0, 0));
        jPanel.setMinimumSize(new Dimension(jPanel.getMinimumSize().width, 100));
        jPanel.setMaximumSize(new Dimension(jPanel.getMaximumSize().width, 100));
        jPanel.setPreferredSize(new Dimension(jPanel.getPreferredSize().width, 100));
        jPanel.add(this.createColourButton(2));
        jPanel.add(this.createColourButton(1));
        jPanel.add(this.createColourButton(5));
        jPanel.add(this.createColourButton(4));
        jPanel.add(this.createColourButton(3));
        jPanel.add(this.createColourButton(6));
        jPanel.add(this.createColourButton(7));
        jPanel.add(this.createColourButton(0));
        ArrayList<JPanel> arrayList = new ArrayList<JPanel>();
        arrayList.add(jPanel);
        YosemitePagedPanel yosemitePagedPanel = new YosemitePagedPanel("", arrayList, true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        jPanel2.setBackground(Color.WHITE);
        jPanel2.add((Component)yosemitePagedPanel, "Center");
        this.colourPanel.add(jPanel2);
        this.setPanelHeight(this.colourPanel);
    }

    private void setupActionsPanel() {
        this.actionsPanel.setOpaque(false);
        this.actionsPanel.setLayout(new BoxLayout(this.actionsPanel, 3));
        this.actionsPanel.setBorder(BorderFactory.createEmptyBorder(14, 0, 0, 13));
        JLabel jLabel = this.createHeadingLabel(ACTION);
        this.actionsPanel.add(this.wrap(jLabel));
        YosemiteButton yosemiteButton = new YosemiteButton(EDIT);
        yosemiteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServiceManager.getActionManager().runAction(BrainstormFormatSidePanel.EDIT_ACTION_ID, new Object[0]);
            }
        });
        YosemiteButton yosemiteButton2 = new YosemiteButton(DELETE);
        yosemiteButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServiceManager.getActionManager().runAction(BrainstormFormatSidePanel.DELETE_ACTION_ID, new Object[0]);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new GridLayout(1, 3));
        jPanel.add((Component)yosemiteButton);
        jPanel.add(new JLabel(""));
        jPanel.add((Component)yosemiteButton2);
        this.actionsPanel.add(jPanel);
        this.actionsPanel.setAlignmentX(0.0f);
        this.setPanelHeight(this.actionsPanel);
    }

    private void setupIdeaSizePanel() {
        this.ideaSizePanel.setOpaque(false);
        this.ideaSizePanel.setLayout(new BoxLayout(this.ideaSizePanel, 3));
        this.ideaSizePanel.setBorder(BorderFactory.createEmptyBorder(14, 0, 0, 10));
        JLabel jLabel = this.createHeadingLabel(TOGGLE_SIZE);
        this.ideaSizePanel.add(this.wrap(jLabel));
        this.buttonGroup.addButton((Icon)BRAINSTORM_TOGGLE_SMALL_ICON_ACTIVE, this.getSetIdeaSmallAction(), SMALL_BUTTON);
        this.buttonGroup.addButton((Icon)BRAINSTORM_TOGGLE_LARGE_ICON_ACTIVE, this.getSetIdeaLargeAction(), LARGE_BUTTON);
        this.setPanelHeight((JComponent)this.buttonGroup, 35);
        this.ideaSizePanel.add((Component)this.buttonGroup);
        this.ideaSizePanel.setAlignmentX(0.0f);
        this.setPanelHeight(this.ideaSizePanel);
        final JButton jButton = this.buttonGroup.getButtonById(SMALL_BUTTON);
        final JButton jButton2 = this.buttonGroup.getButtonById(LARGE_BUTTON);
        jButton.setMinimumSize(new Dimension(jButton.getMinimumSize().width, 25));
        jButton.setMaximumSize(new Dimension(jButton.getMaximumSize().width, 25));
        jButton.setPreferredSize(new Dimension(jButton.getPreferredSize().width, 25));
        jButton2.setMinimumSize(new Dimension(jButton2.getMinimumSize().width, 25));
        jButton2.setMaximumSize(new Dimension(jButton2.getMaximumSize().width, 25));
        jButton2.setPreferredSize(new Dimension(jButton2.getPreferredSize().width, 25));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jButton.setIcon(BRAINSTORM_TOGGLE_SMALL_ICON_ACTIVE);
                jButton2.setIcon(BRAINSTORM_TOGGLE_LARGE_ICON_INACTIVE);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jButton.setIcon(BRAINSTORM_TOGGLE_SMALL_ICON_INACTIVE);
                jButton2.setIcon(BRAINSTORM_TOGGLE_LARGE_ICON_ACTIVE);
            }
        });
    }

    private ActionListener getSetIdeaSmallAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.apollo.brainstorm.actions.SetIdeaSmallAction", new Object[0]);
            }
        };
    }

    private ActionListener getSetIdeaLargeAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.apollo.brainstorm.actions.SetIdeaLargeAction", new Object[0]);
            }
        };
    }

    private JLabel createHeadingLabel(String string) {
        JLabel jLabel = new JLabel(string, 2);
        jLabel.setFont(new Font("Helvetica Neue", 1, 12));
        Dimension dimension = SystemInfo.isAnyMac() ? new Dimension(250, 30) : new Dimension(270, 30);
        jLabel.setPreferredSize(dimension);
        jLabel.setMinimumSize(dimension);
        jLabel.setMaximumSize(dimension);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        jLabel.setAlignmentX(0.0f);
        return jLabel;
    }

    private void setPanelHeight(JComponent jComponent) {
        jComponent.setPreferredSize(jComponent.getPreferredSize());
        jComponent.setMinimumSize(jComponent.getPreferredSize());
        jComponent.setMaximumSize(jComponent.getPreferredSize());
    }

    private void setPanelHeight(JComponent jComponent, int n) {
        Dimension dimension = SystemInfo.isAnyMac() ? new Dimension(250, n) : new Dimension(270, n);
        jComponent.setPreferredSize(dimension);
        jComponent.setMinimumSize(dimension);
        jComponent.setMaximumSize(dimension);
    }

    private JPanel wrap(Component component) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.setOpaque(false);
        jPanel.add(component);
        return jPanel;
    }

    private JPanel createColourButton(final int n) {
        String string;
        JButton jButton = new JButton(){
            private static final long serialVersionUID = 1L;

            protected void paintComponent(Graphics graphics) {
                Color color;
                Color color2;
                switch (n) {
                    case 0: {
                        color2 = BRAINSTORM_WHITE_COLOUR;
                        color = BRAINSTORM_WHITE_BORDER_COLOUR;
                        break;
                    }
                    case 1: {
                        color2 = BRAINSTORM_BLACK_COLOUR;
                        color = BRAINSTORM_BLACK_BORDER_COLOUR;
                        break;
                    }
                    case 5: {
                        color2 = BRAINSTORM_DARK_BLUE_COLOUR;
                        color = BRAINSTORM_DARK_BLUE_BORDER_COLOUR;
                        break;
                    }
                    case 4: {
                        color2 = BRAINSTORM_LIGHT_BLUE_COLOUR;
                        color = BRAINSTORM_LIGHT_BLUE_BORDER_COLOUR;
                        break;
                    }
                    case 3: {
                        color2 = BRAINSTORM_RED_COLOUR;
                        color = BRAINSTORM_RED_BORDER_COLOUR;
                        break;
                    }
                    case 7: {
                        color2 = BRAINSTORM_GREEN_COLOUR;
                        color = BRAINSTORM_GREEN_BORDER_COLOUR;
                        break;
                    }
                    case 2: {
                        color2 = BRAINSTORM_YELLOW_COLOUR;
                        color = BRAINSTORM_YELLOW_BORDER_COLOUR;
                        break;
                    }
                    case 6: {
                        color2 = BRAINSTORM_ORANGE_COLOUR;
                        color = BRAINSTORM_ORANGE_BORDER_COLOUR;
                        break;
                    }
                    default: {
                        color2 = Color.white;
                        color = Color.black;
                    }
                }
                graphics.setColor(color2);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics.setColor(color);
                graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        };
        jButton.setContentAreaFilled(false);
        jButton.setOpaque(false);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setRolloverEnabled(false);
        jButton.setMinimumSize(BUTTON_SIZE);
        jButton.setMaximumSize(BUTTON_SIZE);
        jButton.setPreferredSize(BUTTON_SIZE);
        switch (n) {
            case 0: {
                string = "com.thinkbuzan.apollo.brainstorm.actions.SetColourWhiteAction";
                break;
            }
            case 1: {
                string = "com.thinkbuzan.apollo.brainstorm.actions.SetColourBlackAction";
                break;
            }
            case 5: {
                string = "com.thinkbuzan.apollo.brainstorm.actions.SetColourDarkBlueAction";
                break;
            }
            case 4: {
                string = "com.thinkbuzan.apollo.brainstorm.actions.SetColourLightBlueAction";
                break;
            }
            case 3: {
                string = "com.thinkbuzan.apollo.brainstorm.actions.SetColourRedAction";
                break;
            }
            case 7: {
                string = "com.thinkbuzan.apollo.brainstorm.actions.SetColourGreenAction";
                break;
            }
            case 2: {
                string = "com.thinkbuzan.apollo.brainstorm.actions.SetColourYellowAction";
                break;
            }
            case 6: {
                string = "com.thinkbuzan.apollo.brainstorm.actions.SetColourOrangeAction";
                break;
            }
            default: {
                string = "com.thinkbuzan.apollo.brainstorm.actions.SetColourYellowAction";
            }
        }
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServiceManager.getActionManager().runAction(string, new Object[0]);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jButton, "Center");
        return jPanel;
    }

    private final void setupFormatPanel() {
        this.formatPanel.setOpaque(false);
        this.formatPanel.setLayout(new BoxLayout(this.formatPanel, 3));
        this.formatPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 10));
        JLabel jLabel = this.createHeadingLabel(FONT_TITLE_TEXT);
        this.formatPanel.add(this.wrap(jLabel));
        ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.SetupBrainstormFontPanelAction", new Object[]{this.formatPanel});
        this.formatPanel.setAlignmentX(0.0f);
        this.setPanelHeight(this.formatPanel);
        this.revalidate();
        this.repaint();
    }

    private final JPanel createContentPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setupColoursSection();
        this.setupActionsPanel();
        this.setupIdeaSizePanel();
        this.setupFormatPanel();
        jPanel.add(this.colourPanel);
        jPanel.add(this.actionsPanel);
        jPanel.add(this.ideaSizePanel);
        jPanel.add(this.formatPanel);
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    private final JPanel createNoSelectionPanel() {
        return new NoSelectionPanel();
    }
}

