/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.formatpanel.ui.mac;

import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.dozer.sidepanels.formatpanel.osgi.ServiceManager;
import com.thinkbuzan.dozer.sidepanels.formatpanel.ui.AbstractFormatSidePanel;
import com.thinkbuzan.dozer.sidepanels.formatpanel.ui.mac.StylesSidePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class MacFormatSidePanel
extends AbstractFormatSidePanel {
    private static final long serialVersionUID = 1L;
    private static final String MAP_STYLE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.win.ui.mapstyle");
    private static final Dimension PREFERRED_SIZE = new Dimension(250, 330);

    public MacFormatSidePanel() {
        this.emptyContentHolder = new JPanel();
        this.emptyContentHolder.setOpaque(false);
        this.emptyContentHolder.setLayout(new BorderLayout());
        this.setupStylesPanel();
    }

    private void setupStylesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.decode("#f7f7f7"));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.getTitleLabel(MAP_STYLE_TEXT), "North");
        jPanel.add((Component)new StylesSidePanel(), "Center");
        this.emptyContentHolder.add((Component)jPanel, "North");
    }

    private final JPanel getTitleLabel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        Border border = BorderFactory.createEmptyBorder(10, 10, 10, 0);
        MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, PANEL_BORDER_COLOUR);
        jPanel.setBorder(BorderFactory.createCompoundBorder(matteBorder, border));
        JLabel jLabel = new JLabel(string);
        jLabel.setOpaque(false);
        jLabel.setHorizontalAlignment(2);
        jLabel.setFont(ApplicationFont.getRegularFont((int)1, (float)12.0f));
        jLabel.setForeground(SUBTITLE_FONT_COLOUR);
        jPanel.add((Component)jLabel, "North");
        return jPanel;
    }

    public JComponent getComponent() {
        return this;
    }

    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    public void sketchToolStateChanged(boolean bl) {
        this.refresh();
        if (bl) {
            ServiceManager.getActionManager().runAction("com.thinkbuzan.apollo.ui.mac.actions.ShowFormatPanelAction", new Object[0]);
        }
    }

    protected final void setupSketchPanel() {
        ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.SetupMacSketchPanelAction", new Object[]{this.contentHolder});
        this.revalidate();
        this.repaint();
    }
}

