/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.formatpanel.ui.mac;

import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.apollo.ui.core.mac.YosemiteButton;
import com.thinkbuzan.apollo.ui.core.mac.YosemitePagedPanel;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.dozer.sidepanels.formatpanel.osgi.ServiceManager;
import com.thinkbuzan.dozer.sidepanels.formatpanel.ui.mac.styles.AbstractStyleListCellRenderer;
import com.thinkbuzan.dozer.sidepanels.formatpanel.ui.mac.styles.ColourOptionCellRenderer;
import com.thinkbuzan.dozer.sidepanels.formatpanel.ui.mac.styles.FontOptionCellRenderer;
import com.thinkbuzan.dozer.sidepanels.formatpanel.ui.mac.styles.GraphicsOptionCellRenderer;
import com.thinkbuzan.dozer.sidepanels.formatpanel.ui.mac.styles.LayoutOptionCellRenderer;
import com.thinkbuzan.dozer.sidepanels.formatpanel.ui.mac.styles.StyleOption;
import com.thinkbuzan.gaia.entities.ColorOption;
import com.thinkbuzan.gaia.entities.FontOption;
import com.thinkbuzan.gaia.entities.GraphicsOption;
import com.thinkbuzan.gaia.entities.LayoutOption;
import com.thinkbuzan.gaia.entities.Option;
import com.thinkbuzan.gaia.entities.Theme;
import com.thinkbuzan.gaia.theme.listener.ThemeEvent;
import com.thinkbuzan.gaia.theme.listener.ThemesListener;
import com.thinkbuzan.gaia.theme.manager.ThemeManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StylesSidePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String STYLES_PANEL_TITLE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.styles");
    private static final String COLOURS_TITLE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.colours");
    private static final String CREATE_COLOUR_OPTION_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.styles.customiseColours");
    private static final String FONTS_TITLE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.fonts");
    private static final String CREATE_FONT_OPTION_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.styles.customiseFonts");
    private static final String LAYOUT_TITLE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.layout");
    private static final String CREATE_LAYOUT_OPTION_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.styles.customiseLayout");
    private static final String GRAPHICS_TITLE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.graphics");
    private static final String CREATE_GRAPHICS_OPTION_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.styles.customiseGraphics");
    private static final String SAVE_TITLE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.save");
    private static final String SAVE_STYLE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.styles.saveStyle");
    private static final Color BACKGROUND_COLOUR = Color.decode("#f7f7f7");
    private static final Color PANEL_BORDER_COLOUR = Color.decode("#cfcfcf");
    private static final int SUBTITLE_FONT_STYLE = 1;
    private static final float SUBTITLE_FONT_SIZE = 12.0f;
    private static final Color SUBTITLE_FONT_COLOUR = Color.decode("#444057");
    private static final int TITLE_PANEL_PADDING_TOP = 5;
    private static final int TITLE_PANEL_PADDING_LEFT = 15;
    private static final int TITLE_PANEL_PADDING_BOTTOM = 5;
    private static final int TITLE_PANEL_PADDING_RIGHT = 5;
    private static final int COMBO_PANEL_PADDING_LEFT = 10;
    private static final int COMBO_PANEL_PADDING_BOTTOM = 10;
    private static final int DROP_DOWN_BOTTOM_BUTTON_TEXT_STYLE = 0;
    private static final float DROP_DOWN_BOTTOM_BUTTON_TEXT_SIZE = 12.0f;
    private static final Color DROP_DOWN_BOTTOM_BUTTON_TEXT_COLOUR = Color.decode("#444057");
    private static final Color DROP_DOWN_BOTTOM_BUTTON_TEXT_COLOUR_HOVER = Color.decode("#ffffff");
    private static final Color DROP_DOWN_BOTTOM_BUTTON_BACKGROUND_COLOUR_HOVER = Color.decode("#3284ff");
    private static final int DROP_DOWN_PADDING = 2;
    private static final int NUMBER_STYLE_ITEMS_PER_PAGE = 6;
    private JPanel stylesHolder;
    private JPanel coloursHolder;
    private JPanel fontsHolder;
    private JPanel layoutHolder;
    private JPanel graphicsHolder;
    private JPanel saveHolder;
    private JPanel contentHolder;
    private boolean setColourComboUIOnly = false;
    private boolean setFontComboUIOnly = false;
    private boolean setLayoutComboUIOnly = false;
    private boolean setGraphicsComboUIOnly = false;
    private JComboBox coloursCombo;
    private JComboBox fontsCombo;
    private JComboBox layoutCombo;
    private JComboBox graphicsCombo;
    private HashMap<String, StyleOption> themeOptionMap = new HashMap();

    public StylesSidePanel() {
        this.setOpaque(true);
        this.setBackground(BACKGROUND_COLOUR);
        this.setLayout(new BorderLayout());
        this.contentHolder = new JPanel();
        this.contentHolder.setOpaque(false);
        this.contentHolder.setLayout(new BoxLayout(this.contentHolder, 1));
        this.stylesHolder = new JPanel();
        this.stylesHolder.setOpaque(false);
        this.stylesHolder.setLayout(new BoxLayout(this.stylesHolder, 0));
        this.coloursHolder = this.getBorderedSubPanel();
        this.fontsHolder = this.getBorderedSubPanel();
        this.layoutHolder = this.getBorderedSubPanel();
        this.graphicsHolder = this.getBorderedSubPanel();
        this.saveHolder = this.getBorderedSubPanel();
        this.add((Component)this.contentHolder, "North");
        this.contentHolder.add(this.stylesHolder);
        this.contentHolder.add(this.coloursHolder);
        this.contentHolder.add(this.fontsHolder);
        this.contentHolder.add(this.layoutHolder);
        this.contentHolder.add(this.graphicsHolder);
        this.contentHolder.add(this.saveHolder);
        this.contentHolder.add(Box.createVerticalGlue());
        ServiceManager.addThemeManagerServiceListener(new IServiceListener<ThemeManager>(){

            public void serviceRemoved(ThemeManager themeManager) {
            }

            public void serviceAdded(final ThemeManager themeManager) {
                StylesSidePanel.this.setupStylesPanel(themeManager);
                themeManager.addThemesListener(new ThemesListener(){

                    public void themesChanged(final ThemeEvent themeEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                switch (themeEvent.getType()) {
                                    case THEMES_CHANGED: {
                                        StylesSidePanel.this.setupStylesPanel(themeManager);
                                        break;
                                    }
                                    case THEMES_SELECTION_CHANGED: {
                                        StylesSidePanel.this.setSelectedThemeChanged(themeManager);
                                        break;
                                    }
                                    case OPTIONS_CHANGED: {
                                        if (themeEvent.getOptionClass().equals(ColorOption.class)) {
                                            StylesSidePanel.this.setupStylesColourPanel(themeManager, themeManager.getColorOptionManager().getOptions());
                                            break;
                                        }
                                        if (themeEvent.getOptionClass().equals(FontOption.class)) {
                                            StylesSidePanel.this.setupStylesFontPanel(themeManager, themeManager.getFontOptionManager().getOptions());
                                            break;
                                        }
                                        if (themeEvent.getOptionClass().equals(LayoutOption.class)) {
                                            StylesSidePanel.this.setupStylesLayoutPanel(themeManager, themeManager.getLayoutOptionManager().getOptions());
                                            break;
                                        }
                                        if (!themeEvent.getOptionClass().equals(GraphicsOption.class)) break;
                                        StylesSidePanel.this.setupStylesGraphicsPanel(themeManager, themeManager.getGraphicsOptionManager().getOptions());
                                        break;
                                    }
                                    case OPTIONS_SELECTION_CHANGED: {
                                        if (themeEvent.getOptionClass().equals(ColorOption.class)) {
                                            StylesSidePanel.this.setSelectedColourOption(themeManager);
                                            break;
                                        }
                                        if (themeEvent.getOptionClass().equals(FontOption.class)) {
                                            StylesSidePanel.this.setSelectedFontOption(themeManager);
                                            break;
                                        }
                                        if (themeEvent.getOptionClass().equals(LayoutOption.class)) {
                                            StylesSidePanel.this.setSelectedLayoutOption(themeManager);
                                            break;
                                        }
                                        if (!themeEvent.getOptionClass().equals(GraphicsOption.class)) break;
                                        StylesSidePanel.this.setSelectedGraphicsOption(themeManager);
                                        break;
                                    }
                                }
                                StylesSidePanel.this.revalidate();
                                StylesSidePanel.this.repaint();
                            }
                        });
                    }
                });
            }
        });
    }

    private final void setupStylesPanel(ThemeManager themeManager) {
        this.setupStylesSelectorPanel(themeManager.getThemes());
        this.setupStylesColourPanel(themeManager, themeManager.getColorOptionManager().getOptions());
        this.setupStylesFontPanel(themeManager, themeManager.getFontOptionManager().getOptions());
        this.setupStylesLayoutPanel(themeManager, themeManager.getLayoutOptionManager().getOptions());
        this.setupStylesGraphicsPanel(themeManager, themeManager.getGraphicsOptionManager().getOptions());
        this.setupSavePanel();
        this.revalidate();
        this.repaint();
    }

    private final void setupAddListItemListener(JComboBox jComboBox, String string, String string2, final AbstractStyleListCellRenderer abstractStyleListCellRenderer) {
        Accessible accessible = jComboBox.getUI().getAccessibleChild(jComboBox, 0);
        if (accessible instanceof JPopupMenu) {
            final JPopupMenu jPopupMenu = (JPopupMenu)accessible;
            JPanel jPanel = this.getDropDownBottomButtonPanel(string, string2);
            jPopupMenu.add(jPanel);
            try {
                Field field = BasicComboPopup.class.getDeclaredField("scroller");
                field.setAccessible(true);
                JScrollPane jScrollPane = (JScrollPane)field.get(jPopupMenu);
                jScrollPane.getViewport().getView().addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        mouseEvent.consume();
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                        mouseEvent.consume();
                    }

                    public void mousePressed(MouseEvent mouseEvent) {
                        mouseEvent.consume();
                        abstractStyleListCellRenderer.listMousePressed(jPopupMenu, mouseEvent);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final void setupSavePanel() {
        this.saveHolder.removeAll();
        this.saveHolder.add(this.getSubPanelTitle(SAVE_TITLE_TEXT));
        YosemiteButton yosemiteButton = new YosemiteButton(SAVE_STYLE_TEXT);
        yosemiteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.theme.actions.ShowSaveCurrentThemeDialogAction", new Object[0]);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new GridLayout(1, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 15, 15));
        jPanel.add((Component)yosemiteButton);
        jPanel.add(new JLabel());
        this.saveHolder.add(jPanel);
    }

    private final void setupStylesGraphicsPanel(ThemeManager themeManager, List<GraphicsOption> list) {
        this.graphicsHolder.removeAll();
        this.graphicsHolder.add(this.getSubPanelTitle(GRAPHICS_TITLE_TEXT));
        this.graphicsCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(list.toArray()));
        this.graphicsCombo.setUI(CoreUIFactory.getComboBoxUI());
        final GraphicsOptionCellRenderer graphicsOptionCellRenderer = new GraphicsOptionCellRenderer();
        this.graphicsCombo.setRenderer(graphicsOptionCellRenderer);
        this.setupAddListItemListener(this.graphicsCombo, CREATE_GRAPHICS_OPTION_TEXT, "com.thinkbuzan.gaia.theme.actions.ShowGraphicsOptionsDialogAction", graphicsOptionCellRenderer);
        this.setSelectedGraphicsOption(themeManager);
        this.graphicsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StylesSidePanel.this.setGraphicsComboUIOnly) {
                    return;
                }
                if (graphicsOptionCellRenderer.isDeletedPressed()) {
                    graphicsOptionCellRenderer.resetDelete();
                    return;
                }
                Object object = StylesSidePanel.this.graphicsCombo.getSelectedItem();
                if (object instanceof GraphicsOption) {
                    ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.theme.actions.SetThemeOptionByIdAction", new Object[]{((GraphicsOption)object).getUUID().toString()});
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 0));
        jPanel.add((Component)this.graphicsCombo, "North");
        this.graphicsHolder.add(jPanel);
    }

    private final void setupStylesLayoutPanel(ThemeManager themeManager, List<LayoutOption> list) {
        this.layoutHolder.removeAll();
        this.layoutHolder.add(this.getSubPanelTitle(LAYOUT_TITLE_TEXT));
        this.layoutCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(list.toArray()));
        this.layoutCombo.setUI(CoreUIFactory.getComboBoxUI());
        final LayoutOptionCellRenderer layoutOptionCellRenderer = new LayoutOptionCellRenderer();
        this.layoutCombo.setRenderer(layoutOptionCellRenderer);
        this.setupAddListItemListener(this.layoutCombo, CREATE_LAYOUT_OPTION_TEXT, "com.thinkbuzan.gaia.theme.actions.ShowLayoutOptionsDialogAction", layoutOptionCellRenderer);
        this.setSelectedLayoutOption(themeManager);
        this.layoutCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StylesSidePanel.this.setLayoutComboUIOnly) {
                    return;
                }
                if (layoutOptionCellRenderer.isDeletedPressed()) {
                    layoutOptionCellRenderer.resetDelete();
                    return;
                }
                Object object = StylesSidePanel.this.layoutCombo.getSelectedItem();
                if (object instanceof LayoutOption) {
                    ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.theme.actions.SetThemeOptionByIdAction", new Object[]{((LayoutOption)object).getUUID().toString()});
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 0));
        jPanel.add((Component)this.layoutCombo, "North");
        this.layoutHolder.add(jPanel);
    }

    private final void setupStylesFontPanel(ThemeManager themeManager, List<FontOption> list) {
        this.fontsHolder.removeAll();
        this.fontsHolder.add(this.getSubPanelTitle(FONTS_TITLE_TEXT));
        this.fontsCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(list.toArray()));
        this.fontsCombo.setUI(CoreUIFactory.getComboBoxUI());
        final FontOptionCellRenderer fontOptionCellRenderer = new FontOptionCellRenderer();
        this.fontsCombo.setRenderer(fontOptionCellRenderer);
        this.setupAddListItemListener(this.fontsCombo, CREATE_FONT_OPTION_TEXT, "com.thinkbuzan.gaia.theme.actions.ShowFontOptionsDialogAction", fontOptionCellRenderer);
        this.setSelectedFontOption(themeManager);
        this.fontsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StylesSidePanel.this.setFontComboUIOnly) {
                    return;
                }
                if (fontOptionCellRenderer.isDeletedPressed()) {
                    fontOptionCellRenderer.resetDelete();
                    return;
                }
                Object object = StylesSidePanel.this.fontsCombo.getSelectedItem();
                if (object instanceof FontOption) {
                    ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.theme.actions.SetThemeOptionByIdAction", new Object[]{((FontOption)object).getUUID().toString()});
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 0));
        jPanel.add((Component)this.fontsCombo, "North");
        this.fontsHolder.add(jPanel);
    }

    private final void setupStylesColourPanel(ThemeManager themeManager, List<ColorOption> list) {
        this.coloursHolder.removeAll();
        this.coloursHolder.add(this.getSubPanelTitle(COLOURS_TITLE_TEXT));
        this.coloursCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(list.toArray()));
        this.coloursCombo.setUI(CoreUIFactory.getComboBoxUI());
        final ColourOptionCellRenderer colourOptionCellRenderer = new ColourOptionCellRenderer();
        this.coloursCombo.setRenderer(colourOptionCellRenderer);
        this.setupAddListItemListener(this.coloursCombo, CREATE_COLOUR_OPTION_TEXT, "com.thinkbuzan.gaia.theme.actions.ShowColorOptionsDialogAction", colourOptionCellRenderer);
        this.setSelectedColourOption(themeManager);
        this.coloursCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StylesSidePanel.this.setColourComboUIOnly) {
                    return;
                }
                if (colourOptionCellRenderer.isDeletedPressed()) {
                    colourOptionCellRenderer.resetDelete();
                    return;
                }
                Object object = StylesSidePanel.this.coloursCombo.getSelectedItem();
                if (object instanceof ColorOption) {
                    ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.theme.actions.SetThemeOptionByIdAction", new Object[]{((ColorOption)object).getUUID().toString()});
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 0));
        jPanel.add((Component)this.coloursCombo, "North");
        this.coloursHolder.add(jPanel);
    }

    private final void setSelectedThemeChanged(ThemeManager themeManager) {
        Theme theme = themeManager.getSelectedTheme();
        if (theme != null) {
            Set<String> set = this.themeOptionMap.keySet();
            for (String string : set) {
                StyleOption styleOption = this.themeOptionMap.get(string);
                if (styleOption == null) continue;
                styleOption.setOptionSelected(theme.getUUID().toString().equals(string));
            }
        }
    }

    private final void setSelectedGraphicsOption(ThemeManager themeManager) {
        if (themeManager.getSelectedTheme() != null && this.isModelObjectInDefaultComboBoxModel(this.graphicsCombo, (Option)themeManager.getSelectedTheme().getGraphicsOption())) {
            this.setGraphicsComboUIOnly = true;
            this.graphicsCombo.getModel().setSelectedItem(themeManager.getSelectedTheme().getGraphicsOption());
            this.setGraphicsComboUIOnly = false;
        }
    }

    private final void setSelectedLayoutOption(ThemeManager themeManager) {
        if (themeManager.getSelectedTheme() != null && this.isModelObjectInDefaultComboBoxModel(this.layoutCombo, (Option)themeManager.getSelectedTheme().getLayoutOption())) {
            this.setLayoutComboUIOnly = true;
            this.layoutCombo.getModel().setSelectedItem(themeManager.getSelectedTheme().getLayoutOption());
            this.setLayoutComboUIOnly = false;
        }
    }

    private final void setSelectedFontOption(ThemeManager themeManager) {
        if (themeManager.getSelectedTheme() != null && this.isModelObjectInDefaultComboBoxModel(this.fontsCombo, (Option)themeManager.getSelectedTheme().getFontOption())) {
            this.setFontComboUIOnly = true;
            this.fontsCombo.getModel().setSelectedItem(themeManager.getSelectedTheme().getFontOption());
            this.setFontComboUIOnly = false;
        }
    }

    private final boolean isModelObjectInDefaultComboBoxModel(JComboBox jComboBox, Option option) {
        if (jComboBox.getModel() instanceof DefaultComboBoxModel) {
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)jComboBox.getModel();
            Object object = defaultComboBoxModel.getSelectedItem();
            for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                Option option2;
                Object e = defaultComboBoxModel.getElementAt(i);
                if (!(e instanceof Option) || !(option2 = (Option)e).getUUID().equals(option.getUUID()) || !(object instanceof Option) || option2.getUUID().equals(((Option)object).getUUID())) continue;
                return true;
            }
        }
        return false;
    }

    private final void setSelectedColourOption(ThemeManager themeManager) {
        if (themeManager.getSelectedTheme() != null && this.isModelObjectInDefaultComboBoxModel(this.coloursCombo, (Option)themeManager.getSelectedTheme().getColorOption())) {
            this.setColourComboUIOnly = true;
            this.coloursCombo.getModel().setSelectedItem(themeManager.getSelectedTheme().getColorOption());
            this.setColourComboUIOnly = false;
        }
    }

    private final void setupStylesSelectorPanel(List<Theme> list) {
        Object object;
        int n;
        this.stylesHolder.removeAll();
        this.themeOptionMap = new HashMap();
        ArrayList<JPanel> arrayList = new ArrayList<JPanel>();
        JPanel jPanel = this.getThemeBasePanel();
        for (n = 0; n < list.size(); ++n) {
            object = list.get(n);
            if (n != 0 && n % 6 == 0) {
                if (n != list.size()) {
                    arrayList.add(jPanel);
                }
                jPanel = this.getThemeBasePanel();
            }
            StyleOption styleOption = new StyleOption((Theme)object);
            this.themeOptionMap.put(object.getUUID().toString(), styleOption);
            JPanel jPanel2 = new JPanel();
            jPanel2.setOpaque(false);
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(styleOption);
            jPanel2.setMinimumSize(new Dimension(75, 75));
            jPanel2.setMaximumSize(new Dimension(75, 75));
            jPanel2.setPreferredSize(new Dimension(75, 75));
            jPanel.add(jPanel2);
        }
        if (list.size() % 6 != 0) {
            n = list.size();
            while (n % 6 != 0) {
                object = new JPanel();
                ((JComponent)object).setOpaque(false);
                ((Container)object).setLayout(new BoxLayout((Container)object, 0));
                ((JComponent)object).setMinimumSize(new Dimension(75, 75));
                ((JComponent)object).setMaximumSize(new Dimension(75, 75));
                ((JComponent)object).setPreferredSize(new Dimension(75, 75));
                ((Container)object).add(new JLabel());
                jPanel.add((Component)object);
                ++n;
            }
        }
        arrayList.add(jPanel);
        YosemitePagedPanel yosemitePagedPanel = new YosemitePagedPanel(STYLES_PANEL_TITLE_TEXT, arrayList);
        object = new JPanel();
        ((JComponent)object).setOpaque(true);
        ((JComponent)object).setBackground(Color.WHITE);
        ((Container)object).setLayout(new BoxLayout((Container)object, 0));
        ((Container)object).add((Component)yosemitePagedPanel);
        this.stylesHolder.add((Component)object);
    }

    private final JPanel getBorderedSubPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, PANEL_BORDER_COLOUR));
        return jPanel;
    }

    private final JPanel getThemeBasePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new GridLayout(2, 3));
        jPanel.setMinimumSize(new Dimension(jPanel.getMinimumSize().width, 200));
        jPanel.setMaximumSize(new Dimension(jPanel.getMaximumSize().width, 200));
        jPanel.setPreferredSize(new Dimension(jPanel.getPreferredSize().width, 200));
        return jPanel;
    }

    private final JPanel getSubPanelTitle(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 5));
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(2);
        jLabel.setFont(ApplicationFont.getRegularFont((int)1, (float)12.0f));
        jLabel.setForeground(SUBTITLE_FONT_COLOUR);
        jPanel.add((Component)jLabel, "North");
        return jPanel;
    }

    private final JPanel getDropDownBottomButtonPanel(String string, final String string2) {
        final JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(DROP_DOWN_BOTTOM_BUTTON_BACKGROUND_COLOUR_HOVER);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, PANEL_BORDER_COLOUR), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        final JLabel jLabel = new JLabel(string);
        jLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
        jLabel.setForeground(DROP_DOWN_BOTTOM_BUTTON_TEXT_COLOUR);
        jLabel.setHorizontalAlignment(2);
        jPanel.add((Component)jLabel, "Center");
        jPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                ServiceManager.getActionManager().runAction(string2, new Object[0]);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                super.mouseEntered(mouseEvent);
                jLabel.setForeground(DROP_DOWN_BOTTOM_BUTTON_TEXT_COLOUR_HOVER);
                jLabel.revalidate();
                jLabel.repaint();
                jPanel.setOpaque(true);
                jPanel.revalidate();
                jPanel.repaint();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                super.mouseExited(mouseEvent);
                jLabel.setForeground(DROP_DOWN_BOTTOM_BUTTON_TEXT_COLOUR);
                jLabel.revalidate();
                jLabel.repaint();
                jPanel.setOpaque(false);
                jPanel.revalidate();
                jPanel.repaint();
            }
        });
        return jPanel;
    }
}

