/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.formatpanel.ui.mac.styles;

import com.thinkbuzan.apollo.ui.core.win.component.ColourOptionIcons;
import com.thinkbuzan.dozer.sidepanels.formatpanel.osgi.ServiceManager;
import com.thinkbuzan.dozer.sidepanels.formatpanel.resources.ResourceManager;
import com.thinkbuzan.dozer.sidepanels.formatpanel.ui.mac.styles.AbstractStyleListCellRenderer;
import com.thinkbuzan.gaia.entities.ColorOption;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColourOptionCellRenderer
extends AbstractStyleListCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final int DELETE_PADDING = 15;
    private static final ImageIcon TRASH_ICON = ResourceManager.createImageIcon("delete-15px.png");
    private static final Color HIGHLIGHT_COLOUR = Color.decode("#3284ff");
    private JList<?> listComp = null;
    private boolean deletePressed = false;
    private boolean deleteActive = false;

    @Override
    public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
        Object object2;
        this.listComp = jList;
        JLabel jLabel = new JLabel();
        if (object instanceof ColorOption) {
            object2 = (ColorOption)object;
            jLabel.setText(object2.getName());
            jLabel.setIcon(ColourOptionIcons.getInstance().getIcon(object2.getColors()));
        } else {
            jLabel.setText(" ");
        }
        object2 = new JPanel();
        ((JComponent)object2).setOpaque(bl);
        ((JComponent)object2).setBackground(HIGHLIGHT_COLOUR);
        ((Container)object2).setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        if (object instanceof ColorOption) {
            ColorOption colorOption = (ColorOption)object;
            if (bl && colorOption.isUserDefined()) {
                jPanel.add(new JLabel(TRASH_ICON));
                this.deleteActive = true;
            } else {
                if (n != -1) {
                    jPanel.add(Box.createHorizontalStrut(15));
                }
                this.deleteActive = false;
            }
        } else {
            this.deleteActive = false;
        }
        ((Container)object2).add((Component)jPanel, "West");
        ((Container)object2).add((Component)jLabel, "Center");
        return object2;
    }

    @Override
    public final void listMousePressed(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        if (this.listComp != null && this.deleteActive) {
            int n = this.listComp.locationToIndex(mouseEvent.getPoint());
            if (mouseEvent.getX() >= 0 && mouseEvent.getX() <= 15) {
                this.deletePressed = true;
                Object obj = this.listComp.getModel().getElementAt(n);
                if (obj instanceof ColorOption) {
                    ColorOption colorOption = (ColorOption)obj;
                    ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.theme.actions.RemoveThemeOptionByIdAction", new Object[]{colorOption.getUUID().toString()});
                }
            }
        }
    }

    public final boolean isDeletedPressed() {
        return this.deletePressed;
    }

    public final void resetDelete() {
        this.deletePressed = false;
    }
}

