/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.formatpanel.ui.mac.styles;

import com.thinkbuzan.apollo.ui.core.RetinaIcon;
import com.thinkbuzan.apollo.ui.core.win.component.ModalOptionDialog;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.dozer.sidepanels.formatpanel.osgi.ServiceManager;
import com.thinkbuzan.gaia.entities.Theme;
import com.thinkbuzan.gaia.theme.manager.ThemeManager;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class StyleOption
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Color HOVER_COLOUR = Color.decode("#dddddd");
    private static final Color SELECTED_BORDER_COLOUR = Color.decode("#dddddd");
    private static final int PADDING = 2;
    private boolean optionSelected = false;
    private final JPopupMenu _rightClickMenu = this.createRightClickMenu();
    private JMenuItem _remove;
    private Theme _rightClickTheme;

    public StyleOption(final Theme theme) {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setBackground(HOVER_COLOUR);
        JLabel jLabel = new JLabel((Icon)new RetinaIcon((Image)this.getThumbnail(theme, false), (Image)this.getThumbnail(theme, true)));
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 0, 0));
        JLabel jLabel2 = new JLabel(theme.getName(), 0);
        jLabel2.setFont(ApplicationFont.getRegularFont((int)0, (float)10.0f));
        this.add((Component)jLabel, "West");
        this.add((Component)jLabel2, "South");
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.theme.actions.SetThemeByIdAction", new Object[]{theme.getUUID().toString()});
                } else if (mouseEvent.getButton() == 3) {
                    StyleOption.this._remove.setEnabled(theme.isUserDefined());
                    StyleOption.this._rightClickTheme = theme;
                    StyleOption.this._rightClickMenu.show(StyleOption.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                super.mouseEntered(mouseEvent);
                StyleOption.this.setOpaque(true);
                StyleOption.this.revalidate();
                StyleOption.this.repaint();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                super.mouseExited(mouseEvent);
                StyleOption.this.setOpaque(false);
                StyleOption.this.revalidate();
                StyleOption.this.repaint();
            }
        });
        try {
            ThemeManager themeManager = ServiceManager.getThemeManager();
            if (themeManager.getSelectedTheme().getUUID().equals(theme.getUUID().toString())) {
                this.setOptionSelected(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean isOptionSelected() {
        return this.optionSelected;
    }

    public final void setOptionSelected(boolean bl) {
        this.optionSelected = bl;
        if (this.optionSelected) {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createLineBorder(SELECTED_BORDER_COLOUR)));
            this.revalidate();
            this.repaint();
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.revalidate();
            this.repaint();
        }
    }

    private final BufferedImage getThumbnail(Theme theme, boolean bl) {
        try {
            return ServiceManager.getThemeManager().getThumbnail(theme, bl);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private JPopupMenu createRightClickMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.guicommons.stylepicker.setAsDefault"));
        this._remove = new JMenuItem(ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.remove"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StyleOption.this._rightClickTheme != null) {
                    ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.theme.actions.SetDefaultThemeByIdAction", new Object[]{StyleOption.this._rightClickTheme.getUUID().toString()});
                }
            }
        });
        this._remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StyleOption.this._rightClickTheme != null && StyleOption.this._rightClickTheme.isUserDefined()) {
                    String string = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.guicommons.stylepicker.deleteStyle");
                    String string2 = MessageFormat.format(ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.guicommons.stylepicker.confirmDelete"), StyleOption.this._rightClickTheme.getName());
                    String string3 = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.yes");
                    String string4 = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.no");
                    ModalOptionDialog.SelectedModalOptionDialogOption selectedModalOptionDialogOption = ModalOptionDialog.showAcceptCancelDialog((Frame)MainFrameUtilities.getMainFrame(), (String)string, (String)string2, (String)string3, (String)string4);
                    if (selectedModalOptionDialogOption == ModalOptionDialog.SelectedModalOptionDialogOption.ACCEPT) {
                        ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.theme.actions.RemoveThemeByIdAction", new Object[]{StyleOption.this._rightClickTheme.getUUID().toString()});
                    }
                }
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(this._remove);
        return jPopupMenu;
    }
}

