/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.ui.sidepanels.impl;

import com.thinkbuzan.gaia.ui.sidepanels.IPanelHandler;
import com.thinkbuzan.gaia.ui.sidepanels.ISidePanel;
import com.thinkbuzan.gaia.ui.sidepanels.ISidePanelManagerListener;
import com.thinkbuzan.gaia.ui.sidepanels.ISidePanelsChangedListener;
import com.thinkbuzan.gaia.ui.sidepanels.SidePanelManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SidePanelManagerImpl
implements SidePanelManager {
    private static final Logger LOGGER = Logger.getLogger((String)SidePanelManagerImpl.class.getName());
    private final transient List<ISidePanelManagerListener> listeners = new CopyOnWriteArrayList<ISidePanelManagerListener>();
    private final transient List<ISidePanelsChangedListener> regListeners = new CopyOnWriteArrayList<ISidePanelsChangedListener>();
    private final transient Map<String, ISidePanel> sidePanels;
    private transient IPanelHandler panelHandler;
    private transient String visiblePanelId;

    public SidePanelManagerImpl() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Creating a new instance of SidePanelManager");
        }
        this.sidePanels = new HashMap<String, ISidePanel>();
    }

    public List<ISidePanel> getAllPanels() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"getAllPanels Called ");
        }
        LinkedList<ISidePanel> result = new LinkedList<ISidePanel>();
        result.addAll(this.getOrderedPanels());
        return Collections.unmodifiableList(result);
    }

    private List<ISidePanel> getOrderedPanels() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"getPanelIdMapping Called ");
        }
        ArrayList<ISidePanel> mapping = new ArrayList<ISidePanel>();
        for (String key : this.sidePanels.keySet()) {
            if (mapping.contains(this.sidePanels.get(key))) continue;
            mapping.add(this.sidePanels.get(key));
        }
        return mapping;
    }

    public ISidePanel getPanel(String panelID) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getPanel called, id: " + panelID));
        }
        return this.sidePanels.get(panelID);
    }

    public void register(ISidePanel sidePanel) {
        if (sidePanel == null) {
            throw new IllegalArgumentException("param sidePanel cant be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("registerPanel called with id: " + sidePanel));
        }
        if (sidePanel.getID() == null || "".equals(sidePanel.getID().trim())) {
            throw new IllegalArgumentException("Wrong panel id given for a side panel: " + sidePanel);
        }
        Set<String> keys = this.sidePanels.keySet();
        if (keys.contains(sidePanel.getID())) {
            throw new IllegalArgumentException("Panel with same id cant be added twice");
        }
        this.sidePanels.put(sidePanel.getID(), sidePanel);
        for (ISidePanelsChangedListener listener : this.regListeners) {
            listener.sidePanelRegistered(sidePanel);
        }
    }

    public void unregister(ISidePanel sidePanel) {
        if (sidePanel == null) {
            throw new IllegalArgumentException("param sidePanel cant be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("registerPanel called, sidePanel: " + sidePanel));
        }
        this.sidePanels.remove(sidePanel.getID());
    }

    public void registerHandler(IPanelHandler panelHandlerIn) {
        this.validateRegisterHandler(panelHandlerIn);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("registerHandler called, sidePanel:  " + panelHandlerIn));
        }
        this.panelHandler = panelHandlerIn;
    }

    private void validateRegisterHandler(IPanelHandler panelHandlerIn) {
        if (panelHandlerIn == null) {
            throw new IllegalArgumentException("param panelHandlerIn cant be null");
        }
        if (this.panelHandler != null) {
            throw new IllegalArgumentException("Having two panel handlers at same time is not allowed");
        }
    }

    public void showPanel(String panelId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("showPanelCalled called, id: " + panelId));
        }
        ISidePanel result = null;
        if (panelId != null && (result = this.sidePanels.get(panelId)) == null) {
            throw new IllegalArgumentException("Panel with given id not found " + panelId);
        }
        if (this.panelHandler == null) {
            throw new IllegalArgumentException("No panel handler registered");
        }
        this.panelHandler.showPanel(result);
    }

    public void setVisibleSidePanelId(String panelId) {
        if (LOGGER.isDebugEnabled()) {
            String message = "entering setVisibleSidePanelId(panelId=%s) visiblePanelId=%s listeners.size()=%s";
            LOGGER.debug((Object)String.format("entering setVisibleSidePanelId(panelId=%s) visiblePanelId=%s listeners.size()=%s", panelId, this.visiblePanelId, this.listeners.size()));
        }
        if (panelId == null ? this.visiblePanelId == null : panelId.equals(this.visiblePanelId)) {
            return;
        }
        this.visiblePanelId = panelId;
        for (ISidePanelManagerListener listener : this.listeners) {
            try {
                listener.visibleSidePanelIdChanged(this.visiblePanelId);
            }
            catch (Exception exception) {
                LOGGER.error((Object)"Caught Exception when notifying ISidePanelManagerListener", (Throwable)exception);
            }
        }
    }

    public String getVisibleSidePanelId() {
        return this.visiblePanelId;
    }

    public void addListener(ISidePanelManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("addListener(listener=%s)", listener));
        }
        this.listeners.add(listener);
    }

    public void removeListener(ISidePanelManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("removeListener(listener=%s)", listener));
        }
        this.listeners.remove(listener);
    }

    public void addSidePanelsChangedListener(ISidePanelsChangedListener listener) {
        if (listener != null) {
            this.regListeners.add(listener);
        }
    }

    public void removeSidePanelsChangedListener(ISidePanelsChangedListener listener) {
        if (listener != null) {
            this.regListeners.remove(listener);
        }
    }
}

