/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.ui.sidepanels.iconlibrary.v2.factory;

import com.buzanonline.chaos.preferences.Preferences;
import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.gaia.iconlibrary.controller.IIconController;
import com.thinkbuzan.gaia.iconlibrary.datamodel.Category;
import com.thinkbuzan.gaia.ui.sidepanels.iconlibrary.v2.ILibraryPanel;
import com.thinkbuzan.gaia.ui.sidepanels.iconlibrary.v2.mac.MacIconLibraryPanel;
import com.thinkbuzan.gaia.ui.sidepanels.iconlibrary.v2.mac.MacIconPanel;
import com.thinkbuzan.gaia.ui.sidepanels.iconlibrary.v2.windows.AbstractHeadingPanel;
import com.thinkbuzan.gaia.ui.sidepanels.iconlibrary.v2.windows.HeadingPanel;
import com.thinkbuzan.gaia.ui.sidepanels.iconlibrary.v2.windows.ProjectIconsNoticeDialog;
import com.thinkbuzan.gaia.ui.sidepanels.iconlibrary.v2.windows.WindowsIconLibraryPanel;
import com.thinkbuzan.gaia.ui.sidepanels.iconlibrary.v2.windows.WindowsIconPanel;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public final class UIFactory {
    public static boolean a;

    private UIFactory() {
    }

    public static JLabel createJLabel() {
        return UIFactory.createJLabel("", 0);
    }

    public static JLabel createJLabel(String string) {
        return UIFactory.createJLabel(string, 0);
    }

    public static JLabel createJLabel(String string, int n) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(ApplicationFont.getRegularFont((int)n, (float)12.0f));
        return jLabel;
    }

    public static AbstractHeadingPanel createHeadingPanel(Category category) {
        return new HeadingPanel(category);
    }

    public static JPanel createIconsPanel(IIconController iIconController, Category category) {
        if (SystemInfo.isAnyMac()) {
            return new MacIconPanel(iIconController, category);
        }
        return new WindowsIconPanel(iIconController, category);
    }

    public static JScrollPane createIconsMac(IIconController iIconController, Category category) {
        if (SystemInfo.isAnyMac()) {
            JScrollPane jScrollPane = new JScrollPane(new MacIconPanel(iIconController, category));
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setVerticalScrollBarPolicy(20);
            return jScrollPane;
        }
        return new JScrollPane(new WindowsIconPanel(iIconController, category));
    }

    public static ILibraryPanel createIconLibraryPanel(IIconController iIconController) {
        if (SystemInfo.isAnyMac()) {
            return new MacIconLibraryPanel(iIconController);
        }
        return new WindowsIconLibraryPanel(iIconController, true);
    }

    public static JDialog createProjectIconsNoticeDialog(Frame frame, Preferences preferences) {
        return new ProjectIconsNoticeDialog(frame, preferences);
    }
}

