/*
 * Decompiled with CFR 0.152.
 */
package com.buzanonline.chaos.preferences.config;

import com.buzanonline.chaos.preferences.Preferences;
import com.buzanonline.chaos.preferences.PreferencesService;
import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class PreferenceLoader
implements ManagedService {
    private static final Logger LOGGER = Logger.getLogger(PreferenceLoader.class);
    private static final String DEFAULT_SAVE_LOCATION = "com.thinkbuzan.gaia.save.defaultlocation";
    private final transient PreferencesService service;
    private final transient Preferences systemPrefs;

    public PreferenceLoader(PreferencesService serviceIn) {
        this.service = serviceIn;
        this.systemPrefs = this.service.getSystemPreferences();
    }

    public final void updated(Dictionary dict) throws ConfigurationException {
        LOGGER.debug((Object)"Got preferences from managed service");
        if (dict != null) {
            Enumeration keys = dict.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)dict.get(key);
                if (DEFAULT_SAVE_LOCATION.equals(key)) {
                    this.service.getCurrentUserPreferences().put(key, value);
                    LOGGER.debug((Object)("Added User preference: [" + key + "] [" + value + "] from managed service"));
                    continue;
                }
                this.systemPrefs.put(key, value);
                LOGGER.debug((Object)("Added System preference: [" + key + "] [" + value + "] from managed service"));
            }
        }
    }
}

