/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.prefs;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSet {
    protected boolean hasChanges = false;
    protected final Set<String> changedProperties = new HashSet<String>();
    protected final Set<String> removedProperties = new HashSet<String>();
    protected final Set<String> addedChildren = new HashSet<String>();
    protected final Set<String> removedChildren = new HashSet<String>();

    public boolean hasChanges() {
        return this.hasChanges;
    }

    public void propertyChanged(String name) {
        this.hasChanges = true;
        this.removedProperties.remove(name);
        this.changedProperties.add(name);
    }

    public void propertyRemoved(String name) {
        this.hasChanges = true;
        this.changedProperties.remove(name);
        this.removedProperties.add(name);
    }

    public void childAdded(String name) {
        this.hasChanges = true;
        this.removedChildren.remove(name);
        this.addedChildren.add(name);
    }

    public void childRemoved(String name) {
        this.hasChanges = true;
        this.addedChildren.remove(name);
        this.removedChildren.add(name);
    }

    public void clear() {
        this.hasChanges = false;
        this.removedChildren.clear();
        this.removedProperties.clear();
        this.addedChildren.clear();
        this.changedProperties.clear();
    }

    public void importChanges(ChangeSet other) {
        if (other.hasChanges) {
            this.hasChanges = true;
            this.addedChildren.addAll(other.addedChildren);
            this.removedChildren.addAll(other.removedChildren);
            this.changedProperties.addAll(other.changedProperties);
            this.removedProperties.addAll(other.removedProperties);
        }
    }

    public Collection<String> getChangedProperties() {
        return Collections.unmodifiableCollection(this.changedProperties);
    }

    public Collection<String> getRemovedProperties() {
        return Collections.unmodifiableCollection(this.removedProperties);
    }

    public Collection<String> getAddedChildren() {
        return Collections.unmodifiableCollection(this.addedChildren);
    }

    public Collection<String> getRemovedChildren() {
        return Collections.unmodifiableCollection(this.removedChildren);
    }
}

