/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.prefs;

import com.buzanonline.chaos.preferences.Preferences;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.felix.prefs.BackingStoreManager;
import org.apache.felix.prefs.ChangeSet;
import org.apache.felix.prefs.PreferencesDescription;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesImpl
implements Preferences {
    private static final Logger LOGGER = Logger.getLogger(PreferencesImpl.class);
    private PropertyChangeSupport changeSupport;
    protected final Map<Object, Object> properties = new HashMap<Object, Object>();
    protected final Map<Object, Object> defaults = new HashMap<Object, Object>();
    protected final Map<Object, Object> defaultSet = new HashMap<Object, Object>();
    protected boolean valid = true;
    protected final PreferencesImpl parent;
    protected final Map<Object, Object> children = new HashMap<Object, Object>();
    protected final String name;
    protected final PreferencesDescription description;
    protected final BackingStoreManager storeManager;
    protected final ChangeSet changeSet = new ChangeSet();

    public PreferencesImpl(PreferencesDescription d, BackingStoreManager storeManagerIn) {
        this.parent = null;
        this.name = "";
        this.description = d;
        this.storeManager = storeManagerIn;
    }

    public PreferencesImpl(PreferencesImpl p, String nameIn) {
        this.parent = p;
        this.name = nameIn;
        this.description = p.description;
        this.storeManager = p.storeManager;
    }

    public final ChangeSet getChangeSet() {
        return this.changeSet;
    }

    public final PreferencesDescription getDescription() {
        return this.description;
    }

    public final PreferencesImpl getRoot() {
        PreferencesImpl root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        return root;
    }

    public final Collection<Object> getChildren() {
        return this.children.values();
    }

    public final Map<Object, Object> getProperties() {
        return this.properties;
    }

    public final Map<Object, Object> getDefaults() {
        return this.defaults;
    }

    public final Map<Object, Object> getDefaultSet() {
        return this.defaultSet;
    }

    public final BackingStoreManager getBackingStoreManager() {
        return this.storeManager;
    }

    protected final void checkValidity() throws IllegalStateException {
        if (!this.valid) {
            throw new IllegalStateException("The preferences node has been removed.");
        }
    }

    protected final void checkKey(String key) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
    }

    protected final void checkValue(Object value) throws NullPointerException {
        if (value == null) {
            throw new NullPointerException("Value must not be null.");
        }
    }

    public final synchronized boolean isValid() {
        return this.valid;
    }

    public final synchronized void put(String key, String value) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("put(key=%s, value=%s)", key, value));
        }
        this.checkKey(key);
        this.checkValue(value);
        this.checkValidity();
        Object oldValue = this.properties.get(key);
        this.properties.put(key, value);
        this.setDefault(key, value);
        this.changeSet.propertyChanged(key);
        try {
            this.flush();
        }
        catch (BackingStoreException ex) {
            LOGGER.log((Priority)Level.WARN, (Object)("Could not flush preference key: " + key + " value: " + value + " to backing store."), (Throwable)ex);
        }
        this.firePropertyChange(key, oldValue, value);
    }

    public final synchronized String get(String key, String def) {
        this.checkValidity();
        String value = (String)this.properties.get(key);
        if (value == null) {
            value = def;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("get(key=%s, default=%s) returning %s", key, def, value));
        }
        return value;
    }

    public final synchronized void remove(String key) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("remove(key=%s)", key));
        }
        this.checkKey(key);
        this.checkValidity();
        Object oldValue = this.properties.get(key);
        this.properties.remove(key);
        this.defaults.remove(key);
        this.defaultSet.remove(key);
        this.changeSet.propertyRemoved(key);
        this.firePropertyChange(key, oldValue, null);
    }

    public final synchronized void clear() throws BackingStoreException {
        this.checkValidity();
        for (String string : this.properties.keySet()) {
            this.changeSet.propertyRemoved(string);
            Object oldValue = this.properties.get(string);
            this.firePropertyChange(string, oldValue, null);
        }
        this.properties.clear();
        this.defaults.clear();
        this.defaultSet.clear();
    }

    public final void putInt(String key, int value) {
        this.put(key, String.valueOf(value));
    }

    public final int getInt(String key, int def) {
        int result = def;
        String value = this.get(key, null);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    public final void putLong(String key, long value) {
        this.put(key, String.valueOf(value));
    }

    public final long getLong(String key, long def) {
        long result = def;
        String value = this.get(key, null);
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    public final void putBoolean(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    public final boolean getBoolean(String key, boolean def) {
        boolean result = def;
        String value = this.get(key, null);
        if (value != null) {
            if (value.equalsIgnoreCase("true")) {
                result = true;
            } else if (value.equalsIgnoreCase("false")) {
                result = false;
            }
        }
        return result;
    }

    public final void putFloat(String key, float value) {
        this.put(key, String.valueOf(value));
    }

    public final float getFloat(String key, float def) {
        float result = def;
        String value = this.get(key, null);
        if (value != null) {
            try {
                result = Float.parseFloat(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    public final void putDouble(String key, double value) {
        this.put(key, String.valueOf(value));
    }

    public final double getDouble(String key, double def) {
        double result = def;
        String value = this.get(key, null);
        if (value != null) {
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    public final void putByteArray(String key, byte[] value) {
        this.checkKey(key);
        this.checkValue(value);
        try {
            this.put(key, new String(Base64.encodeBase64((byte[])value), "utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public final byte[] getByteArray(String key, byte[] def) {
        byte[] result = def;
        String value = this.get(key, null);
        if (value != null) {
            try {
                result = Base64.decodeBase64((byte[])value.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    public final synchronized String[] keys() throws BackingStoreException {
        this.sync();
        Set<Object> keys = this.properties.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public final synchronized String[] childrenNames() throws BackingStoreException {
        this.sync();
        Set<Object> names = this.children.keySet();
        return names.toArray(new String[names.size()]);
    }

    public final Preferences parent() {
        this.checkValidity();
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Preferences node(String pathName) {
        String workingPath = pathName;
        if (workingPath == null) {
            throw new NullPointerException("Path must not be null.");
        }
        PreferencesImpl executingNode = this;
        PreferencesImpl preferencesImpl = this;
        synchronized (preferencesImpl) {
            this.checkValidity();
            if (workingPath.length() == 0) {
                return this;
            }
            if (workingPath.startsWith("/") && this.parent != null) {
                executingNode = this.getRoot();
            }
            if (workingPath.startsWith("/")) {
                workingPath = workingPath.substring(1);
            }
        }
        return executingNode.getNode(workingPath, true, true);
    }

    public final PreferencesImpl getOrCreateNode(String pathName) {
        String workingPath = pathName;
        if (workingPath == null) {
            throw new NullPointerException("Path must not be null.");
        }
        PreferencesImpl executingNode = this;
        if (workingPath.length() == 0) {
            return this;
        }
        if (workingPath.startsWith("/") && this.parent != null) {
            executingNode = this.getRoot();
        }
        if (workingPath.startsWith("/")) {
            workingPath = workingPath.substring(1);
        }
        return executingNode.getNode(workingPath, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final PreferencesImpl getNode(String path, boolean saveNewlyCreatedNode, boolean create) {
        String workingPath = path;
        boolean saveNewNode = saveNewlyCreatedNode;
        if (workingPath.startsWith("/")) {
            throw new IllegalArgumentException("Path must not contained consecutive slashes");
        }
        if (workingPath.length() == 0) {
            return this;
        }
        PreferencesImpl preferencesImpl = this;
        synchronized (preferencesImpl) {
            this.checkValidity();
            String subPath = null;
            int pos = workingPath.indexOf(47);
            if (pos != -1) {
                subPath = workingPath.substring(pos + 1);
                workingPath = workingPath.substring(0, pos);
            }
            boolean save = false;
            PreferencesImpl child = (PreferencesImpl)this.children.get(workingPath);
            if (child == null) {
                if (!create) {
                    return null;
                }
                child = new PreferencesImpl(this, workingPath);
                this.children.put(workingPath, child);
                this.changeSet.childAdded(workingPath);
                if (saveNewNode) {
                    save = true;
                }
                saveNewNode = false;
            }
            PreferencesImpl result = subPath == null ? child : child.getNode(subPath, saveNewNode, create);
            if (save) {
                try {
                    result.flush();
                }
                catch (BackingStoreException ex) {
                    LOGGER.log((Priority)Level.WARN, (Object)"Could not flush new node to backing store.", (Throwable)ex);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean nodeExists(String pathName) throws BackingStoreException {
        String workingPath = pathName;
        if (workingPath == null) {
            throw new NullPointerException("Path must not be null.");
        }
        if (workingPath.length() == 0) {
            return this.valid;
        }
        PreferencesImpl node = this;
        PreferencesImpl preferencesImpl = this;
        synchronized (preferencesImpl) {
            this.checkValidity();
            if (workingPath.startsWith("/") && this.parent != null) {
                node = this.getRoot();
            }
            if (workingPath.startsWith("/")) {
                workingPath = workingPath.substring(1);
            }
        }
        PreferencesImpl searchNode = node.getNode(workingPath, false, false);
        return searchNode != null;
    }

    public final void removeNode() throws BackingStoreException {
        this.checkValidity();
        this.safelyRemoveNode();
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void safelyRemoveNode() {
        if (this.valid) {
            ArrayList<Object> c = null;
            PreferencesImpl preferencesImpl = this;
            synchronized (preferencesImpl) {
                this.valid = false;
                this.properties.clear();
                this.defaults.clear();
                this.defaultSet.clear();
                c = new ArrayList<Object>(this.children.values());
                this.children.clear();
            }
            for (PreferencesImpl preferencesImpl2 : c) {
                preferencesImpl2.safelyRemoveNode();
            }
        }
    }

    protected final synchronized void removeChild(PreferencesImpl child) {
        this.children.remove(child.name());
        this.changeSet.childRemoved(child.name());
    }

    public final String name() {
        return this.name;
    }

    public final String absolutePath() {
        if (this.parent == null) {
            return "/";
        }
        String parentPath = this.parent.absolutePath();
        if (parentPath.length() == 1) {
            return parentPath + this.name;
        }
        return parentPath + '/' + this.name;
    }

    public final synchronized void flush() throws BackingStoreException {
        this.checkValidity();
        try {
            this.storeManager.getStore().store(this);
        }
        catch (IOException ioEx) {
            throw new BackingStoreException("Problem flushing preferences", (Throwable)ioEx);
        }
        finally {
            this.changeSet.clear();
        }
    }

    public final synchronized void sync() throws BackingStoreException {
        this.checkValidity();
        try {
            this.storeManager.getStore().update(this);
            this.storeManager.getStore().store(this);
        }
        catch (IOException ioEx) {
            throw new BackingStoreException("Problem syncing preferences", (Throwable)ioEx);
        }
    }

    public final void update(PreferencesImpl impl) {
        for (Map.Entry<Object, Object> entry : impl.properties.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.properties.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : impl.defaults.entrySet()) {
            if (this.defaults.containsKey(entry.getKey())) continue;
            this.defaults.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : impl.defaultSet.entrySet()) {
            if (this.defaultSet.containsKey(entry.getKey())) continue;
            this.defaultSet.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : impl.children.entrySet()) {
            String name = entry.getKey().toString();
            PreferencesImpl child = (PreferencesImpl)entry.getValue();
            if (!this.children.containsKey(name)) {
                this.node(name);
            }
            ((PreferencesImpl)this.children.get(name)).update(child);
        }
    }

    public final void applyChanges(PreferencesImpl prefs) {
        ChangeSet changeSet = prefs.getChangeSet();
        if (changeSet.hasChanges) {
            this.changeSet.importChanges(prefs.changeSet);
            for (String string : changeSet.removedProperties) {
                this.properties.remove(string);
                this.defaults.remove(string);
                this.defaultSet.remove(string);
            }
            for (String string : changeSet.changedProperties) {
                this.properties.put(string, prefs.properties.get(string));
                this.defaults.put(string, prefs.defaults.get(string));
                this.defaultSet.put(string, prefs.defaultSet.get(string));
            }
            for (String string : changeSet.removedChildren) {
                this.children.remove(string);
            }
        }
        for (PreferencesImpl preferencesImpl : prefs.getChildren()) {
            PreferencesImpl child = this.getOrCreateNode(preferencesImpl.name());
            child.applyChanges(preferencesImpl);
        }
    }

    @Override
    public final boolean isDefaultSet(String key) {
        Object defaultSetCheck = this.defaultSet.get(key);
        if (null == defaultSetCheck) {
            return false;
        }
        return Boolean.valueOf(defaultSetCheck.toString());
    }

    @Override
    public final String getDefault(String key) {
        this.checkValidity();
        return (String)this.defaults.get(key);
    }

    @Override
    public final boolean getDefaultBoolean(String key) {
        boolean result = false;
        String value = this.getDefault(key);
        if (value != null) {
            if (value.equalsIgnoreCase("true")) {
                result = true;
            } else if (value.equalsIgnoreCase("false")) {
                result = false;
            }
        }
        return result;
    }

    @Override
    public final byte[] getDefaultByteArray(String key) {
        byte[] result = null;
        String value = this.getDefault(key);
        if (value != null) {
            try {
                result = Base64.decodeBase64((byte[])value.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public final double getDefaultDouble(String key) {
        double result = 0.0;
        String value = this.getDefault(key);
        if (value != null) {
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public final float getDefaultFloat(String key) {
        float result = 0.0f;
        String value = this.getDefault(key);
        if (value != null) {
            try {
                result = Float.parseFloat(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public final int getDefaultInt(String key) {
        int result = 0;
        String value = this.getDefault(key);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public final long getDefaultLong(String key) {
        long result = 0L;
        String value = this.getDefault(key);
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    private void setDefault(String key, Object def) {
        if (!this.isDefaultSet(key)) {
            this.defaults.put(key, def);
            this.defaultSet.put(key, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        PreferencesImpl preferencesImpl = this;
        synchronized (preferencesImpl) {
            if (listener == null) {
                return;
            }
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
            this.changeSupport.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        PreferencesImpl preferencesImpl = this;
        synchronized (preferencesImpl) {
            if (listener == null || this.changeSupport == null) {
                return;
            }
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PreferencesImpl preferencesImpl = this;
        synchronized (preferencesImpl) {
            if (listener == null) {
                return;
            }
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
            this.changeSupport.addPropertyChangeListener(propertyName, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PreferencesImpl preferencesImpl = this;
        synchronized (preferencesImpl) {
            if (listener == null || this.changeSupport == null) {
                return;
            }
            this.changeSupport.removePropertyChangeListener(propertyName, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeSupport achangeSupport;
        PreferencesImpl preferencesImpl = this;
        synchronized (preferencesImpl) {
            achangeSupport = this.changeSupport;
        }
        if (achangeSupport == null || oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        achangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

