/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.prefs.impl;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import org.apache.felix.prefs.BackingStoreManager;
import org.apache.felix.prefs.PreferencesDescription;
import org.apache.felix.prefs.PreferencesImpl;
import org.apache.felix.prefs.impl.StreamBackingStoreImpl;
import org.apache.log4j.Logger;
import org.osgi.service.prefs.BackingStoreException;

public class DataFileBackingStoreImpl
extends StreamBackingStoreImpl {
    private final transient File rootDirectory;
    private static final String SER_EXTENSION = ".ser";
    private static final Logger LOGGER = Logger.getLogger(DataFileBackingStoreImpl.class);

    public DataFileBackingStoreImpl(File rootDirectoryIn) {
        this.rootDirectory = rootDirectoryIn;
    }

    private File getRootDirectory() {
        boolean result;
        if (!this.rootDirectory.exists() && !(result = this.rootDirectory.mkdirs())) {
            throw new IllegalStateException("Could not create preferences directory");
        }
        return this.rootDirectory;
    }

    protected final void checkAccess() throws BackingStoreException {
        if (this.getRootDirectory() == null) {
            throw new BackingStoreException("Saving of data files to the bundle context is currently not supported.");
        }
    }

    protected final OutputStream getOutputStream(PreferencesDescription desc) throws IOException {
        File file = this.getFile(desc);
        return new FileOutputStream(file);
    }

    protected final PreferencesDescription getDescription(File file) {
        String fileName = file.getName();
        if (fileName.startsWith("Preferences") && fileName.endsWith(SER_EXTENSION)) {
            String name = fileName.substring(1, fileName.length() - SER_EXTENSION.length());
            int pos = name.indexOf(95);
            String identifier = pos == -1 ? null : name.substring(pos + 1);
            return new PreferencesDescription(identifier);
        }
        return null;
    }

    public final PreferencesImpl[] loadAll(BackingStoreManager manager) throws BackingStoreException, IOException {
        this.checkAccess();
        ArrayList<PreferencesImpl> list = new ArrayList<PreferencesImpl>();
        File[] children = this.getRootDirectory().listFiles();
        for (int i = 0; i < children.length; ++i) {
            File current = children[i];
            PreferencesDescription desc = this.getDescription(current);
            if (desc == null) continue;
            PreferencesImpl root = new PreferencesImpl(desc, manager);
            this.readFromPreferences(root, current);
            list.add(root);
        }
        return list.toArray(new PreferencesImpl[list.size()]);
    }

    public final PreferencesImpl load(BackingStoreManager manager, PreferencesDescription desc) throws BackingStoreException, IOException {
        this.checkAccess();
        File file = this.getFile(desc);
        if (file.exists()) {
            PreferencesImpl root = new PreferencesImpl(desc, manager);
            this.readFromPreferences(root, file);
            return root;
        }
        return null;
    }

    private void readFromPreferences(PreferencesImpl root, File file) throws IOException {
        boolean deleteFile = false;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.read(root, fis);
        }
        catch (StreamCorruptedException ex) {
            deleteFile = true;
            throw ex;
        }
        catch (EOFException ex) {
            deleteFile = true;
            throw ex;
        }
        finally {
            this.closeInputStream(fis);
            if (deleteFile) {
                LOGGER.warn((Object)("Removing corrupt preferences file " + file.getName() + " so it can be re-created"));
                file.delete();
            }
        }
    }

    private void closeInputStream(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException ex) {
            LOGGER.warn((Object)"Problem when closing stream ", (Throwable)ex);
        }
    }

    protected final File getFile(PreferencesDescription desc) {
        StringBuffer buffer = new StringBuffer("Preferences");
        if (desc.getIdentifier() != null) {
            buffer.append('_');
            buffer.append(desc.getIdentifier());
        }
        buffer.append(SER_EXTENSION);
        return new File(this.getRootDirectory(), buffer.toString());
    }
}

