/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.prefs.impl;

import com.buzanonline.chaos.fileaccessservice.FileAccessService;
import com.buzanonline.chaos.preferences.PreferencesService;
import com.buzanonline.chaos.preferences.config.PreferenceLoader;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.prefs.BackingStore;
import org.apache.felix.prefs.BackingStoreManager;
import org.apache.felix.prefs.PreferencesImpl;
import org.apache.felix.prefs.impl.DataFileBackingStoreImpl;
import org.apache.felix.prefs.impl.PreferencesServiceImpl;
import org.apache.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesManager
implements BundleActivator {
    private transient BackingStore backingStore;
    private transient PreferencesServiceImpl preferencesServiceImpl;
    private static final transient Logger LOGGER = Logger.getLogger(PreferencesManager.class);
    private static final transient String PREFERENCES_DIRECTORY = "Preferences";

    public final void start(BundleContext context) throws Exception {
        OSGiService fileAccessService = new OSGiService(context, FileAccessService.class);
        File rootDirectory = this.getRootDirectory((OSGiService<FileAccessService>)fileAccessService, context);
        this.backingStore = new DataFileBackingStoreImpl(rootDirectory);
        BackingStoreManager backingStoreManager = this.createBackingStoreManager();
        this.preferencesServiceImpl = new PreferencesServiceImpl(backingStoreManager);
        this.registerManagedService(context, this.preferencesServiceImpl);
        context.registerService(PreferencesService.class.getName(), (Object)this.preferencesServiceImpl, null);
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        ((Dictionary)dictionary).put("version", "imm9");
        context.registerService(PreferencesService.class.getName(), (Object)new PreferenceVersionServiceFactory((FileAccessService)fileAccessService.get(), "imindmap_cache9"), dictionary);
        Hashtable<String, String> dictionary8 = new Hashtable<String, String>();
        ((Dictionary)dictionary8).put("version", "imm8");
        context.registerService(PreferencesService.class.getName(), (Object)new PreferenceVersionServiceFactory((FileAccessService)fileAccessService.get(), "imindmap_cache8"), dictionary8);
        Hashtable<String, String> dictionary7 = new Hashtable<String, String>();
        ((Dictionary)dictionary7).put("version", "imm7");
        context.registerService(PreferencesService.class.getName(), (Object)new PreferenceVersionServiceFactory((FileAccessService)fileAccessService.get(), "imindmap_cache7"), dictionary7);
        Hashtable<String, String> dictionary6 = new Hashtable<String, String>();
        ((Dictionary)dictionary6).put("version", "imm6");
        context.registerService(PreferencesService.class.getName(), (Object)new PreferenceVersionServiceFactory((FileAccessService)fileAccessService.get(), "imindmap_cache6"), dictionary6);
        Hashtable<String, String> dictionary5 = new Hashtable<String, String>();
        ((Dictionary)dictionary5).put("version", "imm5");
        context.registerService(PreferencesService.class.getName(), (Object)new PreferenceVersionServiceFactory((FileAccessService)fileAccessService.get(), "imindmap_cache"), dictionary5);
    }

    private void registerManagedService(BundleContext context, PreferencesService preferencesService) {
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        ((Dictionary)dictionary).put("service.pid", PreferencesService.class.getPackage().getName());
        context.registerService(ManagedService.class.getName(), (Object)new PreferenceLoader(preferencesService), dictionary);
    }

    private File getRootDirectory(OSGiService<FileAccessService> fileAccessService, BundleContext context) {
        File rootDirectory = ((FileAccessService)fileAccessService.get()).getSharedFile(PREFERENCES_DIRECTORY);
        if (!rootDirectory.exists() && !rootDirectory.mkdirs()) {
            rootDirectory = context.getDataFile("");
        }
        return rootDirectory;
    }

    private BackingStoreManager createBackingStoreManager() {
        return new BackingStoreManager(){

            public BackingStore getStore() {
                return PreferencesManager.this.backingStore;
            }
        };
    }

    public final void stop(BundleContext context) throws Exception {
        this.save(this.preferencesServiceImpl);
    }

    protected final void save(PreferencesServiceImpl service) {
        for (PreferencesImpl prefs : service.getAllPreferences()) {
            try {
                this.backingStore.store(prefs);
            }
            catch (BackingStoreException ignore) {
                LOGGER.info((Object)"Caught BackingStoreException", (Throwable)ignore);
            }
            catch (IOException ioEx) {
                LOGGER.info((Object)"Caught IOException", (Throwable)ioEx);
            }
        }
    }

    private static class PreferenceVersionServiceFactory
    implements ServiceFactory {
        private final transient FileAccessService fileAccessService;
        private final transient String prefsFolder;

        public PreferenceVersionServiceFactory(FileAccessService fileAccessServiceIn, String prefsFolderIn) {
            this.fileAccessService = fileAccessServiceIn;
            this.prefsFolder = prefsFolderIn;
        }

        public Object getService(Bundle arg0, ServiceRegistration arg1) {
            File base = new File(this.fileAccessService.getSharedFile("tmp").getParentFile().getParentFile(), this.prefsFolder);
            File imm5prefs = new File(base, PreferencesManager.PREFERENCES_DIRECTORY);
            if (imm5prefs.exists()) {
                final DataFileBackingStoreImpl store = new DataFileBackingStoreImpl(imm5prefs);
                BackingStoreManager backingStoreManager = new BackingStoreManager(){

                    public BackingStore getStore() {
                        return store;
                    }
                };
                return new PreferencesServiceImpl(backingStoreManager);
            }
            return null;
        }

        public void ungetService(Bundle arg0, ServiceRegistration arg1, Object arg2) {
        }
    }
}

