/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.prefs.impl;

import com.buzanonline.chaos.preferences.Preferences;
import com.buzanonline.chaos.preferences.PreferencesService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.prefs.BackingStoreManager;
import org.apache.felix.prefs.PreferencesDescription;
import org.apache.felix.prefs.PreferencesImpl;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesServiceImpl
implements PreferencesService {
    private static final Logger LOGGER = Logger.getLogger((String)"com.buzanonline.chaos.preferences");
    protected PreferencesImpl systemTree;
    protected final Map<String, PreferencesImpl> trees = new HashMap<String, PreferencesImpl>();
    protected final BackingStoreManager storeManager;
    private static final String HIDDEN_ROOT_NODE = "hidden";
    private static final String NON_HIDDEN_ROOT_NODE = "not_hidden";

    public PreferencesServiceImpl(BackingStoreManager storeManagerIn) {
        this.storeManager = storeManagerIn;
        try {
            PreferencesImpl[] prefs = null;
            prefs = this.storeManager.getStore().loadAll(storeManagerIn);
            for (int i = 0; i < prefs.length; ++i) {
                if (prefs[i].getDescription().getIdentifier() == null) {
                    this.systemTree = prefs[i];
                    continue;
                }
                this.trees.put(prefs[i].getDescription().getIdentifier(), prefs[i]);
            }
        }
        catch (BackingStoreException ex) {
            LOGGER.log((Priority)Level.WARN, (Object)"Problem with the backing store on preferences construction", (Throwable)ex);
        }
        catch (IOException ioEx) {
            LOGGER.log((Priority)Level.WARN, (Object)"Problem performing I/O on preferences file", (Throwable)ioEx);
        }
    }

    @Override
    public final synchronized Preferences getSystemPreferences() {
        this.initaliseSystemTree();
        return this.systemTree.node(NON_HIDDEN_ROOT_NODE);
    }

    @Override
    public final synchronized Preferences getHiddenSystemPreferences() {
        this.initaliseSystemTree();
        return this.systemTree.node(HIDDEN_ROOT_NODE);
    }

    private void initaliseSystemTree() {
        if (this.systemTree == null) {
            this.systemTree = new PreferencesImpl(new PreferencesDescription(null), this.storeManager);
        }
        try {
            this.systemTree.sync();
        }
        catch (BackingStoreException ex) {
            LOGGER.log((Priority)Level.WARN, (Object)"Problem with the backing store on system tree sync", (Throwable)ex);
        }
    }

    @Override
    public final synchronized Preferences getUserPreferences(String name) {
        PreferencesImpl result = this.getOrCreateUserPreferences(name);
        return result.node(NON_HIDDEN_ROOT_NODE);
    }

    @Override
    public final synchronized Preferences getHiddenUserPreferences(String name) {
        PreferencesImpl result = this.getOrCreateUserPreferences(name);
        return result.node(HIDDEN_ROOT_NODE);
    }

    private PreferencesImpl getOrCreateUserPreferences(String name) {
        PreferencesImpl result = this.trees.get(name);
        if (result == null || !result.isValid()) {
            result = new PreferencesImpl(new PreferencesDescription(name), this.storeManager);
            this.trees.put(name, result);
        }
        try {
            result.sync();
        }
        catch (BackingStoreException ex) {
            LOGGER.log((Priority)Level.WARN, (Object)"Problem with the backing store on user tree sync", (Throwable)ex);
        }
        return result;
    }

    @Override
    public final synchronized String[] getUsers() {
        Set<String> userKeys = this.trees.keySet();
        return userKeys.toArray(new String[userKeys.size()]);
    }

    protected final List<PreferencesImpl> getAllPreferences() {
        ArrayList<PreferencesImpl> list = new ArrayList<PreferencesImpl>();
        if (this.systemTree != null) {
            list.add(this.systemTree);
        }
        list.addAll(this.trees.values());
        return list;
    }

    @Override
    public final Preferences getCurrentUserPreferences() {
        String userName = this.getSystemPreferences().get("user.name", System.getProperty("user.name"));
        return this.getUserPreferences(userName);
    }

    @Override
    public final Preferences getCurrentUserHiddenPreferences() {
        String userName = this.getSystemPreferences().get("user.name", System.getProperty("user.name"));
        return this.getHiddenUserPreferences(userName);
    }
}

