/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.prefs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import org.apache.felix.prefs.BackingStore;
import org.apache.felix.prefs.PreferencesDescription;
import org.apache.felix.prefs.PreferencesImpl;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StreamBackingStoreImpl
implements BackingStore {
    protected abstract void checkAccess() throws BackingStoreException;

    protected abstract OutputStream getOutputStream(PreferencesDescription var1) throws IOException;

    @Override
    public final synchronized void store(PreferencesImpl prefs) throws BackingStoreException, IOException {
        if (!this.hasChanges(prefs)) {
            return;
        }
        this.checkAccess();
        PreferencesImpl savedData = this.load(prefs.getBackingStoreManager(), prefs.getDescription());
        if (savedData != null) {
            PreferencesImpl n = savedData.getOrCreateNode(prefs.absolutePath());
            n.applyChanges(prefs);
            prefs = n;
        }
        PreferencesImpl root = prefs.getRoot();
        try {
            OutputStream os = this.getOutputStream(root.getDescription());
            this.write(root, os);
            os.close();
        }
        catch (IOException ioe) {
            throw new BackingStoreException("Unable to store preferences.", (Throwable)ioe);
        }
    }

    protected final synchronized boolean hasChanges(PreferencesImpl prefs) {
        if (prefs.getChangeSet().hasChanges()) {
            return true;
        }
        for (PreferencesImpl preferencesImpl : prefs.getChildren()) {
            if (!this.hasChanges(preferencesImpl)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final synchronized void update(PreferencesImpl prefs) throws BackingStoreException, IOException {
        PreferencesImpl root = this.load(prefs.getBackingStoreManager(), prefs.getDescription());
        if (root != null && root.nodeExists(prefs.absolutePath())) {
            PreferencesImpl updated = (PreferencesImpl)root.node(prefs.absolutePath());
            prefs.update(updated);
        }
    }

    protected final synchronized void write(PreferencesImpl prefs, OutputStream os) throws IOException {
        this.writePreferences(prefs, os);
        ObjectOutputStream oos = new ObjectOutputStream(os);
        Collection<Object> children = prefs.getChildren();
        oos.writeInt(children.size());
        oos.flush();
        for (PreferencesImpl preferencesImpl : children) {
            byte[] name = preferencesImpl.name().getBytes("utf-8");
            oos.writeInt(name.length);
            oos.write(name);
            oos.flush();
            this.write(preferencesImpl, os);
        }
    }

    protected final synchronized void read(PreferencesImpl prefs, InputStream is) throws IOException {
        this.readPreferences(prefs, is);
        ObjectInputStream ois = new ObjectInputStream(is);
        int numberOfChilren = ois.readInt();
        for (int i = 0; i < numberOfChilren; ++i) {
            int length = ois.readInt();
            byte[] name = new byte[length];
            ois.readFully(name);
            PreferencesImpl impl = (PreferencesImpl)prefs.node(new String(name, "utf-8"));
            this.read(impl, is);
        }
    }

    protected final synchronized void readPreferences(PreferencesImpl prefs, InputStream in) throws IOException {
        ObjectInputStream ois = new ObjectInputStream(in);
        this.readIntoMap(prefs.getProperties(), ois);
        this.readIntoMap(prefs.getDefaults(), ois);
        this.readIntoMap(prefs.getDefaultSet(), ois);
    }

    private void readIntoMap(Map<Object, Object> map, ObjectInputStream ois) throws IOException {
        int size = ois.readInt();
        for (int i = 0; i < size; ++i) {
            int keyLength = ois.readInt();
            int valueLength = ois.readInt();
            byte[] key = new byte[keyLength];
            byte[] value = new byte[valueLength];
            ois.readFully(key);
            ois.readFully(value);
            map.put(new String(key, "utf-8"), new String(value, "utf-8"));
        }
    }

    protected final synchronized void writePreferences(PreferencesImpl prefs, OutputStream out) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(out);
        this.writeMapToStream(prefs.getProperties(), oos);
        this.writeMapToStream(prefs.getDefaults(), oos);
        this.writeMapToStream(prefs.getDefaultSet(), oos);
        oos.flush();
    }

    private void writeMapToStream(Map<Object, ?> map, ObjectOutputStream oos) throws IOException {
        int size = map.size();
        oos.writeInt(size);
        for (Map.Entry<Object, ?> entry : map.entrySet()) {
            byte[] key = entry.getKey().toString().getBytes("utf-8");
            byte[] value = entry.getValue().toString().getBytes("utf-8");
            oos.writeInt(key.length);
            oos.writeInt(value.length);
            oos.write(key);
            oos.write(value);
        }
    }
}

