/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities;

import com.thinkbuzan.gaia.entities.util.XMLUtils;
import com.thinkbuzan.gaia.model.properties.IProperty;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AudioNote
implements IProperty,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String description = "NONE";
    private UUID uid = UUID.randomUUID();
    private String codec = "NONE";
    private double duration = 0.0;
    public static final String AUDIONOTES_KEY = "com.thinkbuzan.gaia.cell.audionotes2";
    public static final double DURATION_UNKNOWN = -1.0;
    public static final String CODEC_WAV = "WAV";
    public static final String CODEC_GSM = "GSM";
    private static final String AUDIONOTES_TAG_NAME = "AudioNotes";
    private static final String AUDIONOTES_ID = "id";
    private static final String AUDIONOTES_DESC = "description";
    private static final String CODEC_ATTRIBUTE_NAME = "codec";
    private static final String DURATION_ATTRIBUTE_NAME = "duration";

    public final String getDescription() {
        return this.description;
    }

    public AudioNote(String descriptionIn, UUID uidIn) {
        if (descriptionIn == null || descriptionIn.trim().equals("")) {
            throw new IllegalArgumentException("The description should be not empty.");
        }
        if (uidIn == null) {
            throw new IllegalArgumentException("The UUID should be not null.");
        }
        this.description = descriptionIn;
        this.uid = uidIn;
    }

    public AudioNote() {
    }

    public final void setDescription(String descriptionIn) {
        if (descriptionIn == null || descriptionIn.trim().equals("")) {
            throw new IllegalArgumentException("The description should be not empty.");
        }
        this.description = descriptionIn;
    }

    public final UUID getUid() {
        return this.uid;
    }

    public final void setUid(UUID uidIn) {
        if (uidIn == null) {
            throw new IllegalArgumentException("The UUID should be not null.");
        }
        this.uid = uidIn;
    }

    public final void setCodec(String codecIn) {
        if (codecIn == null) {
            throw new IllegalArgumentException("codecIn must not be null");
        }
        this.codec = codecIn;
    }

    public final void setDuration(double durationIn) {
        this.duration = durationIn;
    }

    public final String getCodec() {
        return this.codec;
    }

    public final double getDuration() {
        return this.duration;
    }

    public final IProperty decode(Node node) {
        AudioNote audioNote = new AudioNote();
        audioNote.setDescription(XMLUtils.getContent(node, AUDIONOTES_DESC));
        audioNote.setUid(UUID.fromString(XMLUtils.getContent(node, AUDIONOTES_ID)));
        audioNote.setCodec(XMLUtils.getContent(node, CODEC_ATTRIBUTE_NAME));
        audioNote.setDuration(Double.parseDouble(XMLUtils.getContent(node, DURATION_ATTRIBUTE_NAME)));
        return audioNote;
    }

    public final Node encode(Document document) {
        Element element = document.createElement(AUDIONOTES_TAG_NAME);
        XMLUtils.appendElement(document, element, AUDIONOTES_ID, this.uid);
        XMLUtils.appendElement(document, element, AUDIONOTES_DESC, this.description);
        XMLUtils.appendElement(document, element, CODEC_ATTRIBUTE_NAME, this.codec);
        XMLUtils.appendElement(document, element, DURATION_ATTRIBUTE_NAME, this.duration);
        return element;
    }

    public final String getPropertyID() {
        return this.getClass().getName() + "2";
    }

    public final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof AudioNote)) {
            return false;
        }
        AudioNote otherAudioNote = (AudioNote)object;
        if (this.uid == otherAudioNote.uid) {
            return true;
        }
        if (this.uid == null) {
            return false;
        }
        return this.uid.equals(otherAudioNote.uid);
    }

    public final int hashCode() {
        int hashCode = 0;
        if (this.uid != null) {
            hashCode += this.uid.hashCode();
        }
        return hashCode;
    }
}

