/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities;

import com.thinkbuzan.gaia.entities.Tag;
import com.thinkbuzan.gaia.entities.TagsObject;
import com.thinkbuzan.gaia.entities.util.XMLUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Category
extends TagsObject {
    private static final long serialVersionUID = 7554542159436604409L;
    private static final String CATEGORY = "category";
    private static final String TAG_COUNT = "tagcount";
    private List<Tag> tags = new ArrayList<Tag>();

    public Category() {
        super("");
    }

    public Category(String nameIn) {
        super(nameIn);
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void addTag(Tag tag) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    public void removeTag(Tag tagToRemove) {
        for (Tag tag : this.tags) {
            if (!tag.equals(tagToRemove)) continue;
            this.tags.remove(tag);
            tag.setParentId("");
            break;
        }
    }

    public Node encode(Document document) {
        Element element = document.createElement(CATEGORY);
        XMLUtils.setAttribute(element, "name", this.getName());
        XMLUtils.setAttribute(element, "id", this.getId());
        XMLUtils.setAttribute(element, "colour", this.getColourString());
        XMLUtils.setAttribute(element, TAG_COUNT, this.tags.size());
        int i = 0;
        for (Tag tag : this.tags) {
            XMLUtils.setAttribute(element, "tag" + i, tag.getName());
        }
        return element;
    }

    public Category decode(Node node) {
        Category decodedCategory = new Category();
        Element element = (Element)node;
        decodedCategory.setName(element.getAttribute("name"));
        decodedCategory.setId(element.getAttribute("id"));
        decodedCategory.setColour(element.getAttribute("colour"));
        int tagCount = Integer.parseInt(element.getAttribute(TAG_COUNT));
        for (int i = 0; i < tagCount; ++i) {
            decodedCategory.addTag(new Tag(element.getAttribute("tag" + i), decodedCategory.getId()));
        }
        return decodedCategory;
    }

    public String getPropertyID() {
        return "com.thinkbuzan.dozer.tags.Category";
    }
}

