/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities;

import com.thinkbuzan.gaia.entities.Option;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorOption
implements Option {
    private String name = "none";
    private String key;
    private UUID uuid = UUID.randomUUID();
    private final transient Map<Integer, Color> colorMap = new HashMap<Integer, Color>();
    private boolean userOption = false;
    private boolean hidden;
    private boolean unlicensed;
    public static final int BOUNDARY_COLOUR_ID = 10;
    public static final int BOUNDARY_OUTLINE_COLOUR_ID = 11;
    public static final int FONT_COLOUR_ID = 9;
    public static final int BRANCH_COLOUR_OPTIONS = 8;
    private static final Logger LOGGER = Logger.getLogger(ColorOption.class);

    public ColorOption() {
        for (int i = 1; i <= 11; ++i) {
            this.colorMap.put(i, Color.black);
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String nameIn) {
        this.validateSetString(nameIn);
        this.name = nameIn;
    }

    @Override
    public final String getI18nKey() {
        String value;
        if (this.key == null) {
            value = this.name;
            LOGGER.warn((Object)("Option.getI18nKey() called when i18n key = null, userDefined = " + this.userOption + ", " + this));
        } else {
            value = this.key;
        }
        return value;
    }

    @Override
    public final void setI18nKey(String keyIn) {
        this.validateSetString(keyIn);
        this.key = keyIn;
    }

    private void validateSetString(String string) {
        if (string == null || "".equals(string.trim())) {
            throw new IllegalArgumentException("Can't specify an empty string");
        }
    }

    @Override
    public final UUID getUUID() {
        return this.uuid;
    }

    @Override
    public final void setUUID(UUID idIn) {
        this.validateSetId(idIn);
        this.uuid = idIn;
    }

    private void validateSetId(UUID idIn) {
        if (idIn == null) {
            throw new IllegalArgumentException("Invlaid Color Option id!");
        }
    }

    public final Color getColor(int colorId) {
        this.validateGetColor(colorId);
        return this.colorMap.get(colorId);
    }

    private void validateGetColor(int colorId) {
        if (colorId < 1) {
            throw new IllegalArgumentException("Color id should be greater than 0");
        }
    }

    public final Map<Integer, Color> getColors() {
        return this.colorMap;
    }

    public final Color getFontColor() {
        return this.colorMap.get(9);
    }

    public final Color getBoundaryColor() {
        return this.colorMap.get(10);
    }

    public final Color getBoundaryOutlineColor() {
        return this.colorMap.get(11);
    }

    public final void addColor(int colorId, Color color) {
        this.validateAddColor(colorId, color);
        this.colorMap.put(colorId, color);
    }

    private void validateAddColor(int colorId, Color color) {
        if (colorId < 1) {
            throw new IllegalArgumentException("Color id should be greater than 0");
        }
        if (color == null) {
            throw new IllegalArgumentException("Color  should not be null!");
        }
    }

    public final void cleanOption() {
        this.colorMap.clear();
    }

    @Override
    public final boolean isUserDefined() {
        return this.userOption;
    }

    @Override
    public final void setUserDefined(boolean userDefined) {
        this.userOption = userDefined;
    }

    @Override
    public final void setHidden(boolean hiddenIn) {
        this.hidden = hiddenIn;
    }

    @Override
    public final boolean isHidden() {
        return this.hidden;
    }

    @Override
    public final boolean isUnlicensed() {
        return this.unlicensed;
    }

    @Override
    public final void setUnlicensed(boolean unlicensedIn) {
        this.unlicensed = unlicensedIn;
    }

    public final String toString() {
        String message = "%s[uuid=%s, name=%s, userDefined=%s, key=%s, hidden=%s, unlicensed=%s]";
        return String.format("%s[uuid=%s, name=%s, userDefined=%s, key=%s, hidden=%s, unlicensed=%s]", this.getClass().getSimpleName(), this.uuid, this.name, this.userOption, this.key, this.hidden, this.unlicensed);
    }
}

