/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities;

import com.thinkbuzan.gaia.entities.util.XMLUtils;
import com.thinkbuzan.gaia.model.properties.IProperty;
import java.util.Date;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Comment
implements IProperty,
Cloneable {
    private static final long serialVersionUID = 2657664430752312089L;
    private static final Logger LOGGER = Logger.getLogger((String)Comment.class.getName());
    private static final String COMMENT_TAG_NAME = "Comment";
    private static final String AUTHOR_TAG_NAME = "author";
    private static final String DATE_TIME_TAG_NAME = "time";
    private String text;
    private String author;
    private long dateTime;
    public static final String COMMENTS_KEY = "com.thinkbuzan.gaia.entities.Comment";

    public Comment() {
        this.setText("");
        this.setAuthor(System.getProperty("user.name"));
        this.setDateTime(new Date().getTime());
    }

    public Comment(String commentText) {
        this.setText(commentText);
        this.setAuthor(System.getProperty("user.name"));
        this.setDateTime(new Date().getTime());
    }

    public void setText(String commentText) {
        this.validateSetText(commentText);
        this.text = commentText;
    }

    private void validateSetText(String commentText) {
        if (commentText == null) {
            throw new IllegalArgumentException("The text must not be null.");
        }
    }

    public String getText() {
        return this.text;
    }

    public void setAuthor(String authorIn) {
        if (authorIn == null) {
            throw new IllegalArgumentException("The author must not be null.");
        }
        this.author = authorIn;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setDateTime(long currentTimeMillisIn) {
        this.dateTime = currentTimeMillisIn;
    }

    public long getDateTime() {
        return this.dateTime;
    }

    public Node encode(Document document) {
        Element element = document.createElement(COMMENT_TAG_NAME);
        XMLUtils.setAttribute(element, AUTHOR_TAG_NAME, this.getAuthor());
        XMLUtils.setAttribute(element, DATE_TIME_TAG_NAME, this.getDateTime());
        XMLUtils.setTextContent(element, this.getText());
        return element;
    }

    public Comment decode(Node node) {
        Comment decodedComment = new Comment();
        Element element = (Element)node;
        decodedComment.setText(element.getTextContent());
        decodedComment.setAuthor(element.getAttribute(AUTHOR_TAG_NAME));
        try {
            decodedComment.setDateTime(Long.valueOf(element.getAttribute(DATE_TIME_TAG_NAME)));
        }
        catch (NumberFormatException ex) {
            LOGGER.warn((Object)"Could not decode the date time object", (Throwable)ex);
        }
        return decodedComment;
    }

    public String getPropertyID() {
        return COMMENTS_KEY;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "Text: " + this.getText() + "\n" + "Author: " + this.getAuthor() + " Date: " + this.getDateTime();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Comment)) {
            return false;
        }
        Comment otherComment = (Comment)object;
        if (this.author == otherComment.author && this.text == otherComment.text && this.dateTime == otherComment.dateTime) {
            return true;
        }
        if (this.author == null || this.text == null) {
            return false;
        }
        return this.author.equals(otherComment.author) && this.text.equals(otherComment.text) && this.dateTime == otherComment.dateTime;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.author != null) {
            hashCode += this.author.hashCode();
        }
        if (this.text != null) {
            hashCode += this.text.hashCode();
        }
        hashCode = (int)((long)hashCode + this.dateTime);
        return hashCode;
    }
}

