/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities;

import com.thinkbuzan.gaia.entities.util.XMLUtils;
import com.thinkbuzan.gaia.model.properties.IProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Contact
implements IProperty,
Cloneable {
    private static final long serialVersionUID = 3748976829261987488L;
    private static final String CONTACT_TAG = "Contact";
    private static final String CONTACT_USERNAME = "Username";
    private static final String CONTACT_EMAIL = "EmailAddress";
    private String userName;
    private String emailAddress;

    public Contact() {
        this.userName = "";
        this.emailAddress = "";
    }

    public Contact(String name, String email) {
        this.validateName(name);
        this.validateEmailAddress(email);
        this.userName = name;
        this.emailAddress = email;
    }

    private void validateName(String name) {
        if (null == name) {
            throw new IllegalArgumentException("The parameter name should not be null");
        }
    }

    private void validateEmailAddress(String email) {
        if (null == email) {
            throw new IllegalArgumentException("The parameter email should not be null");
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setUserName(String userNameIn) {
        this.validateName(userNameIn);
        this.userName = userNameIn;
    }

    public void setEmailAddress(String emailAddressIn) {
        this.validateEmailAddress(emailAddressIn);
        this.emailAddress = emailAddressIn;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Contact other = (Contact)obj;
        return this.userName.equals(other.userName);
    }

    public int hashCode() {
        return this.userName.hashCode();
    }

    public String toString() {
        return this.userName;
    }

    public Contact decode(Node node) {
        Contact decoded = new Contact();
        decoded.setUserName(XMLUtils.getContent(node, CONTACT_USERNAME));
        decoded.setEmailAddress(XMLUtils.getContent(node, CONTACT_EMAIL));
        return decoded;
    }

    public Node encode(Document doc) {
        Element element = doc.createElement(CONTACT_TAG);
        XMLUtils.appendElement(doc, element, CONTACT_USERNAME, this.userName);
        XMLUtils.appendElement(doc, element, CONTACT_EMAIL, this.emailAddress);
        doc.appendChild(element);
        XMLUtils.save(doc);
        return element;
    }

    public String getPropertyID() {
        return this.getClass().getName();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

