/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities;

import com.thinkbuzan.gaia.entities.FontProperty;
import com.thinkbuzan.gaia.entities.Option;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontOption
implements Option {
    private String name = "none";
    private String key;
    private UUID uuid = UUID.randomUUID();
    private final transient Map<Integer, FontProperty> fontMap = new HashMap<Integer, FontProperty>();
    private boolean userOption = false;
    private static final transient String DEFAULT_FONT_NAME = "Serif";
    private boolean hidden;
    private boolean unlicensed;
    private static final Logger LOGGER = Logger.getLogger(FontOption.class);

    public FontOption() {
        FontProperty fp = new FontProperty(DEFAULT_FONT_NAME, 0, 26);
        for (int i = 1; i <= 8; ++i) {
            this.fontMap.put(i, fp);
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String nameIn) {
        this.validateSetString(nameIn);
        this.name = nameIn;
    }

    @Override
    public final String getI18nKey() {
        String value;
        if (this.key == null) {
            value = this.name;
            LOGGER.warn((Object)("Option.getI18nKey() called when i18n key = null, userDefined = " + this.userOption + ", " + this));
        } else {
            value = this.key;
        }
        return value;
    }

    @Override
    public final void setI18nKey(String keyIn) {
        this.validateSetString(keyIn);
        this.key = keyIn;
    }

    private void validateSetString(String string) {
        if (string == null || "".equals(string.trim())) {
            throw new IllegalArgumentException("Can't specify an empty string");
        }
    }

    public final FontProperty getFont(int fontId) {
        this.validateGetFont(fontId);
        return this.fontMap.get(fontId);
    }

    private void validateGetFont(int fontId) {
        if (fontId < 1) {
            throw new IllegalArgumentException("Font id should be greater than 0");
        }
    }

    public final Map<Integer, FontProperty> getFonts() {
        return this.fontMap;
    }

    public final void addFont(int fontId, FontProperty font) {
        this.validateAddFont(fontId, font);
        this.fontMap.put(fontId, font);
    }

    private void validateAddFont(int fontId, FontProperty font) {
        if (fontId < 1) {
            throw new IllegalArgumentException("Font id should be greater than 0");
        }
        if (font == null) {
            throw new IllegalArgumentException("Font Property  should not be null!");
        }
    }

    @Override
    public final UUID getUUID() {
        return this.uuid;
    }

    @Override
    public final void setUUID(UUID idIn) {
        this.validateSetId(idIn);
        this.uuid = idIn;
    }

    private void validateSetId(UUID idIn) {
        if (idIn == null) {
            throw new IllegalArgumentException("Invlaid Font Option id!");
        }
    }

    public final void clearOption() {
        this.fontMap.clear();
    }

    @Override
    public final boolean isUserDefined() {
        return this.userOption;
    }

    @Override
    public final void setUserDefined(boolean userDefined) {
        this.userOption = userDefined;
    }

    @Override
    public final void setHidden(boolean hiddenIn) {
        this.hidden = hiddenIn;
    }

    @Override
    public final boolean isHidden() {
        return this.hidden;
    }

    @Override
    public final boolean isUnlicensed() {
        return this.unlicensed;
    }

    @Override
    public final void setUnlicensed(boolean unlicensedIn) {
        this.unlicensed = unlicensedIn;
    }

    public final String toString() {
        String message = "%s[uuid=%s, name=%s, userDefined=%s, key=%s, hidden=%s, unlicensed=%s]";
        return String.format("%s[uuid=%s, name=%s, userDefined=%s, key=%s, hidden=%s, unlicensed=%s]", this.getClass().getSimpleName(), this.uuid, this.name, this.userOption, this.key, this.hidden, this.unlicensed);
    }
}

