/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities;

import java.awt.Font;

public class FontProperty
extends Font {
    private static final String PROPERTY_ITALIC = "italic";
    private static final String PROPERTY_BOLD = "bold";
    private static final String PROPERTY_NORMAL = "normal";
    private static final String BOLD_ITALIC = "bold|italic";
    private static final String ITALIC_BOLD = "italic|bold";
    public static final String VARIANT_UPPER_CASE = "upper_case";
    public static final String VARIANT_LOWER_CASE = "lower_case";
    public static final String VARIANT_CAMEL_CASE = "camel_case";
    public static final String VARIANT_DEFAULT_CASE = "default_case";
    private static final long serialVersionUID = 3113903510867484149L;
    private String fontVariant;

    public FontProperty(String name, int style, int size) {
        this(name, style, size, VARIANT_DEFAULT_CASE);
    }

    public FontProperty(String name, int style, int size, String fontVariantIn) {
        super(name, style, size);
        this.validateFontVariant(fontVariantIn);
        this.fontVariant = fontVariantIn;
    }

    public final String getFontVariant() {
        return this.fontVariant;
    }

    public final void setFontVariant(String fontVariantIn) {
        this.validateFontVariant(fontVariantIn);
        this.fontVariant = fontVariantIn;
    }

    private void validateFontVariant(String fontVariantIn) {
        if (fontVariantIn == null) {
            throw new IllegalArgumentException("Font variant can't be null!");
        }
        if (!(VARIANT_CAMEL_CASE.equalsIgnoreCase(fontVariantIn) || VARIANT_DEFAULT_CASE.equalsIgnoreCase(fontVariantIn) || VARIANT_LOWER_CASE.equalsIgnoreCase(fontVariantIn) || VARIANT_UPPER_CASE.equalsIgnoreCase(fontVariantIn))) {
            throw new IllegalArgumentException("Font variant is illegal value.");
        }
    }

    public static int convertStyle(String style) {
        if (BOLD_ITALIC.equalsIgnoreCase(style) || ITALIC_BOLD.equalsIgnoreCase(style)) {
            return 3;
        }
        if (PROPERTY_ITALIC.equalsIgnoreCase(style)) {
            return 2;
        }
        if (PROPERTY_BOLD.equalsIgnoreCase(style)) {
            return 1;
        }
        if (PROPERTY_NORMAL.equalsIgnoreCase(style)) {
            return 0;
        }
        throw new IllegalArgumentException("Does not support this style!");
    }

    public static String getStyleString(int style) {
        if (style == 1) {
            return PROPERTY_BOLD;
        }
        if (style == 2) {
            return PROPERTY_ITALIC;
        }
        if (style == 3) {
            return BOLD_ITALIC;
        }
        return PROPERTY_NORMAL;
    }
}

