/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities;

import com.thinkbuzan.gaia.entities.Option;
import java.util.UUID;
import org.apache.log4j.Logger;

public class GraphicsOption
implements Option {
    public static final String ATTRIBUTE_NAME = "name";
    private String key;
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_UUID = "uuid";
    public static final String ATTRIBUTE_BRANCH_ICON = "branch_icon";
    public static final String ATTRIBUTE_BRANCH_ORDER = "branch_order";
    public static final String ATTRIBUTE_SHADOWS = "shadows";
    public static final String ATTRIBUTE_BOUNDARY_PADDING = "boundary_padding";
    public static final String ATTRIBUTE_BOUNDARY_FREQUENCY = "boundary_frequency";
    public static final String ATTRIBUTE_BOUNDARY_AMPLITUDE = "boundary_amplitude";
    public static final String ATTRIBUTE_ARROW_LINE_STYLE = "arrow_line_style";
    public static final String ATTRIBUTE_BOUNDARY_STYLE = "boundary_style";
    public static final String ATTRIBUTE_BRANCH_THICKNESS = "branch_thickness";
    public static final String ARROW_LINE_STYLE_SOLID = "solid";
    public static final String ARROW_LINE_STYLE_DOTTED = "dotted";
    public static final String ARROW_LINE_STYLE_DASHED = "dashed";
    public static final String BOUNDARY_STYLE_CLOUD = "cloud";
    public static final String BOUNDARY_STYLE_RECTANGLE = "rectangle";
    public static final String BOUNDARY_STYLE_HULL = "hull";
    public static final String BOUNDARY_STYLE_RECTANGLE_ROUNDED = "rounded_rectangle";
    public static final String BOUNDARY_STYLE_HULL_ROUNDED = "rounded_hull";
    public static final String ATTRIBUTE_TEXT_COLOUR_SAME_AS_BRANCH = "text_colour_same_as_branch";
    private static final int DEFAULT_BOUNDARY_PADDING = 2;
    private static final int DEFAULT_BOUNDARY_FREQUENCY = 40;
    private static final int DEFAULT_BOUNDARY_AMPLITUDE = 85;
    private static final int[] DEFAULT_BRANCH_THICKNESS = new int[]{35, 5, 1};
    private String name = "none";
    private UUID uuid = UUID.randomUUID();
    private boolean branchIcon = true;
    private boolean branchOrder = true;
    private boolean shadows = false;
    private int boundaryPadding = 2;
    private int boundaryFrequency = 40;
    private int boundaryAmplitude = 85;
    private String arrowLineStyle = "dashed";
    private String boundaryStyle = "cloud";
    private int[] branchThickness = DEFAULT_BRANCH_THICKNESS;
    private boolean textColourSameAsBranch = false;
    private boolean userOption = false;
    private boolean hidden;
    private boolean unlicensed;
    private static final Logger LOGGER = Logger.getLogger(GraphicsOption.class);

    public final UUID getUUID() {
        return this.uuid;
    }

    public final void setUUID(UUID idIn) {
        this.validateSetId(idIn);
        this.uuid = idIn;
    }

    private void validateSetId(UUID idIn) {
        if (idIn == null) {
            throw new IllegalArgumentException("Invlaid Graphics Option id!");
        }
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String nameIn) {
        this.validateSetString(nameIn);
        this.name = nameIn;
    }

    public final String getI18nKey() {
        String value;
        if (this.key == null) {
            value = this.name;
            LOGGER.warn((Object)("Option.getI18nKey() called when i18n key = null, userDefined = " + this.userOption + ", " + this));
        } else {
            value = this.key;
        }
        return value;
    }

    public final void setI18nKey(String keyIn) {
        this.validateSetString(keyIn);
        this.key = keyIn;
    }

    public final boolean isBranchIcon() {
        return this.branchIcon;
    }

    public final void setBranchIcon(boolean branchIconIn) {
        this.branchIcon = branchIconIn;
    }

    public final boolean isBranchOrder() {
        return this.branchOrder;
    }

    public final void setBranchOrder(boolean branchOrderIn) {
        this.branchOrder = branchOrderIn;
    }

    public final boolean isShadows() {
        return this.shadows;
    }

    public final void setShadows(boolean shadowsIn) {
        this.shadows = shadowsIn;
    }

    public final String getArrowLineStyle() {
        return this.arrowLineStyle;
    }

    public final void setArrowLineStyle(String arrowLineStyleIn) {
        this.validateSetString(arrowLineStyleIn);
        this.validateArrowLineStyle(arrowLineStyleIn);
        this.arrowLineStyle = arrowLineStyleIn;
    }

    public final String getBoundaryStyle() {
        return this.boundaryStyle;
    }

    public final void setBoundaryStyle(String boundaryStyleIn) {
        this.validateSetString(boundaryStyleIn);
        this.validateBoundaryStyle(boundaryStyleIn);
        this.boundaryStyle = boundaryStyleIn;
    }

    public final int getBoundaryPadding() {
        return this.boundaryPadding;
    }

    public final void setBoundaryPadding(int boundaryPaddingIn) {
        this.validateBoundaryRange(boundaryPaddingIn);
        this.boundaryPadding = boundaryPaddingIn;
    }

    public final int getBoundaryFrequency() {
        return this.boundaryFrequency;
    }

    public final void setBoundaryFrequency(int boundaryFrequencyIn) {
        this.validateBoundaryRange(boundaryFrequencyIn);
        this.boundaryFrequency = boundaryFrequencyIn;
    }

    public final int getBoundaryAmplitude() {
        return this.boundaryAmplitude;
    }

    public final void setBoundaryAmplitude(int boundaryAmplitudeIn) {
        this.validateBoundaryRange(boundaryAmplitudeIn);
        this.boundaryAmplitude = boundaryAmplitudeIn;
    }

    public final int[] getBranchThickness() {
        return this.branchThickness;
    }

    public final void setBranchThickness(int[] branchThicknessIn) {
        this.validateSetBranchThickness(branchThicknessIn);
        this.branchThickness = branchThicknessIn;
    }

    public final boolean isTextColourSameAsBranch() {
        return this.textColourSameAsBranch;
    }

    public final void setTextColourSameAsBranch(boolean textColourSameIn) {
        this.textColourSameAsBranch = textColourSameIn;
    }

    private void validateSetString(String string) {
        if (string == null || "".equals(string.trim())) {
            throw new IllegalArgumentException("Can't specify an empty string");
        }
    }

    private void validateBoundaryRange(int value) {
        boolean minRange = true;
        int maxRange = 100;
        if (value < 1 || value > 100) {
            throw new IllegalArgumentException("Boundary padding, frequency or amplitude should be between 1 to 100");
        }
    }

    private void validateSetBranchThickness(int[] branchThicknessIn) {
        int length = 3;
        if (branchThicknessIn == null || branchThicknessIn.length != 3) {
            throw new IllegalArgumentException("Branch thickness array must specify an int array with length of 3");
        }
    }

    private void validateArrowLineStyle(String style) {
        boolean b;
        boolean bl = b = ARROW_LINE_STYLE_SOLID.equals(style) || ARROW_LINE_STYLE_DOTTED.equals(style) || ARROW_LINE_STYLE_DASHED.equals(style);
        if (!b) {
            throw new IllegalArgumentException("Parameter must be one of ARROW_LINE_STYLE_SOLID, ARROW_LINE_STYLE_DOTTED or ARROW_LINE_STYLE_DASHED");
        }
    }

    private void validateBoundaryStyle(String style) {
        boolean b;
        boolean bl = b = BOUNDARY_STYLE_CLOUD.equals(style) || BOUNDARY_STYLE_RECTANGLE.equals(style) || BOUNDARY_STYLE_HULL.equals(style) || BOUNDARY_STYLE_RECTANGLE_ROUNDED.equals(style) || BOUNDARY_STYLE_HULL_ROUNDED.equals(style);
        if (!b) {
            throw new IllegalArgumentException("Parameter must be one of ARROW_LINE_STYLE_SOLID, ARROW_LINE_STYLE_DOTTED or ARROW_LINE_STYLE_DASHED");
        }
    }

    public final boolean isUserDefined() {
        return this.userOption;
    }

    public final void setUserDefined(boolean userDefined) {
        this.userOption = userDefined;
    }

    public final void setHidden(boolean hiddenIn) {
        this.hidden = hiddenIn;
    }

    public final boolean isHidden() {
        return this.hidden;
    }

    public final boolean isUnlicensed() {
        return this.unlicensed;
    }

    public final void setUnlicensed(boolean unlicensedIn) {
        this.unlicensed = unlicensedIn;
    }

    public final String toString() {
        String message = "%s[uuid=%s, name=%s, userDefined=%s, key=%s, hidden=%s, unlicensed=%s]";
        return String.format("%s[uuid=%s, name=%s, userDefined=%s, key=%s, hidden=%s, unlicensed=%s]", this.getClass().getSimpleName(), this.uuid, this.name, this.userOption, this.key, this.hidden, this.unlicensed);
    }
}

