/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities;

import com.thinkbuzan.gaia.model.properties.IProperty;
import java.util.List;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLLabel
implements IProperty,
Cloneable {
    private static final long serialVersionUID = 2657664430752312089L;
    public static final String PROPERTY_KEY = "com.thinkbuzan.gaia.entities.HTMLLabel";
    private static final String HTMLLABEL_TAG_NAME = "HTMLLabel";
    private String label;
    private List<String[]> labelStyleMapping;

    public HTMLLabel() {
        this.setHTML("");
    }

    public final String getPropertyID() {
        return PROPERTY_KEY;
    }

    public final Node encode(Document document) {
        Element element = document.createElement(HTMLLABEL_TAG_NAME);
        CDATASection cdata = document.createCDATASection(this.label);
        element.appendChild(cdata);
        return element;
    }

    public final IProperty decode(Node node) {
        Element element = (Element)node;
        String cdataText = element.getFirstChild().getTextContent();
        HTMLLabel decodedLabel = new HTMLLabel();
        decodedLabel.setHTML(cdataText);
        return decodedLabel;
    }

    public final String getHTML() {
        return this.label;
    }

    public final void setHTML(String htmlIn) {
        this.label = htmlIn;
        this.labelStyleMapping = null;
    }

    public final List<String[]> getLabelStyleMapping() {
        return this.labelStyleMapping;
    }

    public final void setLabelStyleMapping(List<String[]> labelStyleMappingIn) {
        this.labelStyleMapping = labelStyleMappingIn;
    }

    public final String getPlainText() {
        if (this.label != null) {
            return this.label.replaceAll("\\<.*?>", "");
        }
        return "";
    }

    public final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

