/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.entities;

import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.gaia.entities.HyperLinkType;
import com.thinkbuzan.gaia.entities.resources.ResourceManager;
import com.thinkbuzan.gaia.entities.util.XMLUtils;
import com.thinkbuzan.gaia.entities.validate.Validate;
import com.thinkbuzan.gaia.model.properties.IProperty;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.UUID;
import javax.swing.Icon;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class HyperLink
implements IProperty,
Cloneable,
Serializable {
    private static final long serialVersionUID = -628021212925838560L;
    public static final String HYPERLINKS_KEY = "com.thinkbuzan.gaia.cell.hyperlinks";
    public static final String LINK_TYPE_NODE = "linkType";
    public static final String LINK_NODE = "link";
    public static final String LINK_ID = "id";
    public static final String LINK_IS_CHILDMAP = "childMap";
    public static final String LINK_IS_CLOUDMAP = "cloudMap";
    public static final String LINK_CLOUDMAP_ID = "cloudMapId";
    public static final String LINK_IS_AUTOPLAY = "autoplay";
    public static final String LINK_IS_FULLSCREEN = "fullscreen";
    public static final String LINK_IS_PREVIEW = "preview";
    public static final Icon CHILDMAP_ICON = ResourceManager.createImageIcon("childmm_link.png");
    public static final Icon WEB_ICON = ResourceManager.createImageIcon("browser.png");
    public static final Icon FILE_ICON;
    public static final Icon EMAIL_ICON;
    private UUID id;
    private String link;
    private HyperLinkType type;
    private transient Icon icon;
    private boolean isChildMap = false;
    private boolean isCloudMap = false;
    private String cloudMapId;
    private boolean fullscreen = false;
    private boolean autoplay = false;
    private boolean branchPreview = false;
    private transient boolean needRecheck = true;

    public HyperLink() {
        this.setId(UUID.randomUUID());
    }

    public HyperLink(String linkIn, Icon iconIn, HyperLinkType typeIn) {
        this();
        this.link = linkIn;
        this.icon = iconIn;
        this.type = typeIn;
    }

    public HyperLink(HyperLink hyperLink) {
        this();
        this.setId(hyperLink.getId());
        this.setLink(hyperLink.getLink());
        this.setType(hyperLink.getType());
        this.setIcon(hyperLink.getIcon());
        this.setChildMapLink(hyperLink.isChildMapLink());
        this.setAutoplay(hyperLink.isAutoplay());
        this.setFullscreen(this.isFullscreen());
        this.setBranchPreview(this.isBranchPreview());
    }

    public final boolean isRecheck() {
        return this.needRecheck;
    }

    public final void setRecheck(boolean recheckIn) {
        this.needRecheck = recheckIn;
    }

    public final Icon getIcon() {
        if (this.isChildMapLink()) {
            return CHILDMAP_ICON;
        }
        return this.icon;
    }

    public final void setIcon(Icon iconIn) {
        this.icon = iconIn;
    }

    public final HyperLinkType getType() {
        return this.type;
    }

    public final void setType(HyperLinkType typeIn) {
        this.type = typeIn;
    }

    public final void setType(String typeIn) {
        if (typeIn != null) {
            if (typeIn.equals(HyperLinkType.WEB.toString())) {
                this.type = HyperLinkType.WEB;
            } else if (typeIn.equals(HyperLinkType.FILE.toString())) {
                this.type = HyperLinkType.FILE;
            } else if (typeIn.equals(HyperLinkType.EMAIL.toString())) {
                this.type = HyperLinkType.EMAIL;
            }
        } else if (this.type == null) {
            this.type = HyperLinkType.WEB;
        }
    }

    public final String getLink() {
        return this.link;
    }

    public final void setLink(String linkString) {
        this.link = linkString;
    }

    public final UUID getId() {
        return this.id;
    }

    public final void setId(UUID idIn) {
        Validate.notNull(idIn, "idIn");
        this.id = idIn;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("Hyperlink");
        if (null != this.type) {
            sb.append(" type = " + (Object)((Object)this.type));
        }
        if (null != this.link) {
            sb.append(" link = " + this.link);
        }
        return sb.toString();
    }

    public final IProperty decode(Node node) {
        NamedNodeMap attributes;
        Node isFullscreen;
        HyperLink decoded = new HyperLink();
        this.decodeId(node, decoded);
        decoded.setLink(XMLUtils.getContent(node, LINK_NODE));
        decoded.setType(XMLUtils.getContent(node, LINK_TYPE_NODE));
        String decodeIsChildMap = XMLUtils.getContent(node, LINK_IS_CHILDMAP);
        if (decodeIsChildMap != null) {
            decoded.setChildMapLink(decodeIsChildMap);
        }
        String decodeIsCloudMap = XMLUtils.getContent(node, LINK_IS_CLOUDMAP);
        String decodeCloudMapId = XMLUtils.getContent(node, LINK_CLOUDMAP_ID);
        if (decodeIsCloudMap != null && decodeCloudMapId != null) {
            decoded.setCloudMapLink(decodeIsChildMap);
            decoded.setCloudMapId(decodeCloudMapId);
        }
        decoded.setFullscreen((isFullscreen = (attributes = node.getAttributes()).getNamedItem(LINK_IS_FULLSCREEN)) != null && Boolean.valueOf(isFullscreen.getNodeValue()) != false);
        Node isAutoPlay = attributes.getNamedItem(LINK_IS_AUTOPLAY);
        decoded.setAutoplay(isAutoPlay != null && Boolean.valueOf(isAutoPlay.getNodeValue()) != false);
        Node isPreview = attributes.getNamedItem(LINK_IS_PREVIEW);
        decoded.setBranchPreview(isPreview != null && Boolean.valueOf(isPreview.getNodeValue()) != false);
        return decoded;
    }

    private void decodeId(Node node, HyperLink decoded) {
        block3: {
            try {
                String idString = XMLUtils.getContent(node, LINK_ID);
                if (idString != null) {
                    decoded.setId(UUID.fromString(idString));
                }
            }
            catch (Exception exception) {
                if (!Logger.getLogger(HyperLink.class).isWarnEnabled()) break block3;
                Logger.getLogger(HyperLink.class).warn((Object)"Exception caught when decoding HyperLink id", (Throwable)exception);
            }
        }
    }

    public final Node encode(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("param document can not be null");
        }
        Element hyperlinkElement = document.createElement(this.getPropertyID());
        XMLUtils.appendElement(document, hyperlinkElement, LINK_ID, this.getId().toString());
        XMLUtils.appendElement(document, hyperlinkElement, LINK_NODE, this.getLink());
        XMLUtils.appendElement(document, hyperlinkElement, LINK_TYPE_NODE, (Object)this.getType());
        XMLUtils.appendElement(document, hyperlinkElement, LINK_IS_CHILDMAP, this.isChildMap);
        if (this.isCloudMap && this.cloudMapId != null) {
            XMLUtils.appendElement(document, hyperlinkElement, LINK_IS_CLOUDMAP, this.isCloudMap);
            XMLUtils.appendElement(document, hyperlinkElement, LINK_CLOUDMAP_ID, this.cloudMapId);
        }
        if (this.isFullscreen()) {
            hyperlinkElement.setAttribute(LINK_IS_FULLSCREEN, Boolean.toString(this.isFullscreen()));
        }
        if (this.isAutoplay()) {
            hyperlinkElement.setAttribute(LINK_IS_AUTOPLAY, Boolean.toString(this.isAutoplay()));
        }
        if (this.isBranchPreview()) {
            hyperlinkElement.setAttribute(LINK_IS_PREVIEW, Boolean.toString(this.isBranchPreview()));
        }
        return hyperlinkElement;
    }

    public final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public final String getPropertyID() {
        return "hyperlink";
    }

    public final boolean equals(Object object) {
        if (!(object instanceof HyperLink)) {
            return false;
        }
        HyperLink otherHyperLink = (HyperLink)object;
        if (this.id == otherHyperLink.id) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        return this.id.equals(otherHyperLink.id);
    }

    public final int hashCode() {
        int hashCode = 0;
        if (this.id != null) {
            hashCode += this.id.hashCode();
        }
        return hashCode;
    }

    private final void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.needRecheck = true;
    }

    public final boolean isChildMapLink() {
        return this.isChildMap;
    }

    public final void setChildMapLink(boolean isChildMapLink) {
        this.isChildMap = isChildMapLink;
    }

    public final void setChildMapLink(String childMap) {
        this.isChildMap = childMap != null && childMap.equalsIgnoreCase("true");
    }

    public final boolean isCloudMapLink() {
        return this.isCloudMap;
    }

    public final void setCloudMapLink(boolean isCloudMapLink) {
        this.isCloudMap = isCloudMapLink;
    }

    public final void setCloudMapLink(String cloudMap) {
        this.isCloudMap = cloudMap != null && cloudMap.equalsIgnoreCase("true");
    }

    public final String getCloudMapId() {
        return this.cloudMapId;
    }

    public final void setCloudMapId(String mapId) {
        this.cloudMapId = mapId;
    }

    public final boolean isFullscreen() {
        return this.fullscreen;
    }

    public final void setFullscreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
    }

    public final boolean isAutoplay() {
        return this.autoplay;
    }

    public final void setAutoplay(boolean autoplay) {
        this.autoplay = autoplay;
    }

    public final boolean isBranchPreview() {
        return this.branchPreview;
    }

    public final void setBranchPreview(boolean branchPreview) {
        this.branchPreview = branchPreview;
    }

    public final boolean isMediaFile() {
        if (this.getType() == HyperLinkType.FILE) {
            File file = new File(this.getLink());
            if (file.exists()) {
                return file.getAbsolutePath().endsWith(".aif") || file.getAbsolutePath().endsWith(".aiff") || file.getAbsolutePath().endsWith(".flv") || file.getAbsolutePath().endsWith(".fxm") || file.getAbsolutePath().endsWith(".mp3") || file.getAbsolutePath().endsWith(".mp4") || file.getAbsolutePath().endsWith(".m4a") || file.getAbsolutePath().endsWith(".m4v") || file.getAbsolutePath().endsWith(".wav");
            }
        } else if (this.getType() == HyperLinkType.WEB) {
            return this.getLink().endsWith(".aif") || this.getLink().endsWith(".aiff") || this.getLink().endsWith(".flv") || this.getLink().endsWith(".fxm") || this.getLink().endsWith(".mp3") || this.getLink().endsWith(".mp4") || this.getLink().endsWith(".m4a") || this.getLink().endsWith(".m4v") || this.getLink().endsWith(".wav");
        }
        return false;
    }

    public final boolean isMediaURI() {
        return this.getLink().startsWith("https://youtu") || this.getLink().startsWith("https://www.youtube") || this.getLink().startsWith("http://youtu") || this.getLink().startsWith("http://www.youtube");
    }

    public final String getYoutubeVideoId() {
        if (this.getLink().startsWith("https://youtu.be/")) {
            int start = "https://youtu.be/".length();
            int end = Math.max(this.getLink().indexOf("&", start), this.getLink().length());
            return this.getLink().substring(start, end);
        }
        if (this.getLink().startsWith("https://www.youtube.com/watch?v=")) {
            int start = "https://www.youtube.com/watch?v=".length();
            int end = Math.max(this.getLink().indexOf("&", start), this.getLink().length());
            return this.getLink().substring(start, end);
        }
        if (this.getLink().startsWith("http://youtu.be/")) {
            int start = "http://youtu.be/".length();
            int end = Math.max(this.getLink().indexOf("&", start), this.getLink().length());
            return this.getLink().substring(start, end);
        }
        if (this.getLink().startsWith("http://www.youtube.com/watch?v=")) {
            int start = "http://www.youtube.com/watch?v=".length();
            int end = Math.max(this.getLink().indexOf("&", start), this.getLink().length());
            return this.getLink().substring(start, end);
        }
        return null;
    }

    static {
        EMAIL_ICON = ResourceManager.createImageIcon("email.png");
        FILE_ICON = SystemInfo.isAnyMac() ? ResourceManager.createImageIcon("folder_mac.png") : ResourceManager.createImageIcon("file.png");
    }
}

